/*
 * Decompiled with CFR 0.152.
 */
package kamon.statsd;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.statsd.MetricKeyGenerator;
import kamon.statsd.PercentEncoder$;
import kamon.tag.Tag$;
import kamon.tag.TagSet;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a4A!\u0007\u000e\u0001?!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00036\u0001\u0011\u0005a'\u0002\u0003:\u0001\u0001Q\u0004b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\u0016\t\u000f-\u0003!\u0019!C\u0001\u0019\"1Q\n\u0001Q\u0001\nuBqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0015\u0005\b)\u0002\u0011\r\u0011\"\u0001M\u0011\u0019)\u0006\u0001)A\u0005{!9a\u000b\u0001b\u0001\n\u0003y\u0005BB,\u0001A\u0003%\u0001\u000bC\u0004Y\u0001\t\u0007I\u0011A-\t\r\u0001\u0004\u0001\u0015!\u0003[\u0011\u001d\t\u0007A1A\u0005\u0002\tDa!\u001a\u0001!\u0002\u0013\u0019\u0007b\u00024\u0001\u0005\u0004%\t\u0001\u0014\u0005\u0007O\u0002\u0001\u000b\u0011B\u001f\t\u000f!\u0004!\u0019!C\u0001\u0019\"1\u0011\u000e\u0001Q\u0001\nuBQA\u001b\u0001\u0005\n-DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001e\u0001\u0005\nU\u0014\u0001dU5na2,W*\u001a;sS\u000e\\U-_$f]\u0016\u0014\u0018\r^8s\u0015\tYB$\u0001\u0004ti\u0006$8\u000f\u001a\u0006\u0002;\u0005)1.Y7p]\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003iI!!\u000b\u000e\u0003%5+GO]5d\u0017\u0016Lx)\u001a8fe\u0006$xN]\u0001\rgR\fGo\u001d#D_:4\u0017n\u001a\t\u0003YMj\u0011!\f\u0006\u0003]=\naaY8oM&<'B\u0001\u00192\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001a\u0002\u0007\r|W.\u0003\u00025[\t11i\u001c8gS\u001e\fa\u0001P5oSRtDCA\u001c9!\t9\u0003\u0001C\u0003+\u0005\u0001\u00071F\u0001\u0006O_Jl\u0017\r\\5{KJ\u0004B!I\u001e>{%\u0011AH\t\u0002\n\rVt7\r^5p]F\u0002\"AP#\u000f\u0005}\u001a\u0005C\u0001!#\u001b\u0005\t%B\u0001\"\u001f\u0003\u0019a$o\\8u}%\u0011AII\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EE\u0005q1m\u001c8gS\u001e\u001cV\r\u001e;j]\u001e\u001cX#A\u0016\u0002\u001f\r|gNZ5h'\u0016$H/\u001b8hg\u0002\n1b]3sm&\u001cWMT1nKV\tQ(\u0001\u0007tKJ4\u0018nY3OC6,\u0007%A\bj]\u000edW\u000fZ3I_N$h.Y7f+\u0005\u0001\u0006CA\u0011R\u0013\t\u0011&EA\u0004C_>dW-\u00198\u0002!%t7\r\\;eK\"{7\u000f\u001e8b[\u0016\u0004\u0013\u0001\u00035pgRt\u0017-\\3\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0013AF5oG2,H-Z#om&\u0014xN\\7f]R$\u0016mZ:\u0002/%t7\r\\;eK\u0016sg/\u001b:p]6,g\u000e\u001e+bON\u0004\u0013aD3om&\u0014xN\\7f]R$\u0016mZ:\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u000f\u0002\u0007Q\fw-\u0003\u0002`9\n1A+Y4TKR\f\u0001#\u001a8wSJ|g.\\3oiR\u000bwm\u001d\u0011\u0002\u00159|'/\\1mSj,'/F\u0001d!\t!7!D\u0001\u0001\u0003-qwN]7bY&TXM\u001d\u0011\u0002%9|'/\\1mSj,G\rS8ti:\fW.Z\u0001\u0014]>\u0014X.\u00197ju\u0016$\u0007j\\:u]\u0006lW\rI\u0001\tE\u0006\u001cXMT1nK\u0006I!-Y:f\u001d\u0006lW\rI\u0001\u0011GJ,\u0017\r^3O_Jl\u0017\r\\5{KJ$\"a\u00197\t\u000b54\u0002\u0019A\u001f\u0002\u0011M$(/\u0019;fOf\f1bZ3oKJ\fG/Z&fsR\u0019Q\b\u001d:\t\u000bE<\u0002\u0019A\u001f\u0002\t9\fW.\u001a\u0005\u0006g^\u0001\rAW\u0001\u000b[\u0016$(/[2UC\u001e\u001c\u0018AF:peR\fe\u000eZ\"p]\u000e\fG/\u001a8bi\u0016$\u0016mZ:\u0015\u0005u2\b\"B<\u0019\u0001\u0004Q\u0016\u0001\u0002;bON\u0004")
public class SimpleMetricKeyGenerator
implements MetricKeyGenerator {
    private final Config configSettings;
    private final String serviceName;
    private final boolean includeHostname;
    private final String hostname;
    private final boolean includeEnvironmentTags;
    private final TagSet environmentTags;
    private final Function1<String, String> normalizer;
    private final String normalizedHostname;
    private final String baseName;

    public Config configSettings() {
        return this.configSettings;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public boolean includeHostname() {
        return this.includeHostname;
    }

    public String hostname() {
        return this.hostname;
    }

    public boolean includeEnvironmentTags() {
        return this.includeEnvironmentTags;
    }

    public TagSet environmentTags() {
        return this.environmentTags;
    }

    public Function1<String, String> normalizer() {
        return this.normalizer;
    }

    public String normalizedHostname() {
        return this.normalizedHostname;
    }

    public String baseName() {
        return this.baseName;
    }

    private Function1<String, String> createNormalizer(String strategy) {
        Function1 & Serializable intersect;
        block4: {
            String string = strategy;
            switch (string == null ? 0 : string.hashCode()) {
                case 236609293: {
                    if (!"normalize".equals(string)) break;
                    intersect = (Function1 & Serializable)s -> s.replace(": ", "-").replace(":", "-").replace(" ", "_").replace("/", "_").replace(".", "_");
                    break block4;
                }
                case 331275422: {
                    if (!"percent-encode".equals(string)) break;
                    intersect = (Function1 & Serializable)originalString -> PercentEncoder$.MODULE$.encode((String)originalString);
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
        return intersect;
    }

    @Override
    public String generateKey(String name, TagSet metricTags) {
        TagSet tags = this.includeEnvironmentTags() ? metricTags.withTags(this.environmentTags()) : metricTags;
        String stringTags = tags.nonEmpty() ? new StringBuilder(1).append(".").append(this.sortAndConcatenateTags(tags)).toString() : "";
        return new StringBuilder(1).append(this.baseName()).append(".").append(this.normalizer().apply((Object)name)).append(stringTags).toString();
    }

    private String sortAndConcatenateTags(TagSet tags) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)tags.all().sortBy((Function1 & Serializable)tag -> new Tuple2((Object)tag.key(), (Object)Tag$.MODULE$.unwrapValue(tag).toString()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).flatMap((Function1 & Serializable)tag -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tag.key(), Tag$.MODULE$.unwrapValue(tag).toString()})))).map(this.normalizer())).mkString(".");
    }

    public SimpleMetricKeyGenerator(Config statsDConfig) {
        this.configSettings = statsDConfig.getConfig("simple-metric-key-generator");
        this.serviceName = Kamon$.MODULE$.environment().service();
        this.includeHostname = this.configSettings().getBoolean("include-hostname");
        this.hostname = Kamon$.MODULE$.environment().host();
        this.includeEnvironmentTags = this.configSettings().getBoolean("include-environment-tags");
        this.environmentTags = Kamon$.MODULE$.environment().tags();
        this.normalizer = this.createNormalizer(this.configSettings().getString("metric-name-normalization-strategy"));
        this.normalizedHostname = (String)this.normalizer().apply((Object)this.hostname());
        this.baseName = this.includeHostname() ? new StringBuilder(1).append(this.serviceName()).append(".").append(this.normalizedHostname()).toString() : this.serviceName();
    }
}

