/*
 * Decompiled with CFR 0.152.
 */
package kamon.statsd;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.Kamon$;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.module.MetricReporter;
import kamon.module.ModuleFactory;
import kamon.statsd.MetricKeyGenerator;
import kamon.statsd.StatsDReporter$Settings$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011-a\u0001\u00025j\u00019D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u000f\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004C\u0005\u0004\b\u0002\u0001\r\u0011\"\u0003\u0004\n\"A1Q\u0012\u0001!B\u0013\t\u0019\u0004C\u0005\u0004\u0018\u0002\u0011\r\u0011\"\u0001\u0004\u001a\"A1q\u0015\u0001!\u0002\u0013\u0019Y\nC\u0005\u0004*\u0002\u0011\r\u0011\"\u0001\u0004,\"A11\u0017\u0001!\u0002\u0013\u0019i\u000bC\u0005\u00046\u0002\u0011\r\u0011\"\u0001\u00048\"A1\u0011\u0018\u0001!\u0002\u0013\u0011i\u000fC\u0004\u0002\u0010\u0001!\taa/\t\u000f\ru\u0006\u0001\"\u0011\u0004:!91q\u0018\u0001\u0005B\r\u0005\u0007bBBc\u0001\u0011\u00053q\u0019\u0005\b\u0007'\u0004A\u0011BBk\u0011\u001d\u0019\t\u000f\u0001C\u0005\u0007GDqaa=\u0001\t\u0013\u0019)\u0010\u0003\u0005\u0005\u0002\u0001!\t!\u001bC\u0002\u000f\u001d\t9$\u001bE\u0001\u0003s1a\u0001[5\t\u0002\u0005m\u0002bBA\b/\u0011\u0005\u0011Q\b\u0004\u0007\u0003\u007f9\u0002!!\u0011\t\u000f\u0005=\u0011\u0004\"\u0001\u0002J!9\u0011qJ\r\u0005B\u0005EcABA1/\u0001\u000b)\u0007\u0003\u0006\u0002\u0000q\u0011)\u001a!C\u0001\u0003\u0003C!\"a%\u001d\u0005#\u0005\u000b\u0011BAB\u0011)\t)\n\bBK\u0002\u0013\u0005\u0011q\u0013\u0005\u000b\u0003?c\"\u0011#Q\u0001\n\u0005e\u0005BCAQ9\tU\r\u0011\"\u0001\u0002$\"Q\u0011\u0011\u0017\u000f\u0003\u0012\u0003\u0006I!!*\t\u0015\u0005MFD!f\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u00026r\u0011\t\u0012)A\u0005\u0003KC!\"a.\u001d\u0005+\u0007I\u0011AA]\u0011)\t\t\r\bB\tB\u0003%\u00111\u0018\u0005\u000b\u0003\u0007d\"Q3A\u0005\u0002\u0005\u0015\u0007BCAg9\tE\t\u0015!\u0003\u0002H\"Q\u0011q\u001a\u000f\u0003\u0016\u0004%\t!!5\t\u0015\u0005eGD!E!\u0002\u0013\t\u0019\u000eC\u0004\u0002\u0010q!\t!a7\t\u0013\u00055H$!A\u0005\u0002\u0005=\b\"CA\u00009E\u0005I\u0011\u0001B\u0001\u0011%\u00119\u0002HI\u0001\n\u0003\u0011I\u0002C\u0005\u0003\u001eq\t\n\u0011\"\u0001\u0003 !I!1\u0005\u000f\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005Ka\u0012\u0013!C\u0001\u0005OA\u0011Ba\u000b\u001d#\u0003%\tA!\f\t\u0013\tEB$%A\u0005\u0002\tM\u0002\"\u0003B\u001c9\u0005\u0005I\u0011\tB\u001d\u0011%\u0011)\u0005HA\u0001\n\u0003\t)\rC\u0005\u0003Hq\t\t\u0011\"\u0001\u0003J!I!Q\u000b\u000f\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u0005Kb\u0012\u0011!C\u0001\u0005OB\u0011Ba\u001b\u001d\u0003\u0003%\tE!\u001c\t\u0013\tED$!A\u0005B\tM\u0004\"\u0003B;9\u0005\u0005I\u0011\tB<\u0011%\u0011I\bHA\u0001\n\u0003\u0012YhB\u0004\u0003\u0000]A\tA!!\u0007\u000f\u0005\u0005t\u0003#\u0001\u0003\u0004\"9\u0011q\u0002 \u0005\u0002\t=\u0005b\u0002BI}\u0011\u0005!1\u0013\u0005\b\u0005WsD\u0011\u0002BW\u0011%\u0011)LPA\u0001\n\u0003\u00139\fC\u0005\u0003Hz\n\t\u0011\"!\u0003J\"I!1\u001c \u0002\u0002\u0013%!Q\u001c\u0004\b\u0005K<\u0002!\u001bBt\u0011)\u0011I/\u0012B\u0001B\u0003%\u0011\u0011\u0014\u0005\u000b\u0003\u0007,%\u0011!Q\u0001\n\u0005\u001d\u0007B\u0003Bv\u000b\n\u0005\t\u0015!\u0003\u0003n\"Q!Q`#\u0003\u0002\u0003\u0006I!a!\t\u000f\u0005=Q\t\"\u0001\u0003\u0000\"I11B#C\u0002\u0013\u00051Q\u0002\u0005\t\u0007\u007f)\u0005\u0015!\u0003\u0004\u0010!I1\u0011I#C\u0002\u0013\u0005!\u0011\b\u0005\t\u0007\u0007*\u0005\u0015!\u0003\u0003<!I1QI#C\u0002\u0013\u0005!\u0011\b\u0005\t\u0007\u000f*\u0005\u0015!\u0003\u0003<!I1\u0011J#A\u0002\u0013\u0005!\u0011\b\u0005\n\u0007\u0017*\u0005\u0019!C\u0001\u0007\u001bB\u0001b!\u0015FA\u0003&!1\b\u0005\n\u0007'*\u0005\u0019!C\u0001\u0007+B\u0011ba\u0019F\u0001\u0004%\ta!\u001a\t\u0011\r%T\t)Q\u0005\u0007/Bqaa\u001bF\t\u0003\u0019i\u0007C\u0004\u0004x\u0015#Ia!\u001f\t\u000f\r}T\t\"\u0001\u0004:!91\u0011Q#\u0005\n\r\reaBB\t/\u0001I71\u0003\u0005\u000b\u0003\u0007\\&\u0011!Q\u0001\n\u0005\u001d\u0007bBA\b7\u0012\u00051Q\u0003\u0005\n\u00073Y&\u0019!C\u0005\u0003/C\u0001ba\u0007\\A\u0003%\u0011\u0011\u0014\u0005\n\u0007;Y\u0006\u0019!C\u0005\u0003/C\u0011ba\b\\\u0001\u0004%Ia!\t\t\u0011\r-2\f)Q\u0005\u00033C\u0011b!\f\\\u0001\u0004%I!!2\t\u0013\r=2\f1A\u0005\n\rE\u0002\u0002CB\u001b7\u0002\u0006K!a2\t\u000f\r]2\f\"\u0001\u0004:!911H.\u0005\n\ru\"AD*uCR\u001cHIU3q_J$XM\u001d\u0006\u0003U.\faa\u001d;biN$'\"\u00017\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0019\u0001a\\;\u0011\u0005A\u001cX\"A9\u000b\u0003I\fQa]2bY\u0006L!\u0001^9\u0003\r\u0005s\u0017PU3g!\t1\u00180D\u0001x\u0015\tA8.\u0001\u0004n_\u0012,H.Z\u0005\u0003u^\u0014a\"T3ue&\u001c'+\u001a9peR,'/\u0001\u0006d_:4\u0017n\u001a)bi\"\u00042!`A\u0005\u001d\rq\u0018Q\u0001\t\u0003\u007fFl!!!\u0001\u000b\u0007\u0005\rQ.\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000f\t\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\bE\fa\u0001P5oSRtD\u0003BA\n\u0003/\u00012!!\u0006\u0001\u001b\u0005I\u0007\"B>\u0003\u0001\u0004a\u0018A\u00027pO\u001e,'/\u0006\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B:mMRR'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\t\tC\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003U\u0011X\r]8si\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:,\"!a\r\u0011\u0007\u0005UBDD\u0002\u0002\u0016Y\tab\u0015;biN$%+\u001a9peR,'\u000fE\u0002\u0002\u0016]\u0019\"aF8\u0015\u0005\u0005e\"a\u0002$bGR|'/_\n\u00053=\f\u0019\u0005E\u0002w\u0003\u000bJ1!a\u0012x\u00055iu\u000eZ;mK\u001a\u000b7\r^8ssR\u0011\u00111\n\t\u0004\u0003\u001bJR\"A\f\u0002\r\r\u0014X-\u0019;f)\u0011\t\u0019\"a\u0015\t\u000f\u0005U3\u00041\u0001\u0002X\u0005A1/\u001a;uS:<7\u000f\u0005\u0003\u0002Z\u0005}cb\u0001<\u0002\\%\u0019\u0011QL<\u0002\u001b5{G-\u001e7f\r\u0006\u001cGo\u001c:z\u0013\u0011\t\t'a\u0019\u0003\u0011M+G\u000f^5oONT1!!\u0018x'\u0019ar.a\u001a\u0002nA\u0019\u0001/!\u001b\n\u0007\u0005-\u0014OA\u0004Qe>$Wo\u0019;\u0011\t\u0005=\u0014\u0011\u0010\b\u0005\u0003c\n)HD\u0002\u0000\u0003gJ\u0011A]\u0005\u0004\u0003o\n\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003w\niH\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002xE\fA\"Y4f]R\fE\r\u001a:fgN,\"!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006\u0019a.\u001a;\u000b\u0005\u00055\u0015\u0001\u00026bm\u0006LA!!%\u0002\b\n\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0002\u001b\u0005<WM\u001c;BI\u0012\u0014Xm]:!\u00035i\u0017\r\u001f)bG.,GoU5{KV\u0011\u0011\u0011\u0014\t\u0004a\u0006m\u0015bAAOc\n!Aj\u001c8h\u00039i\u0017\r\u001f)bG.,GoU5{K\u0002\n\u0001\u0002^5nKVs\u0017\u000e^\u000b\u0003\u0003K\u0003B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W[\u0017AB7fiJL7-\u0003\u0003\u00020\u0006%&aD'fCN,(/Z7f]R,f.\u001b;\u0002\u0013QLW.Z+oSR\u0004\u0013aD5oM>\u0014X.\u0019;j_:,f.\u001b;\u0002!%tgm\u001c:nCRLwN\\+oSR\u0004\u0013\u0001D6fs\u001e+g.\u001a:bi>\u0014XCAA^!\u0011\t)\"!0\n\u0007\u0005}\u0016N\u0001\nNKR\u0014\u0018nY&fs\u001e+g.\u001a:bi>\u0014\u0018!D6fs\u001e+g.\u001a:bi>\u0014\b%\u0001\nnCb\u0004\u0016mY6fiN\u0004VM]'jY2LWCAAd!\r\u0001\u0018\u0011Z\u0005\u0004\u0003\u0017\f(aA%oi\u0006\u0019R.\u0019=QC\u000e\\W\r^:QKJl\u0015\u000e\u001c7jA\u0005q1/\u001a8e5\u0016\u0014xNV1mk\u0016\u001cXCAAj!\r\u0001\u0018Q[\u0005\u0004\u0003/\f(a\u0002\"p_2,\u0017M\\\u0001\u0010g\u0016tGMW3s_Z\u000bG.^3tAQ\u0001\u0012Q\\Ap\u0003C\f\u0019/!:\u0002h\u0006%\u00181\u001e\t\u0004\u0003\u001bb\u0002bBA@W\u0001\u0007\u00111\u0011\u0005\b\u0003+[\u0003\u0019AAM\u0011\u001d\t\tk\u000ba\u0001\u0003KCq!a-,\u0001\u0004\t)\u000bC\u0004\u00028.\u0002\r!a/\t\u000f\u0005\r7\u00061\u0001\u0002H\"9\u0011qZ\u0016A\u0002\u0005M\u0017\u0001B2paf$\u0002#!8\u0002r\u0006M\u0018Q_A|\u0003s\fY0!@\t\u0013\u0005}D\u0006%AA\u0002\u0005\r\u0005\"CAKYA\u0005\t\u0019AAM\u0011%\t\t\u000b\fI\u0001\u0002\u0004\t)\u000bC\u0005\u000242\u0002\n\u00111\u0001\u0002&\"I\u0011q\u0017\u0017\u0011\u0002\u0003\u0007\u00111\u0018\u0005\n\u0003\u0007d\u0003\u0013!a\u0001\u0003\u000fD\u0011\"a4-!\u0003\u0005\r!a5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0001\u0016\u0005\u0003\u0007\u0013)a\u000b\u0002\u0003\bA!!\u0011\u0002B\n\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C;oG\",7m[3e\u0015\r\u0011\t\"]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u000b\u0005\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0007+\t\u0005e%QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tC\u000b\u0003\u0002&\n\u0015\u0011AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011IC\u000b\u0003\u0002<\n\u0015\u0011AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0005_QC!a2\u0003\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:TC\u0001B\u001bU\u0011\t\u0019N!\u0002\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0004\u0005\u0003\u0003>\t\rSB\u0001B \u0015\u0011\u0011\t%a#\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\u0011y$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t-#\u0011\u000b\t\u0004a\n5\u0013b\u0001B(c\n\u0019\u0011I\\=\t\u0013\tMc'!AA\u0002\u0005\u001d\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003ZA1!1\fB1\u0005\u0017j!A!\u0018\u000b\u0007\t}\u0013/\u0001\u0006d_2dWm\u0019;j_:LAAa\u0019\u0003^\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019N!\u001b\t\u0013\tM\u0003(!AA\u0002\t-\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u000f\u0003p!I!1K\u001d\u0002\u0002\u0003\u0007\u0011qY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qY\u0001\ti>\u001cFO]5oOR\u0011!1H\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M'Q\u0010\u0005\n\u0005'b\u0014\u0011!a\u0001\u0005\u0017\n\u0001bU3ui&twm\u001d\t\u0004\u0003\u001br4\u0003\u0002 p\u0005\u000b\u0003BAa\"\u0003\u000e6\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u000bY)\u0001\u0002j_&!\u00111\u0010BE)\t\u0011\t)\u0001\u0007sK\u0006$7+\u001a;uS:<7\u000f\u0006\u0003\u00024\tU\u0005bBA\u0018\u0001\u0002\u0007!q\u0013\t\u0005\u00053\u00139+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003\u0019\u0019wN\u001c4jO*!!\u0011\u0015BR\u0003!!\u0018\u0010]3tC\u001a,'B\u0001BS\u0003\r\u0019w.\\\u0005\u0005\u0005S\u0013YJ\u0001\u0004D_:4\u0017nZ\u0001\u0011Y>\fGmS3z\u000f\u0016tWM]1u_J$b!a/\u00030\nM\u0006B\u0002BY\u0003\u0002\u0007A0\u0001\tlKf<UM\\3sCR|'OR)D\u001d\"9!QT!A\u0002\t]\u0015!B1qa2LH\u0003EAo\u0005s\u0013YL!0\u0003@\n\u0005'1\u0019Bc\u0011\u001d\tyH\u0011a\u0001\u0003\u0007Cq!!&C\u0001\u0004\tI\nC\u0004\u0002\"\n\u0003\r!!*\t\u000f\u0005M&\t1\u0001\u0002&\"9\u0011q\u0017\"A\u0002\u0005m\u0006bBAb\u0005\u0002\u0007\u0011q\u0019\u0005\b\u0003\u001f\u0014\u0005\u0019AAj\u0003\u001d)h.\u00199qYf$BAa3\u0003XB)\u0001O!4\u0003R&\u0019!qZ9\u0003\r=\u0003H/[8o!E\u0001(1[AB\u00033\u000b)+!*\u0002<\u0006\u001d\u00171[\u0005\u0004\u0005+\f(A\u0002+va2,w\u0007C\u0005\u0003Z\u000e\u000b\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t}\u0007\u0003\u0002B\u001f\u0005CLAAa9\u0003@\t1qJ\u00196fGR\u0014a#T3ue&\u001cG)\u0019;b!\u0006\u001c7.\u001a;Ck\u001a4WM]\n\u0003\u000b>\fA#\\1y!\u0006\u001c7.\u001a;TSj,\u0017J\u001c\"zi\u0016\u001c\u0018aB2iC:tW\r\u001c\t\u0005\u0005_\u0014I0\u0004\u0002\u0003r*!!1\u001fB{\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002\u0002B|\u0003\u0017\u000b1A\\5p\u0013\u0011\u0011YP!=\u0003\u001f\u0011\u000bG/Y4sC6\u001c\u0005.\u00198oK2\faA]3n_R,GCCB\u0001\u0007\u0007\u0019)aa\u0002\u0004\nA\u0019\u0011QJ#\t\u000f\t%(\n1\u0001\u0002\u001a\"9\u00111\u0019&A\u0002\u0005\u001d\u0007b\u0002Bv\u0015\u0002\u0007!Q\u001e\u0005\b\u0005{T\u0005\u0019AAB\u0003-\u0011\u0018\r^3MS6LG/\u001a:\u0016\u0005\r=\u0001cAA'7\n\u0001b\t\\;tQJ\u000bG/\u001a'j[&$XM]\n\u00037>$Baa\u0004\u0004\u0018!9\u00111Y/A\u0002\u0005\u001d\u0017!C:uCJ$H+[7f\u0003)\u0019H/\u0019:u)&lW\rI\u0001\nY\u0006\u001cH/T5mY&\fQ\u0002\\1ti6KG\u000e\\5`I\u0015\fH\u0003BB\u0012\u0007S\u00012\u0001]B\u0013\u0013\r\u00199#\u001d\u0002\u0005+:LG\u000fC\u0005\u0003T\u0005\f\t\u00111\u0001\u0002\u001a\u0006QA.Y:u\u001b&dG.\u001b\u0011\u0002!\r|WO\u001c;Bi2\u000b7\u000f^'jY2L\u0017\u0001F2pk:$\u0018\t\u001e'bgRl\u0015\u000e\u001c7j?\u0012*\u0017\u000f\u0006\u0003\u0004$\rM\u0002\"\u0003B*I\u0006\u0005\t\u0019AAd\u0003E\u0019w.\u001e8u\u0003Rd\u0015m\u001d;NS2d\u0017\u000eI\u0001\u0010o\u0006LG/\u00134OK\u000e,7o]1ssR\u001111E\u0001\rGV\u0014(/\u001a8u\u001b&dG.\u001b\u000b\u0003\u00033\u000bAB]1uK2KW.\u001b;fe\u0002\nq\"\\3ue&\u001c7+\u001a9be\u0006$xN]\u0001\u0011[\u0016$(/[2TKB\f'/\u0019;pe\u0002\nA#\\3bgV\u0014X-\\3oiN+\u0007/\u0019:bi>\u0014\u0018!F7fCN,(/Z7f]R\u001cV\r]1sCR|'\u000fI\u0001\bY\u0006\u001cHoS3z\u0003-a\u0017m\u001d;LKf|F%Z9\u0015\t\r\r2q\n\u0005\n\u0005'\u0012\u0016\u0011!a\u0001\u0005w\t\u0001\u0002\\1ti.+\u0017\u0010I\u0001\u0007EV4g-\u001a:\u0016\u0005\r]\u0003\u0003BB-\u0007?j!aa\u0017\u000b\t\ru#QL\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019\tga\u0017\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0005\u0007G\u00199\u0007C\u0005\u0003TU\u000b\t\u00111\u0001\u0004X\u00059!-\u001e4gKJ\u0004\u0013!E1qa\u0016tG-T3bgV\u0014X-\\3oiR111EB8\u0007gBaa!\u001dX\u0001\u0004a\u0018aA6fs\"11QO,A\u0002q\fq\"\\3bgV\u0014X-\\3oi\u0012\u000bG/Y\u0001\rM&$8o\u00148Ck\u001a4WM\u001d\u000b\u0005\u0003'\u001cY\b\u0003\u0004\u0004~a\u0003\r\u0001`\u0001\u0005I\u0006$\u0018-A\u0003gYV\u001c\b.\u0001\u0006gYV\u001c\b\u000eV8V\tB#Baa\t\u0004\u0006\"11Q\u0010.A\u0002q\f\u0011D]3q_J$XM]\"p]\u001aLw-\u001e:bi&|gn\u0018\u0013fcR!11EBF\u0011%\u0011\u0019FBA\u0001\u0002\u0004\t\u0019$\u0001\fsKB|'\u000f^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8!Q\r91\u0011\u0013\t\u0004a\u000eM\u0015bABKc\nAao\u001c7bi&dW-A\u0004ts6\u0014w\u000e\\:\u0016\u0005\rm\u0005\u0003BBO\u0007Gk!aa(\u000b\t\r\u0005\u00161R\u0001\u0005i\u0016DH/\u0003\u0003\u0004&\u000e}%\u0001\u0006#fG&l\u0017\r\u001c$pe6\fGoU=nE>d7/\u0001\u0005ts6\u0014w\u000e\\:!\u0003I\u0019\u0018-\u001c9mS:<'+\u0019;f\r>\u0014X.\u0019;\u0016\u0005\r5\u0006\u0003BBO\u0007_KAa!-\u0004 \niA)Z2j[\u0006dgi\u001c:nCR\f1c]1na2Lgn\u001a*bi\u00164uN]7bi\u0002\nQb\u00197jK:$8\t[1o]\u0016dWC\u0001Bw\u00039\u0019G.[3oi\u000eC\u0017M\u001c8fY\u0002\"\"!a\u0005\u0002\tM$x\u000e]\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0004$\r\r\u0007b\u0002BO!\u0001\u0007!qS\u0001\u0015e\u0016\u0004xN\u001d;QKJLw\u000eZ*oCB\u001c\bn\u001c;\u0015\t\r\r2\u0011\u001a\u0005\b\u0007\u0017\f\u0002\u0019ABg\u0003!\u0019h.\u00199tQ>$\b\u0003BAT\u0007\u001fLAa!5\u0002*\nq\u0001+\u001a:j_\u0012\u001cf.\u00199tQ>$\u0018aE3oG>$Wm\u0015;biN$5i\\;oi\u0016\u0014Hc\u0002?\u0004X\u000ee7Q\u001c\u0005\b\u0005;\u0013\u0002\u0019AA\u001a\u0011\u001d\u0019YN\u0005a\u0001\u00033\u000bQaY8v]RDqaa8\u0013\u0001\u0004\t)+\u0001\u0003v]&$\u0018!E3oG>$Wm\u0015;biN$u)Y;hKR9Ap!:\u0004h\u000eE\bb\u0002BO'\u0001\u0007\u00111\u0007\u0005\b\u0007S\u001c\u0002\u0019ABv\u0003\u00151\u0018\r\\;f!\r\u00018Q^\u0005\u0004\u0007_\f(A\u0002#pk\ndW\rC\u0004\u0004`N\u0001\r!!*\u0002#\u0015t7m\u001c3f'R\fGo\u001d#US6,'\u000fF\u0005}\u0007o\u001cIp!@\u0004\u0000\"9!Q\u0014\u000bA\u0002\u0005M\u0002bBB~)\u0001\u0007\u0011\u0011T\u0001\u0006Y\u00164X\r\u001c\u0005\b\u00077$\u0002\u0019AAM\u0011\u001d\u0019y\u000e\u0006a\u0001\u0003K\u000bQa]2bY\u0016$\u0002ba;\u0005\u0006\u0011\u001dA\u0011\u0002\u0005\b\u0005;+\u0002\u0019AA\u001a\u0011\u001d\u0019I/\u0006a\u0001\u00033Cqaa8\u0016\u0001\u0004\t)\u000b")
public class StatsDReporter
implements MetricReporter {
    private final String configPath;
    private final Logger logger;
    private volatile Settings reporterConfiguration;
    private final DecimalFormatSymbols symbols;
    private final DecimalFormat samplingRateFormat;
    private final DatagramChannel clientChannel;

    private Logger logger() {
        return this.logger;
    }

    private Settings reporterConfiguration() {
        return this.reporterConfiguration;
    }

    private void reporterConfiguration_$eq(Settings x$1) {
        this.reporterConfiguration = x$1;
    }

    public DecimalFormatSymbols symbols() {
        return this.symbols;
    }

    public DecimalFormat samplingRateFormat() {
        return this.samplingRateFormat;
    }

    public DatagramChannel clientChannel() {
        return this.clientChannel;
    }

    public void stop() {
    }

    public void reconfigure(Config config) {
        this.reporterConfiguration_$eq(StatsDReporter$Settings$.MODULE$.readSettings(config.getConfig(this.configPath)));
        this.logger().info("The configuration was reloaded successfully.");
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        MetricKeyGenerator keyGenerator = this.reporterConfiguration().keyGenerator();
        MetricDataPacketBuffer packetBuffer = new MetricDataPacketBuffer(this.reporterConfiguration().maxPacketSize(), this.reporterConfiguration().maxPacketsPerMilli(), this.clientChannel(), this.reporterConfiguration().agentAddress());
        snapshot.counters().foreach((Function1 & Serializable)counter -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$1(this, packetBuffer, keyGenerator, counter);
            return BoxedUnit.UNIT;
        });
        snapshot.gauges().foreach((Function1 & Serializable)gauge -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$3(this, packetBuffer, keyGenerator, gauge);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)((IterableOps)snapshot.histograms().$plus$plus((IterableOnce)snapshot.rangeSamplers())).$plus$plus((IterableOnce)snapshot.timers())).foreach((Function1 & Serializable)metric -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$5(this, packetBuffer, keyGenerator, metric);
            return BoxedUnit.UNIT;
        });
        packetBuffer.flush();
    }

    private String encodeStatsDCounter(Settings config, long count, MeasurementUnit unit) {
        return new java.lang.StringBuilder(2).append(this.scale(config, count, unit)).append("|c").toString();
    }

    private String encodeStatsDGauge(Settings config, double value, MeasurementUnit unit) {
        return new java.lang.StringBuilder(2).append(this.scale(config, (long)value, unit)).append("|g").toString();
    }

    private String encodeStatsDTimer(Settings config, long level, long count, MeasurementUnit unit) {
        double samplingRate = 1.0 / (double)count;
        String sampled = samplingRate != 1.0 ? new java.lang.StringBuilder(2).append("|@").append(this.samplingRateFormat().format(samplingRate)).toString() : "";
        return new java.lang.StringBuilder(3).append(this.scale(config, level, unit)).append("|ms").append(sampled).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double scale(Settings config, long value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = config.timeUnit().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert((double)value, unit, config.timeUnit());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = config.informationUnit().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert((double)value, unit, config.informationUnit());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert((double)value, unit, config.informationUnit());
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$2(StatsDReporter $this, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, MetricSnapshot counter$1, Instrument.Snapshot instrument) {
        block0: {
            if (BoxesRunTime.unboxToLong((Object)instrument.value()) == 0L && !$this.reporterConfiguration().sendZeroValues()) break block0;
            packetBuffer$1.appendMeasurement(keyGenerator$1.generateKey(counter$1.name(), instrument.tags()), $this.encodeStatsDCounter($this.reporterConfiguration(), BoxesRunTime.unboxToLong((Object)instrument.value()), ((Metric.Settings$.ForValueInstrument)counter$1.settings()).unit()));
        }
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$1(StatsDReporter $this, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, MetricSnapshot counter) {
        counter.instruments().foreach((Function1 & Serializable)instrument -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$2($this, packetBuffer$1, keyGenerator$1, counter, instrument);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$4(StatsDReporter $this, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, MetricSnapshot gauge$1, Instrument.Snapshot instrument) {
        block0: {
            if (BoxesRunTime.unboxToDouble((Object)instrument.value()) == 0.0 && !$this.reporterConfiguration().sendZeroValues()) break block0;
            packetBuffer$1.appendMeasurement(keyGenerator$1.generateKey(gauge$1.name(), instrument.tags()), $this.encodeStatsDGauge($this.reporterConfiguration(), BoxesRunTime.unboxToDouble((Object)instrument.value()), ((Metric.Settings$.ForValueInstrument)gauge$1.settings()).unit()));
        }
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$3(StatsDReporter $this, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, MetricSnapshot gauge) {
        gauge.instruments().foreach((Function1 & Serializable)instrument -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$4($this, packetBuffer$1, keyGenerator$1, gauge, instrument);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$7(StatsDReporter $this, MetricSnapshot metric$1, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, Instrument.Snapshot instrument$1, Distribution.Bucket bucket) {
        block0: {
            if (bucket.value() == 0L && !$this.reporterConfiguration().sendZeroValues()) break block0;
            String bucketData = $this.encodeStatsDTimer($this.reporterConfiguration(), bucket.value(), bucket.frequency(), ((Metric.Settings$.ForDistributionInstrument)metric$1.settings()).unit());
            packetBuffer$1.appendMeasurement(keyGenerator$1.generateKey(metric$1.name(), instrument$1.tags()), bucketData);
        }
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$6(StatsDReporter $this, MetricSnapshot metric$1, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, Instrument.Snapshot instrument) {
        ((Distribution)instrument.value()).bucketsIterator().foreach((Function1 & Serializable)bucket -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$7($this, metric$1, packetBuffer$1, keyGenerator$1, instrument, bucket);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$5(StatsDReporter $this, MetricDataPacketBuffer packetBuffer$1, MetricKeyGenerator keyGenerator$1, MetricSnapshot metric) {
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            StatsDReporter.$anonfun$reportPeriodSnapshot$6($this, metric, packetBuffer$1, keyGenerator$1, instrument);
            return BoxedUnit.UNIT;
        });
    }

    public StatsDReporter(String configPath) {
        this.configPath = configPath;
        this.logger = LoggerFactory.getLogger(StatsDReporter.class);
        this.reporterConfiguration = StatsDReporter$Settings$.MODULE$.readSettings(Kamon$.MODULE$.config().getConfig(configPath));
        this.symbols = DecimalFormatSymbols.getInstance(Locale.US);
        this.symbols().setDecimalSeparator('.');
        this.samplingRateFormat = new DecimalFormat("#.################################################################", this.symbols());
        this.clientChannel = DatagramChannel.open();
        this.logger().info("Started the Kamon StatsD reporter");
    }

    public StatsDReporter() {
        this("kamon.statsd");
    }

    public static class Factory
    implements ModuleFactory {
        public StatsDReporter create(ModuleFactory.Settings settings) {
            return new StatsDReporter();
        }
    }

    public static class FlushRateLimiter {
        private final int maxPacketsPerMilli;
        private final long startTime;
        private long lastMilli;
        private int countAtLastMilli;

        private long startTime() {
            return this.startTime;
        }

        private long lastMilli() {
            return this.lastMilli;
        }

        private void lastMilli_$eq(long x$1) {
            this.lastMilli = x$1;
        }

        private int countAtLastMilli() {
            return this.countAtLastMilli;
        }

        private void countAtLastMilli_$eq(int x$1) {
            this.countAtLastMilli = x$1;
        }

        public void waitIfNecessary() {
            long current = this.currentMilli();
            if (current == this.lastMilli()) {
                if (this.countAtLastMilli() < this.maxPacketsPerMilli) {
                    this.countAtLastMilli_$eq(this.countAtLastMilli() + 1);
                } else {
                    Thread.sleep(1L);
                    this.lastMilli_$eq(this.currentMilli());
                    this.countAtLastMilli_$eq(1);
                }
            } else {
                this.lastMilli_$eq(current);
                this.countAtLastMilli_$eq(1);
            }
        }

        private long currentMilli() {
            return (System.nanoTime() - this.startTime()) / 1000000L;
        }

        public FlushRateLimiter(int maxPacketsPerMilli) {
            this.maxPacketsPerMilli = maxPacketsPerMilli;
            this.startTime = System.nanoTime();
            this.lastMilli = this.currentMilli();
            this.countAtLastMilli = 0;
        }
    }

    public static class MetricDataPacketBuffer {
        private final long maxPacketSizeInBytes;
        private final DatagramChannel channel;
        private final InetSocketAddress remote;
        private final FlushRateLimiter rateLimiter;
        private final String metricSeparator;
        private final String measurementSeparator;
        private String lastKey;
        private StringBuilder buffer;

        public FlushRateLimiter rateLimiter() {
            return this.rateLimiter;
        }

        public String metricSeparator() {
            return this.metricSeparator;
        }

        public String measurementSeparator() {
            return this.measurementSeparator;
        }

        public String lastKey() {
            return this.lastKey;
        }

        public void lastKey_$eq(String x$1) {
            this.lastKey = x$1;
        }

        public StringBuilder buffer() {
            return this.buffer;
        }

        public void buffer_$eq(StringBuilder x$1) {
            this.buffer = x$1;
        }

        public void appendMeasurement(String key, String measurementData) {
            String string = key;
            String string2 = this.lastKey();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String dataWithoutKey = new java.lang.StringBuilder(0).append(this.measurementSeparator()).append(measurementData).toString();
                if (this.fitsOnBuffer(dataWithoutKey)) {
                    this.buffer().append(dataWithoutKey);
                } else {
                    this.flush();
                    this.buffer().append(key).append(dataWithoutKey);
                }
            } else {
                this.lastKey_$eq(key);
                String dataWithoutSeparator = new java.lang.StringBuilder(0).append(key).append(this.measurementSeparator()).append(measurementData).toString();
                if (this.fitsOnBuffer(new java.lang.StringBuilder(0).append(this.metricSeparator()).append(dataWithoutSeparator).toString())) {
                    String mSeparator = this.buffer().nonEmpty() ? this.metricSeparator() : "";
                    this.buffer().append(mSeparator).append(dataWithoutSeparator);
                } else {
                    this.flush();
                    this.buffer().append(dataWithoutSeparator);
                }
            }
        }

        private boolean fitsOnBuffer(String data) {
            return (long)(this.buffer().length() + data.length()) <= this.maxPacketSizeInBytes;
        }

        public void flush() {
            this.rateLimiter().waitIfNecessary();
            this.flushToUDP(this.buffer().toString());
            this.buffer().clear();
        }

        private void flushToUDP(String data) {
            this.channel.send(ByteBuffer.wrap(data.getBytes()), this.remote);
        }

        public MetricDataPacketBuffer(long maxPacketSizeInBytes, int maxPacketsPerMilli, DatagramChannel channel, InetSocketAddress remote) {
            this.maxPacketSizeInBytes = maxPacketSizeInBytes;
            this.channel = channel;
            this.remote = remote;
            this.rateLimiter = new FlushRateLimiter(maxPacketsPerMilli);
            this.metricSeparator = "\n";
            this.measurementSeparator = ":";
            this.lastKey = "";
            this.buffer = new StringBuilder();
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final InetSocketAddress agentAddress;
        private final long maxPacketSize;
        private final MeasurementUnit timeUnit;
        private final MeasurementUnit informationUnit;
        private final MetricKeyGenerator keyGenerator;
        private final int maxPacketsPerMilli;
        private final boolean sendZeroValues;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public InetSocketAddress agentAddress() {
            return this.agentAddress;
        }

        public long maxPacketSize() {
            return this.maxPacketSize;
        }

        public MeasurementUnit timeUnit() {
            return this.timeUnit;
        }

        public MeasurementUnit informationUnit() {
            return this.informationUnit;
        }

        public MetricKeyGenerator keyGenerator() {
            return this.keyGenerator;
        }

        public int maxPacketsPerMilli() {
            return this.maxPacketsPerMilli;
        }

        public boolean sendZeroValues() {
            return this.sendZeroValues;
        }

        public Settings copy(InetSocketAddress agentAddress, long maxPacketSize, MeasurementUnit timeUnit, MeasurementUnit informationUnit, MetricKeyGenerator keyGenerator, int maxPacketsPerMilli, boolean sendZeroValues) {
            return new Settings(agentAddress, maxPacketSize, timeUnit, informationUnit, keyGenerator, maxPacketsPerMilli, sendZeroValues);
        }

        public InetSocketAddress copy$default$1() {
            return this.agentAddress();
        }

        public long copy$default$2() {
            return this.maxPacketSize();
        }

        public MeasurementUnit copy$default$3() {
            return this.timeUnit();
        }

        public MeasurementUnit copy$default$4() {
            return this.informationUnit();
        }

        public MetricKeyGenerator copy$default$5() {
            return this.keyGenerator();
        }

        public int copy$default$6() {
            return this.maxPacketsPerMilli();
        }

        public boolean copy$default$7() {
            return this.sendZeroValues();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.agentAddress();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.maxPacketSize());
                    break;
                }
                case 2: {
                    object = this.timeUnit();
                    break;
                }
                case 3: {
                    object = this.informationUnit();
                    break;
                }
                case 4: {
                    object = this.keyGenerator();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this.maxPacketsPerMilli());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.sendZeroValues());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "agentAddress";
                    break;
                }
                case 1: {
                    string = "maxPacketSize";
                    break;
                }
                case 2: {
                    string = "timeUnit";
                    break;
                }
                case 3: {
                    string = "informationUnit";
                    break;
                }
                case 4: {
                    string = "keyGenerator";
                    break;
                }
                case 5: {
                    string = "maxPacketsPerMilli";
                    break;
                }
                case 6: {
                    string = "sendZeroValues";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.agentAddress()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.maxPacketSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeUnit()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.informationUnit()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.keyGenerator()));
            n = Statics.mix((int)n, (int)this.maxPacketsPerMilli());
            n = Statics.mix((int)n, (int)(this.sendZeroValues() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            if (this.maxPacketSize() != settings.maxPacketSize()) return false;
            if (this.maxPacketsPerMilli() != settings.maxPacketsPerMilli()) return false;
            if (this.sendZeroValues() != settings.sendZeroValues()) return false;
            InetSocketAddress inetSocketAddress = this.agentAddress();
            InetSocketAddress inetSocketAddress2 = settings.agentAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            MeasurementUnit measurementUnit = this.timeUnit();
            MeasurementUnit measurementUnit2 = settings.timeUnit();
            if (measurementUnit == null) {
                if (measurementUnit2 != null) {
                    return false;
                }
            } else if (!measurementUnit.equals(measurementUnit2)) return false;
            MeasurementUnit measurementUnit3 = this.informationUnit();
            MeasurementUnit measurementUnit4 = settings.informationUnit();
            if (measurementUnit3 == null) {
                if (measurementUnit4 != null) {
                    return false;
                }
            } else if (!measurementUnit3.equals(measurementUnit4)) return false;
            MetricKeyGenerator metricKeyGenerator = this.keyGenerator();
            MetricKeyGenerator metricKeyGenerator2 = settings.keyGenerator();
            if (metricKeyGenerator == null) {
                if (metricKeyGenerator2 != null) {
                    return false;
                }
            } else if (!metricKeyGenerator.equals(metricKeyGenerator2)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(InetSocketAddress agentAddress, long maxPacketSize, MeasurementUnit timeUnit, MeasurementUnit informationUnit, MetricKeyGenerator keyGenerator, int maxPacketsPerMilli, boolean sendZeroValues) {
            this.agentAddress = agentAddress;
            this.maxPacketSize = maxPacketSize;
            this.timeUnit = timeUnit;
            this.informationUnit = informationUnit;
            this.keyGenerator = keyGenerator;
            this.maxPacketsPerMilli = maxPacketsPerMilli;
            this.sendZeroValues = sendZeroValues;
            Product.$init$((Product)this);
        }
    }
}

