/*
 * Decompiled with CFR 0.152.
 */
package kamon.status.page;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.ClassLoading$;
import kamon.Kamon$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.status.page.StatusPageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class StatusPage
implements Module {
    private final String configPath;
    private final Logger _logger;
    private volatile Option<StatusPageServer> _statusPageServer;

    public StatusPage(String configPath) {
        this.configPath = configPath;
        this._logger = LoggerFactory.getLogger(StatusPage.class);
        this._statusPageServer = None$.MODULE$;
        this.init(Kamon$.MODULE$.config().getConfig(configPath));
    }

    public StatusPage() {
        this("kamon.status-page");
    }

    public void stop() {
        this.stopServer();
    }

    public void reconfigure(Config newConfig) {
        this.init(newConfig.getConfig(this.configPath));
    }

    private void init(Config config) {
        StatusPage statusPage = this;
        synchronized (statusPage) {
            String hostname = config.getString("listen.hostname");
            int port = config.getInt("listen.port");
            boolean retryOnRandomPort = config.getBoolean("listen.retry-on-random-port");
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this._statusPageServer.fold((Function0 & Serializable)() -> {
                this.init$$anonfun$1(hostname, port, retryOnRandomPort);
                return BoxedUnit.UNIT;
            }, (Function1)(JProcedure1 & Serializable)existentServer -> {
                String string = existentServer.getHostname();
                String string2 = hostname;
                if ((string != null ? !string.equals(string2) : string2 != null) || existentServer.getListeningPort() != port) {
                    this.stopServer();
                    this.startServer(hostname, port, ClassLoading$.MODULE$.classLoader(), retryOnRandomPort);
                    return;
                }
            });
        }
    }

    private void startServer(String hostname, int port, ClassLoader resourceLoader, boolean retryOnRandomPort) {
        Try try_;
        block2: {
            while (true) {
                if ((try_ = Try$.MODULE$.apply(() -> StatusPage.startServer$$anonfun$1(hostname, resourceLoader, port))) instanceof Success) {
                    StatusPageServer server = (StatusPageServer)((Success)try_).value();
                    this._logger.info(new StringBuilder(32).append("Status Page started on http://").append(hostname).append(":").append(server.getListeningPort()).append("/").toString());
                    this._statusPageServer = Some$.MODULE$.apply((Object)server);
                    return;
                }
                if (!(try_ instanceof Failure)) break block2;
                if (!retryOnRandomPort) break;
                int n = 0;
                boolean bl = false;
                port = n;
                retryOnRandomPort = bl;
            }
            Throwable t = ((Failure)try_).exception();
            this._logger.error("Failed to start the status page embedded server", t);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void stopServer() {
        this._statusPageServer.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.stop());
        this._statusPageServer = None$.MODULE$;
    }

    private final void init$$anonfun$1(String hostname$1, int port$1, boolean retryOnRandomPort$1) {
        this.startServer(hostname$1, port$1, ClassLoading$.MODULE$.classLoader(), retryOnRandomPort$1);
    }

    private static final StatusPageServer startServer$$anonfun$1(String hostname$3, ClassLoader resourceLoader$1, int port$tailLocal1$1) {
        StatusPageServer server = new StatusPageServer(hostname$3, port$tailLocal1$1, resourceLoader$1, Kamon$.MODULE$.status());
        server.start();
        return server;
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new StatusPage();
        }
    }
}

