/*
 * Decompiled with CFR 0.152.
 */
package kamon.status.page;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kamon.lib.fi.iki.elonen.NanoHTTPD;
import kamon.status.Status;
import kamon.status.page.JsonMarshalling;
import kamon.status.page.JsonMarshalling$BaseInfoJsonMarshalling$;
import kamon.status.page.JsonMarshalling$InstrumentationStatusJsonMarshalling$;
import kamon.status.page.JsonMarshalling$MetricRegistryStatusJsonMarshalling$;
import kamon.status.page.JsonMarshalling$ModuleRegistryStatusJsonMarshalling$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.compat.Platform$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class StatusPageServer
extends NanoHTTPD {
    private final ClassLoader resourceLoader;
    private final Status status;
    private final String RootResourceDirectory;
    private final Regex ResourceExtensionRegex;
    private final NanoHTTPD.Response NotAllowed;
    private final NanoHTTPD.Response NotFound;

    public StatusPageServer(String hostname, int port, ClassLoader resourceLoader, Status status) {
        this.resourceLoader = resourceLoader;
        this.status = status;
        super(hostname, port);
        this.RootResourceDirectory = "status-page";
        this.ResourceExtensionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\.([a-zA-Z0-9]*)"));
        this.NotAllowed = NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, "text/plain", "Only GET requests are allowed.");
        this.NotFound = NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "The requested resource was not found.");
        this.NotAllowed.closeConnection(true);
        this.NotFound.closeConnection(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response response;
        NanoHTTPD.Method method = session.getMethod();
        NanoHTTPD.Method method2 = NanoHTTPD.Method.GET;
        if (method == null) {
            if (method2 != null) {
                return this.NotAllowed;
            }
        } else if (!((Object)((Object)method)).equals((Object)method2)) return this.NotAllowed;
        try {
            if (session.getUri().startsWith("/status")) {
                String string = session.getUri();
                switch (string == null ? 0 : string.hashCode()) {
                    case -153600619: {
                        if (!"/status/metrics".equals(string)) break;
                        response = this.json(this.status.metricRegistry(), JsonMarshalling$MetricRegistryStatusJsonMarshalling$.MODULE$);
                        return response;
                    }
                    case 118006873: {
                        if (!"/status/modules".equals(string)) break;
                        response = this.json(this.status.moduleRegistry(), JsonMarshalling$ModuleRegistryStatusJsonMarshalling$.MODULE$);
                        return response;
                    }
                    case 1402132881: {
                        if (!"/status/settings".equals(string)) break;
                        response = this.json(this.status.settings(), JsonMarshalling$BaseInfoJsonMarshalling$.MODULE$);
                        return response;
                    }
                    case 1429977664: {
                        if (!"/status/instrumentation".equals(string)) break;
                        response = this.json(this.status.instrumentation(), JsonMarshalling$InstrumentationStatusJsonMarshalling$.MODULE$);
                        return response;
                    }
                }
                response = this.NotFound;
                return response;
            }
            String string = session.getUri();
            String string2 = "/";
            String requestedResource = !(string != null ? !string.equals(string2) : string2 != null) ? "/index.html" : session.getUri();
            String resourcePath = new StringBuilder(0).append(this.RootResourceDirectory).append(requestedResource).toString();
            InputStream resourceStream = this.resourceLoader.getResourceAsStream(resourcePath);
            if (resourceStream == null) {
                response = this.NotFound;
                return response;
            }
            response = this.resource(requestedResource, resourceStream);
            return response;
        }
        catch (Throwable t) {
            response = this.serverError(t);
        }
        return response;
    }

    @Override
    public void start() {
        this.setAsyncRunner(new ThreadPoolRunner(Executors.newFixedThreadPool(2)));
        this.start(5000, false);
    }

    private String mimeType(String resource) {
        String resourceExtension;
        String string;
        List list;
        Option option;
        String string2 = resource;
        if (string2 == null || (option = this.ResourceExtensionRegex.unapplySeq((CharSequence)string2)).isEmpty() || (list = (List)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)string2);
        }
        String resourceExtension2 = string = (String)list.apply(0);
        String string3 = resourceExtension = resourceExtension2;
        switch (string3 == null ? 0 : string3.hashCode()) {
            case 3401: {
                if (!"js".equals(string3)) break;
                return "application/javascript";
            }
            case 98819: {
                if (!"css".equals(string3)) break;
                return "text/css";
            }
            case 104085: {
                if (!"ico".equals(string3)) break;
                return "image/x-icon";
            }
            case 114276: {
                if (!"svg".equals(string3)) break;
                return "image/svg+xml";
            }
            case 3213227: {
                if (!"html".equals(string3)) break;
                return "text/html";
            }
            case 113307034: {
                if (!"woff2".equals(string3)) break;
                return "font/woff2";
            }
        }
        return "text/plain";
    }

    private <T> NanoHTTPD.Response json(T instance, JsonMarshalling<T> marshalling) {
        StringBuilder builder = new StringBuilder();
        marshalling.toJson(instance, builder);
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", builder.toString());
        response.closeConnection(true);
        return response;
    }

    private NanoHTTPD.Response resource(String name, InputStream stream) {
        NanoHTTPD.Response response = NanoHTTPD.newChunkedResponse(NanoHTTPD.Response.Status.OK, this.mimeType(name), stream);
        response.closeConnection(true);
        return response;
    }

    private NanoHTTPD.Response serverError(Throwable cause) {
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", new StringBuilder(34).append("Failed to serve request due to: \n\n").append(Predef$.MODULE$.wrapRefArray((Object[])cause.getStackTrace()).mkString("", Platform$.MODULE$.EOL(), Platform$.MODULE$.EOL())).toString());
    }

    public static final /* synthetic */ void kamon$status$page$StatusPageServer$ThreadPoolRunner$$_$closeAll$$anonfun$1(NanoHTTPD.ClientHandler _$1) {
        _$1.close();
    }

    public class ThreadPoolRunner
    implements NanoHTTPD.AsyncRunner {
        private final ExecutorService executorService;
        private final java.util.List<NanoHTTPD.ClientHandler> _openRequests;

        public ThreadPoolRunner(ExecutorService executorService) {
            this.executorService = executorService;
            this._openRequests = Collections.synchronizedList(new LinkedList());
        }

        @Override
        public void closeAll() {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this._openRequests).asScala()).foreach((Function1)((JProcedure1 & Serializable)StatusPageServer::kamon$status$page$StatusPageServer$ThreadPoolRunner$$_$closeAll$$anonfun$1));
        }

        @Override
        public void closed(NanoHTTPD.ClientHandler clientHandler) {
            this._openRequests.remove(clientHandler);
        }

        @Override
        public void exec(NanoHTTPD.ClientHandler clientHandler) {
            this.executorService.submit(clientHandler);
            this._openRequests.add(clientHandler);
        }
    }
}

