/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rug\u0001B2e\u00015D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\t\u0011%\t\u0019\u0003\u0001a\u0001\n\u0013\t)\u0003C\u0005\u0003&\u0001\u0001\r\u0011\"\u0003\u0003(!A!\u0011\u0007\u0001!B\u0013\t9\u0003C\u0005\u0003<\u0001\u0011\r\u0011\"\u0003\u0003>!A!Q \u0001!\u0002\u0013\u0011y\u0004C\u0005\u0003\u0000\u0002\u0011\r\u0011\"\u0003\u0004\u0002!A1q\u000f\u0001!\u0002\u0013\u0019\u0019\u0001C\u0005\u0004z\u0001\u0011\r\u0011\"\u0003\u0004|!A11\u0013\u0001!\u0002\u0013\u0019i\bC\u0005\u0004\u001e\u0002\u0011\r\u0011\"\u0003\u0004 \"A1\u0011\u0016\u0001!\u0002\u0013\u0019\t\u000bC\u0004\u0004,\u0002!\tE!\u0016\t\u000f\r5\u0006\u0001\"\u0011\u00040\"91\u0011\u001a\u0001\u0005\n\r-\u0007bBBh\u0001\u0011%1\u0011\u001b\u0004\n\u0005\u0013\u0002\u0001\u0013aI\u0001\u0005\u0017BqA!\u0014\u0015\r\u0003\u0011y\u0005C\u0004\u0003TQ1\tA!\u0016\u0007\r\t\r\u0003\u0001\u0002B#\u0011\u001d\t\u0019a\u0006C\u0001\u0005/B\u0011B!\u0017\u0018\u0005\u0004%IAa\u0017\t\u0011\t%t\u0003)A\u0005\u0005;B\u0011Ba\u001b\u0018\u0005\u0004%IA!\u001c\t\u0011\tmt\u0003)A\u0005\u0005_B\u0011B! \u0018\u0005\u0004%IAa \t\u0011\t5u\u0003)A\u0005\u0005\u0003C\u0011Ba$\u0018\u0005\u0004%IA!%\t\u0011\t]v\u0003)A\u0005\u0005'C\u0011B!/\u0018\u0001\u0004%IAa/\t\u0013\t%w\u00031A\u0005\n\t-\u0007\u0002\u0003Bh/\u0001\u0006KA!0\t\u000f\t5s\u0003\"\u0001\u0003R\"9!1K\f\u0005\u0002\tU\u0003b\u0002Bk/\u0011%!Q\u000b\u0005\b\u0005/<B\u0011\u0002Bm\r\u0019\u0019)\u0001\u0001\u0003\u0004\b!9\u00111\u0001\u0015\u0005\u0002\r%\u0001\"\u0003B-Q\t\u0007I\u0011\u0002B.\u0011!\u0011I\u0007\u000bQ\u0001\n\tu\u0003\"\u0003B6Q\t\u0007I\u0011\u0002B7\u0011!\u0011Y\b\u000bQ\u0001\n\t=\u0004\"\u0003B?Q\t\u0007I\u0011\u0002B@\u0011!\u0011i\t\u000bQ\u0001\n\t\u0005\u0005\"CB\u0006Q\t\u0007I\u0011BB\u0007\u0011!\u0019y\u0002\u000bQ\u0001\n\r=\u0001\"CB\u0011Q\t\u0007I\u0011BB\u0012\u0011!\u0019Y\u0003\u000bQ\u0001\n\r\u0015\u0002\"CB\u0017Q\t\u0007I\u0011BB\u0018\u0011!\u00199\u0004\u000bQ\u0001\n\rE\u0002\"CB\u001dQ\t\u0007I\u0011BB\u001e\u0011!\u0019\u0019\u0005\u000bQ\u0001\n\ru\u0002\"CB#Q\t\u0007I\u0011BB$\u0011!\u0019y\u0005\u000bQ\u0001\n\r%\u0003\"CB)Q\t\u0007I\u0011BB*\u0011!\u0019Y\u0006\u000bQ\u0001\n\rU\u0003\"CB/Q\t\u0007I\u0011BB0\u0011!\u00199\u0007\u000bQ\u0001\n\r\u0005\u0004b\u0002B'Q\u0011\u00051\u0011\u000e\u0005\b\u0005'BC\u0011\u0001B+\u0011\u001d\u0019i\u0007\u000bC\u0005\u0005+Bqaa\u001c)\t\u0013\u0011)\u0006C\u0004\u0004r!\"IA!\u0016\t\u000f\rM\u0004\u0006\"\u0003\u0003V!91Q\u000f\u0015\u0005\n\tUsaBA\u0016I\"\u0005\u0011Q\u0006\u0004\u0007G\u0012D\t!a\f\t\u000f\u0005\ra\t\"\u0001\u00022\u00191\u00111\u0007$\u0001\u0003kAq!a\u0001I\t\u0003\ti\u0004C\u0004\u0002D!#\t%!\u0012\u0007\r\u0005Uc\tQA-\u0011)\t9g\u0013BK\u0002\u0013\u0005\u0011\u0011\u000e\u0005\u000b\u0003oZ%\u0011#Q\u0001\n\u0005-\u0004BCA=\u0017\nU\r\u0011\"\u0001\u0002j!Q\u00111P&\u0003\u0012\u0003\u0006I!a\u001b\t\u000f\u0005\r1\n\"\u0001\u0002~!I\u0011QQ&\u0002\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u001b[\u0015\u0013!C\u0001\u0003\u001fC\u0011\"!*L#\u0003%\t!a$\t\u0013\u0005\u001d6*!A\u0005B\u0005=\u0001\"CAU\u0017\u0006\u0005I\u0011AAV\u0011%\t\u0019lSA\u0001\n\u0003\t)\fC\u0005\u0002B.\u000b\t\u0011\"\u0011\u0002D\"I\u0011\u0011[&\u0002\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003;\\\u0015\u0011!C!\u0003?D\u0011\"!9L\u0003\u0003%\t%a9\t\u0013\u0005\u00158*!A\u0005B\u0005\u001dx!CAv\r\u0006\u0005\t\u0012AAw\r%\t)FRA\u0001\u0012\u0003\ty\u000fC\u0004\u0002\u0004u#\t!!@\t\u0013\u0005\u0005X,!A\u0005F\u0005\r\b\"CA\u0000;\u0006\u0005I\u0011\u0011B\u0001\u0011%\u00119!XA\u0001\n\u0003\u0013I\u0001C\u0005\u0003\u001cu\u000b\t\u0011\"\u0003\u0003\u001e\t!\u0002j\\:u\u001b\u0016$(/[2t\u0007>dG.Z2u_JT!!\u001a4\u0002\t!|7\u000f\u001e\u0006\u0003O\"\faa]=ti\u0016l'BA5k\u0003=Ign\u001d;sk6,g\u000e^1uS>t'\"A6\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0019\u0001A\u001c;\u0011\u0005=\u0014X\"\u00019\u000b\u0003E\fQa]2bY\u0006L!a\u001d9\u0003\r\u0005s\u0017PU3g!\t)\b0D\u0001w\u0015\t9(.\u0001\u0004n_\u0012,H.Z\u0005\u0003sZ\u0014a!T8ek2,\u0017AA3d!\tax0D\u0001~\u0015\tq\b/\u0001\u0006d_:\u001cWO\u001d:f]RL1!!\u0001~\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\u000f\tY\u0001E\u0002\u0002\n\u0001i\u0011\u0001\u001a\u0005\u0006u\n\u0001\ra_\u0001\f?\u000e|gNZ5h!\u0006$\b.\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)B\u0001\u0004TiJLgnZ\u0001\r?\u000e|gNZ5h!\u0006$\b\u000eI\u0001\n?N,G\u000f^5oON,\"!a\n\u0011\u0007\u0005%2JD\u0002\u0002\n\u0015\u000bA\u0003S8ti6+GO]5dg\u000e{G\u000e\\3di>\u0014\bcAA\u0005\rN\u0011aI\u001c\u000b\u0003\u0003[\u0011qAR1di>\u0014\u0018p\u0005\u0003I]\u0006]\u0002cA;\u0002:%\u0019\u00111\b<\u0003\u001b5{G-\u001e7f\r\u0006\u001cGo\u001c:z)\t\ty\u0004E\u0002\u0002B!k\u0011AR\u0001\u0007GJ,\u0017\r^3\u0015\u0007Q\f9\u0005C\u0004\u0002J)\u0003\r!a\u0013\u0002\u0011M,G\u000f^5oON\u0004B!!\u0014\u0002T9\u0019Q/a\u0014\n\u0007\u0005Ec/A\u0007N_\u0012,H.\u001a$bGR|'/_\u0005\u0005\u0003+\n9F\u0001\u0005TKR$\u0018N\\4t\u0015\r\t\tF^\n\u0007\u0017:\fY&!\u0019\u0011\u0007=\fi&C\u0002\u0002`A\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002p\u0003GJ1!!\u001aq\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003E!(/Y2lK\u0012Le\u000e^3sM\u0006\u001cWm]\u000b\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cR\u0017\u0001B;uS2LA!!\u001e\u0002p\t1a)\u001b7uKJ\f!\u0003\u001e:bG.,G-\u00138uKJ4\u0017mY3tA\u0005iAO]1dW\u0016$Wj\\;oiN\fa\u0002\u001e:bG.,G-T8v]R\u001c\b\u0005\u0006\u0004\u0002\u0000\u0005\u0005\u00151\u0011\t\u0004\u0003\u0003Z\u0005bBA4!\u0002\u0007\u00111\u000e\u0005\b\u0003s\u0002\u0006\u0019AA6\u0003\u0011\u0019w\u000e]=\u0015\r\u0005}\u0014\u0011RAF\u0011%\t9'\u0015I\u0001\u0002\u0004\tY\u0007C\u0005\u0002zE\u0003\n\u00111\u0001\u0002l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAIU\u0011\tY'a%,\u0005\u0005U\u0005\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a(q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\u000bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00032a\\AX\u0013\r\t\t\f\u001d\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003o\u000bi\fE\u0002p\u0003sK1!a/q\u0005\r\te.\u001f\u0005\n\u0003\u007f3\u0016\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAc!\u0019\t9-!4\u000286\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017\u0004\u0018AC2pY2,7\r^5p]&!\u0011qZAe\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u00171\u001c\t\u0004_\u0006]\u0017bAAma\n9!i\\8mK\u0006t\u0007\"CA`1\u0006\u0005\t\u0019AA\\\u0003!A\u0017m\u001d5D_\u0012,GCAAW\u0003!!xn\u0015;sS:<GCAA\t\u0003\u0019)\u0017/^1mgR!\u0011Q[Au\u0011%\tylWA\u0001\u0002\u0004\t9,\u0001\u0005TKR$\u0018N\\4t!\r\t\t%X\n\u0006;\u0006E\u0018\u0011\r\t\u000b\u0003g\fI0a\u001b\u0002l\u0005}TBAA{\u0015\r\t9\u0010]\u0001\beVtG/[7f\u0013\u0011\tY0!>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002n\u0006)\u0011\r\u001d9msR1\u0011q\u0010B\u0002\u0005\u000bAq!a\u001aa\u0001\u0004\tY\u0007C\u0004\u0002z\u0001\u0004\r!a\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\u0002B\f!\u0015y'Q\u0002B\t\u0013\r\u0011y\u0001\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f=\u0014\u0019\"a\u001b\u0002l%\u0019!Q\u00039\u0003\rQ+\b\u000f\\33\u0011%\u0011I\"YA\u0001\u0002\u0004\ty(A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0004\t\u0005\u0003'\u0011\t#\u0003\u0003\u0003$\u0005U!AB(cU\u0016\u001cG/A\u0007`g\u0016$H/\u001b8hg~#S-\u001d\u000b\u0005\u0005S\u0011y\u0003E\u0002p\u0005WI1A!\fq\u0005\u0011)f.\u001b;\t\u0013\u0005}f!!AA\u0002\u0005\u001d\u0012AC0tKR$\u0018N\\4tA!\u001aqA!\u000e\u0011\u0007=\u00149$C\u0002\u0003:A\u0014\u0001B^8mCRLG.Z\u0001\u0013?\u001a\u0014X-];f]R\u001cu\u000e\u001c7fGR|'/\u0006\u0002\u0003@A\u0019!\u0011I\f\u000e\u0003\u0001\u0011aC\u0012:fcV,g\u000e^\"pY2,7\r^5p]R\u000b7o[\n\u0005/9\u00149\u0005E\u0002\u0003BQ\u0011abQ8mY\u0016\u001cG/[8o)\u0006\u001c8n\u0005\u0002\u0015]\u0006A1o\u00195fIVdW\r\u0006\u0003\u0003*\tE\u0003\"\u0002>\u0016\u0001\u0004Y\u0018aB2mK\u0006tW\u000f\u001d\u000b\u0003\u0005S!\"Aa\u0010\u0002\u0019}#WMZ1vYR$\u0016mZ:\u0016\u0005\tu\u0003\u0003\u0002B0\u0005Kj!A!\u0019\u000b\u0007\t\r$.A\u0002uC\u001eLAAa\u001a\u0003b\t1A+Y4TKR\fQb\u00183fM\u0006,H\u000e\u001e+bON\u0004\u0013aC0tsN$X-\\%oM>,\"Aa\u001c\u0011\t\tE$qO\u0007\u0003\u0005gR!A!\u001e\u0002\t=\u001c\b.[\u0005\u0005\u0005s\u0012\u0019H\u0001\u0006TsN$X-\\%oM>\fAbX:zgR,W.\u00138g_\u0002\nAa\u00185bYV\u0011!\u0011\u0011\t\u0005\u0005\u0007\u0013I)\u0004\u0002\u0003\u0006*!!q\u0011B:\u0003!A\u0017M\u001d3xCJ,\u0017\u0002\u0002BF\u0005\u000b\u0013\u0001\u0004S1sI^\f'/Z!cgR\u0014\u0018m\u0019;j_:d\u0015-_3s\u0003\u0015y\u0006.\u00197!\u0003=y6\r];J]N$(/^7f]R\u001cXC\u0001BJ!\u0011\u0011)J!-\u000f\t\t]%Q\u0016\b\u0005\u00053\u0013YK\u0004\u0003\u0003\u001c\n%f\u0002\u0002BO\u0005OsAAa(\u0003&6\u0011!\u0011\u0015\u0006\u0004\u0005Gc\u0017A\u0002\u001fs_>$h(C\u0001l\u0013\tI'.\u0003\u0002hQ&\u0011QMZ\u0005\u0004\u0005_#\u0017a\u0003%pgRlU\r\u001e:jGNLAAa-\u00036\nq1\t];J]N$(/^7f]R\u001c(b\u0001BXI\u0006\u0001rl\u00199v\u0013:\u001cHO];nK:$8\u000fI\u0001\u0012?B\u0014XM^\"qk2{\u0017\r\u001a+jG.\u001cXC\u0001B_!\u0015y'q\u0018Bb\u0013\r\u0011\t\r\u001d\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004_\n\u0015\u0017b\u0001Bda\n!Aj\u001c8h\u0003Uy\u0006O]3w\u0007B,Hj\\1e)&\u001c7n]0%KF$BA!\u000b\u0003N\"I\u0011q\u0018\u0012\u0002\u0002\u0003\u0007!QX\u0001\u0013?B\u0014XM^\"qk2{\u0017\r\u001a+jG.\u001c\b\u0005\u0006\u0003\u0003*\tM\u0007\"\u0002>%\u0001\u0004Y\u0018A\u0004:fG>\u0014Hm\u00119v+N\fw-Z\u0001\ni&\u001c7n\u001d#jM\u001a$\u0002Ba1\u0003\\\n}'1\u001d\u0005\b\u0005;<\u0003\u0019\u0001B_\u0003!\u0001(/\u001a<j_V\u001c\bb\u0002BqO\u0001\u0007!QX\u0001\bGV\u0014(/\u001a8u\u0011\u001d\u0011)o\na\u0001\u0005O\f\u0001\u0002^5dWRK\b/\u001a\t\u0005\u0005S\u00149P\u0004\u0003\u0003l\nMh\u0002\u0002Bw\u0005ctAAa(\u0003p&\u0011!QO\u0005\u0005\u0005\u000f\u0013\u0019(\u0003\u0003\u0003v\n\u0015\u0015\u0001E\"f]R\u0014\u0018\r\u001c)s_\u000e,7o]8s\u0013\u0011\u0011IPa?\u0003\u0011QK7m\u001b+za\u0016TAA!>\u0003\u0006\u0006\u0019rL\u001a:fcV,g\u000e^\"pY2,7\r^8sA\u0005!r,\u001b8ge\u0016\fX/\u001a8u\u0007>dG.Z2u_J,\"aa\u0001\u0011\u0007\t\u0005\u0003F\u0001\rJ]\u001a\u0014X-];f]R\u001cu\u000e\u001c7fGRLwN\u001c+bg.\u001cB\u0001\u000b8\u0003HQ\u001111A\u0001\u0004?>\u001cXCAB\b!\u0011\u0019\tba\u0007\u000e\u0005\rM!\u0002BB\u000b\u0007/\t!a\\:\u000b\t\re!1O\u0001\tg>4Go^1sK&!1QDB\n\u0005=y\u0005/\u001a:bi&twmU=ti\u0016l\u0017\u0001B0pg\u0002\n!cX7f[>\u0014\u00180\u00138tiJ,X.\u001a8ugV\u00111Q\u0005\t\u0005\u0005+\u001b9#\u0003\u0003\u0004*\tU&!E'f[>\u0014\u00180\u00138tiJ,X.\u001a8ug\u0006\u0019r,\\3n_JL\u0018J\\:ueVlWM\u001c;tA\u0005\u0001rl]<ba&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007c\u0001BA!&\u00044%!1Q\u0007B[\u0005=\u0019v/\u00199J]N$(/^7f]R\u001c\u0018!E0to\u0006\u0004\u0018J\\:ueVlWM\u001c;tA\u00059r\f\\8bI\u00063XM]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007{\u0001BA!&\u0004@%!1\u0011\tB[\u0005Yau.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\u0018\u0001G0m_\u0006$\u0017I^3sC\u001e,\u0017J\\:ueVlWM\u001c;tA\u0005YrLZ5mKNK8\u000f^3n+N\fw-Z%ogR\u0014X/\\3oiN,\"a!\u0013\u0011\t\tU51J\u0005\u0005\u0007\u001b\u0012)LA\fTi>\u0014\u0018mZ3N_VtG/\u00138tiJ,X.\u001a8ug\u0006arLZ5mKNK8\u000f^3n+N\fw-Z%ogR\u0014X/\\3oiN\u0004\u0013AH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;t+\t\u0019)\u0006\u0005\u0003\u0003\u0016\u000e]\u0013\u0002BB-\u0005k\u0013\u0001d\u0015;pe\u0006<W\rR3wS\u000e,\u0017J\\:ueVlWM\u001c;t\u0003}yf-\u001b7f'f\u001cH/Z7BGRLg/\u001b;z\u0013:\u001cHO];nK:$8\u000fI\u0001\u001c?:,Go^8sW\u0006\u001bG/\u001b<jifLen\u001d;sk6,g\u000e^:\u0016\u0005\r\u0005\u0004\u0003\u0002BK\u0007GJAa!\u001a\u00036\nQb*\u001a;x_J\\\u0017i\u0019;jm&$\u00180\u00138tiJ,X.\u001a8ug\u0006arL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN\u0004C\u0003\u0002B\u0015\u0007WBQA\u001f A\u0002m\f\u0011C]3d_J$W*Z7pef,6/Y4f\u0003E\u0011XmY8sI2{\u0017\rZ!wKJ\fw-Z\u0001\u0013e\u0016\u001cwN\u001d3Ti>\u0014\u0018mZ3Vg\u0006<W-A\u000bsK\u000e|'\u000fZ*u_J\fw-Z!di&4\u0018\u000e^=\u0002+I,7m\u001c:e\u001d\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us\u0006)r,\u001b8ge\u0016\fX/\u001a8u\u0007>dG.Z2u_J\u0004\u0013aC0gGN\u001b\u0007.\u001a3vY\u0016,\"a! 1\t\r}4q\u0012\t\u0007\u0007\u0003\u001b9ia#\u000e\u0005\r\r%b\u0001@\u0004\u0006*!\u0011\u0011OA\r\u0013\u0011\u0019Iia!\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004Ba!$\u0004\u00102\u0001AaCBI\u001b\u0005\u0005\t\u0011!B\u0001\u0007+\u0013!a\u0010\u0019\u0002\u0019}37mU2iK\u0012,H.\u001a\u0011\u0012\t\r]\u0015q\u0017\t\u0004_\u000ee\u0015bABNa\n9aj\u001c;iS:<\u0017\u0001D0jM\u000e\u001c6\r[3ek2,WCABQa\u0011\u0019\u0019ka*\u0011\r\r\u00055qQBS!\u0011\u0019iia*\u0005\u0017\rEu\"!A\u0001\u0002\u000b\u00051QS\u0001\u000e?&47mU2iK\u0012,H.\u001a\u0011\u0002\tM$x\u000e]\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0003*\rE\u0006bBBZ#\u0001\u00071QW\u0001\n]\u0016<8i\u001c8gS\u001e\u0004Baa.\u0004F6\u00111\u0011\u0018\u0006\u0005\u0007w\u001bi,\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0007\u007f\u001b\t-\u0001\u0005usB,7/\u00194f\u0015\t\u0019\u0019-A\u0002d_6LAaa2\u0004:\n11i\u001c8gS\u001e\fAB]3bIN+G\u000f^5oON$B!a\n\u0004N\"911\u0018\nA\u0002\rU\u0016AE:dQ\u0016$W\u000f\\3P]6{G-\u001e7f\u000b\u000e#Baa5\u0004ZB!\u00111CBk\u0013\u0011\u00199.!\u0006\u0003\u0011I+hN\\1cY\u0016Dqaa7\u0014\u0001\u0004\u00119%\u0001\u0003uCN\\\u0007")
public class HostMetricsCollector
implements Module {
    public final ExecutionContext kamon$instrumentation$system$host$HostMetricsCollector$$ec;
    private final String _configPath;
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    private final FrequentCollectionTask _frequentCollector;
    private final InfrequentCollectionTask _infrequentCollector;
    private final ScheduledFuture<?> _fcSchedule;
    private final ScheduledFuture<?> _ifcSchedule;

    private String _configPath() {
        return this._configPath;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    private ScheduledFuture<?> _fcSchedule() {
        return this._fcSchedule;
    }

    private ScheduledFuture<?> _ifcSchedule() {
        return this._ifcSchedule;
    }

    public void stop() {
        this._fcSchedule().cancel(false);
        this._ifcSchedule().cancel(false);
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    private Runnable scheduleOnModuleEC(CollectionTask task) {
        return new Runnable(this, task){
            private final /* synthetic */ HostMetricsCollector $outer;
            private final CollectionTask task$1;

            public void run() {
                this.task$1.schedule(this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$$ec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }
        };
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$ec = ec;
        this._configPath = "kamon.instrumentation.system.host";
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
        this._frequentCollector = new FrequentCollectionTask();
        this._infrequentCollector = new InfrequentCollectionTask();
        this._fcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._frequentCollector()), 1L, 1L, TimeUnit.SECONDS);
        this._ifcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._infrequentCollector()), 1L, 10L, TimeUnit.SECONDS);
    }

    public interface CollectionTask {
        public void schedule(ExecutionContext var1);

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.recordCpuUsage(), ec);
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
            } else {
                this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
            }
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.recordMemoryUsage();
                this.recordLoadAverage();
                this.recordStorageUsage();
                this.recordStorageActivity();
                this.recordNetworkActivity();
            }, ec);
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            this._memoryInstruments().total().update((double)memory.getTotal());
            this._memoryInstruments().free().update((double)memory.getAvailable());
            this._memoryInstruments().used().update((double)(memory.getTotal() - memory.getAvailable()));
            this._swapInstruments().total().update((double)memory.getSwapTotal());
            this._swapInstruments().free().update((double)memory.getSwapUsed());
            this._swapInstruments().used().update((double)(memory.getSwapTotal() - memory.getSwapUsed()));
        }

        private void recordLoadAverage() {
            block0: {
                double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
                Object object = loadAverage[0] >= 0.0 ? this._loadAverageInstruments().oneMinute().update(loadAverage[0]) : BoxedUnit.UNIT;
                Object object2 = loadAverage[1] >= 0.0 ? this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]) : BoxedUnit.UNIT;
                if (!(loadAverage[2] >= 0.0)) break block0;
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            OSFileStore[] fileStores = this._os().getFileSystem().getFileStores();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStores)).foreach((Function1 & Serializable & scala.Serializable)fs -> {
                BoxedUnit boxedUnit;
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)fs.getTotalSpace());
                    boxedUnit = mountInstruments.used().update((double)(fs.getTotalSpace() - fs.getUsableSpace()));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        private void recordStorageActivity() {
            HWDiskStore[] devices = this._hal().getDiskStores();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])devices)).foreach((Function1 & Serializable & scala.Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            NetworkIF[] interfaces = this._hal().getNetworkIFs();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])interfaces)).foreach((Function1 & Serializable & scala.Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            block0: {
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])device.getPartitions())).nonEmpty()) break block0;
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            block0: {
                if (!$this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) break block0;
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    scala.Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Filter filter;
            int n = x$1;
            switch (n) {
                case 0: {
                    filter = this.trackedInterfaces();
                    break;
                }
                case 1: {
                    filter = this.trackedMounts();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return filter;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

