/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ruh\u0001\u00023f\u00019D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\n\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u0003J\u0001\u0001\r\u0011\"\u0003\u0003L!A!Q\u000b\u0001!B\u0013\tI\u0003C\u0005\u0003`\u0001\u0011\r\u0011\"\u0003\u0003b!A11\u0004\u0001!\u0002\u0013\u0011\u0019\u0007C\u0005\u0004\u001e\u0001\u0011\r\u0011\"\u0003\u0004 !A1Q\u0013\u0001!\u0002\u0013\u0019\t\u0003C\u0005\u0004\u0018\u0002\u0011\r\u0011\"\u0003\u0004\u001a\"A1\u0011\u0017\u0001!\u0002\u0013\u0019Y\nC\u0005\u0004>\u0002\u0011\r\u0011\"\u0003\u0004@\"A1\u0011\u001a\u0001!\u0002\u0013\u0019\t\rC\u0004\u0004L\u0002!\tE!\u001f\t\u000f\r5\u0007\u0001\"\u0011\u0004P\"91\u0011\u001e\u0001\u0005\n\r-\bbBBx\u0001\u0011%1\u0011\u001f\u0004\n\u0005[\u0002\u0001\u0013aI\u0001\u0005_BqA!\u001d\u0015\r\u0003\u0011\u0019\bC\u0004\u0003xQ1\tA!\u001f\u0007\r\t\u001d\u0004\u0001\u0002B5\u0011\u001d\t)a\u0006C\u0001\u0005wB\u0011B! \u0018\u0005\u0004%IAa \t\u0011\t5u\u0003)A\u0005\u0005\u0003C\u0011Ba$\u0018\u0005\u0004%IA!%\t\u0011\t}u\u0003)A\u0005\u0005'C\u0011B!)\u0018\u0005\u0004%IAa)\t\u0011\tEv\u0003)A\u0005\u0005KC\u0011Ba-\u0018\u0005\u0004%IA!.\t\u0011\tUw\u0003)A\u0005\u0005oC\u0011Ba6\u0018\u0001\u0004%IA!7\t\u0013\t\u001dx\u00031A\u0005\n\t%\b\u0002\u0003Bw/\u0001\u0006KAa7\t\u000f\tEt\u0003\"\u0001\u0003p\"9!qO\f\u0005\u0002\te\u0004b\u0002Bz/\u0011%!\u0011\u0010\u0005\b\u0005k<B\u0011\u0002B|\r\u0019\u0019\u0019\u0003\u0001\u0003\u0004&!9\u0011Q\u0001\u0015\u0005\u0002\r\u001d\u0002\"\u0003B?Q\t\u0007I\u0011\u0002B@\u0011!\u0011i\t\u000bQ\u0001\n\t\u0005\u0005\"\u0003BHQ\t\u0007I\u0011\u0002BI\u0011!\u0011y\n\u000bQ\u0001\n\tM\u0005\"\u0003BQQ\t\u0007I\u0011\u0002BR\u0011!\u0011\t\f\u000bQ\u0001\n\t\u0015\u0006\"CB\u0015Q\t\u0007I\u0011BB\u0016\u0011!\u0019i\u0004\u000bQ\u0001\n\r5\u0002\"CB Q\t\u0007I\u0011BB!\u0011!\u0019I\u0005\u000bQ\u0001\n\r\r\u0003\"CB&Q\t\u0007I\u0011BB'\u0011!\u0019)\u0006\u000bQ\u0001\n\r=\u0003\"CB,Q\t\u0007I\u0011BB-\u0011!\u0019\t\u0007\u000bQ\u0001\n\rm\u0003\"CB2Q\t\u0007I\u0011BB3\u0011!\u0019i\u0007\u000bQ\u0001\n\r\u001d\u0004\"CB8Q\t\u0007I\u0011BB9\u0011!\u0019I\b\u000bQ\u0001\n\rM\u0004\"CB>Q\t\u0007I\u0011BB?\u0011!\u0019)\t\u000bQ\u0001\n\r}\u0004b\u0002B9Q\u0011\u00051q\u0011\u0005\b\u0005oBC\u0011\u0001B=\u0011\u001d\u0019Y\t\u000bC\u0005\u0005sBqa!$)\t\u0013\u0011I\bC\u0004\u0004\u0010\"\"IA!\u001f\t\u000f\rE\u0005\u0006\"\u0003\u0003z!911\u0013\u0015\u0005\n\tetaBA\u0017K\"\u0005\u0011q\u0006\u0004\u0007I\u0016D\t!!\r\t\u000f\u0005\u0015a\t\"\u0001\u00024\u00191\u0011Q\u0007$\u0001\u0003oAq!!\u0002I\t\u0003\ty\u0004C\u0004\u0002F!#\t%a\u0012\u0007\r\u0005]c\tQA.\u0011)\tYh\u0013BK\u0002\u0013\u0005\u0011Q\u0010\u0005\u000b\u0003\u0017[%\u0011#Q\u0001\n\u0005}\u0004BCAG\u0017\nU\r\u0011\"\u0001\u0002~!Q\u0011qR&\u0003\u0012\u0003\u0006I!a \t\u000f\u0005\u00151\n\"\u0001\u0002\u0012\"I\u0011\u0011T&\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003C[\u0015\u0013!C\u0001\u0003GC\u0011\"!/L#\u0003%\t!a)\t\u0013\u0005m6*!A\u0005B\u0005E\u0001\"CA_\u0017\u0006\u0005I\u0011AA`\u0011%\t9mSA\u0001\n\u0003\tI\rC\u0005\u0002V.\u000b\t\u0011\"\u0011\u0002X\"I\u0011Q]&\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003c\\\u0015\u0011!C!\u0003gD\u0011\"a>L\u0003\u0003%\t%!?\t\u0013\u0005m8*!A\u0005B\u0005u\b\"CA\u0000\u0017\u0006\u0005I\u0011\tB\u0001\u000f%\u0011)ARA\u0001\u0012\u0003\u00119AB\u0005\u0002X\u0019\u000b\t\u0011#\u0001\u0003\n!9\u0011Q\u00010\u0005\u0002\t\u0005\u0002\"CA~=\u0006\u0005IQIA\u007f\u0011%\u0011\u0019CXA\u0001\n\u0003\u0013)\u0003C\u0005\u0003,y\u000b\t\u0011\"!\u0003.!I!q\b0\u0002\u0002\u0013%!\u0011\t\u0002\u0015\u0011>\u001cH/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u000b\u0005\u0019<\u0017\u0001\u00025pgRT!\u0001[5\u0002\rML8\u000f^3n\u0015\tQ7.A\bj]N$(/^7f]R\fG/[8o\u0015\u0005a\u0017!B6b[>t7\u0001A\n\u0004\u0001=,\bC\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(AB!osJ+g\r\u0005\u0002ws6\tqO\u0003\u0002yW\u00061Qn\u001c3vY\u0016L!A_<\u0003\r5{G-\u001e7f\u0003\t)7\rE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fF\f!bY8oGV\u0014(/\u001a8u\u0013\r\t\u0019A \u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003BA\u0005\u0003\u001b\u00012!a\u0003\u0001\u001b\u0005)\u0007\"B>\u0003\u0001\u0004a\u0018aC0d_:4\u0017n\u001a)bi\",\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!A.\u00198h\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003/\u0011aa\u0015;sS:<\u0017\u0001D0d_:4\u0017n\u001a)bi\"\u0004\u0013!C0tKR$\u0018N\\4t+\t\tI\u0003E\u0002\u0002,-s1!a\u0003F\u0003QAun\u001d;NKR\u0014\u0018nY:D_2dWm\u0019;peB\u0019\u00111\u0002$\u0014\u0005\u0019{GCAA\u0018\u0005\u001d1\u0015m\u0019;pef\u001cB\u0001S8\u0002:A\u0019a/a\u000f\n\u0007\u0005urOA\u0007N_\u0012,H.\u001a$bGR|'/\u001f\u000b\u0003\u0003\u0003\u00022!a\u0011I\u001b\u00051\u0015AB2sK\u0006$X\rF\u0002v\u0003\u0013Bq!a\u0013K\u0001\u0004\ti%\u0001\u0005tKR$\u0018N\\4t!\u0011\ty%!\u0016\u000f\u0007Y\f\t&C\u0002\u0002T]\fQ\"T8ek2,g)Y2u_JL\u0018\u0002BA,\u00033\u0012\u0001bU3ui&twm\u001d\u0006\u0004\u0003':8CB&p\u0003;\n\u0019\u0007E\u0002q\u0003?J1!!\u0019r\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u001a\u0002v9!\u0011qMA9\u001d\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7[\u00061AH]8pizJ\u0011A]\u0005\u0004\u0003g\n\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003o\nIH\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002tE\f\u0011\u0003\u001e:bG.,G-\u00138uKJ4\u0017mY3t+\t\ty\b\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)i[\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0006\r%A\u0002$jYR,'/\u0001\nue\u0006\u001c7.\u001a3J]R,'OZ1dKN\u0004\u0013!\u0004;sC\u000e\\W\rZ'pk:$8/\u0001\bue\u0006\u001c7.\u001a3N_VtGo\u001d\u0011\u0015\r\u0005M\u0015QSAL!\r\t\u0019e\u0013\u0005\b\u0003w\u0002\u0006\u0019AA@\u0011\u001d\ti\t\u0015a\u0001\u0003\u007f\nAaY8qsR1\u00111SAO\u0003?C\u0011\"a\u001fR!\u0003\u0005\r!a \t\u0013\u00055\u0015\u000b%AA\u0002\u0005}\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KSC!a \u0002(.\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003%)hn\u00195fG.,GMC\u0002\u00024F\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9,!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\rE\u0002q\u0003\u0007L1!!2r\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY-!5\u0011\u0007A\fi-C\u0002\u0002PF\u00141!\u00118z\u0011%\t\u0019NVA\u0001\u0002\u0004\t\t-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0004b!a7\u0002b\u0006-WBAAo\u0015\r\ty.]\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAr\u0003;\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011^Ax!\r\u0001\u00181^\u0005\u0004\u0003[\f(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'D\u0016\u0011!a\u0001\u0003\u0017\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111CA{\u0011%\t\u0019.WA\u0001\u0002\u0004\t\t-\u0001\u0005iCND7i\u001c3f)\t\t\t-\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u0014\u0019\u0001C\u0005\u0002Tr\u000b\t\u00111\u0001\u0002L\u0006A1+\u001a;uS:<7\u000fE\u0002\u0002Dy\u001bRA\u0018B\u0006\u0005/\u0001\"B!\u0004\u0003\u0014\u0005}\u0014qPAJ\u001b\t\u0011yAC\u0002\u0003\u0012E\fqA];oi&lW-\u0003\u0003\u0003\u0016\t=!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\u0004B\u0010\u001b\t\u0011YB\u0003\u0003\u0003\u001e\u0005m\u0011AA5p\u0013\u0011\t9Ha\u0007\u0015\u0005\t\u001d\u0011!B1qa2LHCBAJ\u0005O\u0011I\u0003C\u0004\u0002|\u0005\u0004\r!a \t\u000f\u00055\u0015\r1\u0001\u0002\u0000\u00059QO\\1qa2LH\u0003\u0002B\u0018\u0005w\u0001R\u0001\u001dB\u0019\u0005kI1Aa\rr\u0005\u0019y\u0005\u000f^5p]B9\u0001Oa\u000e\u0002\u0000\u0005}\u0014b\u0001B\u001dc\n1A+\u001e9mKJB\u0011B!\u0010c\u0003\u0003\u0005\r!a%\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003DA!\u0011Q\u0003B#\u0013\u0011\u00119%a\u0006\u0003\r=\u0013'.Z2u\u00035y6/\u001a;uS:<7o\u0018\u0013fcR!!Q\nB*!\r\u0001(qJ\u0005\u0004\u0005#\n(\u0001B+oSRD\u0011\"a5\u0007\u0003\u0003\u0005\r!!\u000b\u0002\u0015}\u001bX\r\u001e;j]\u001e\u001c\b\u0005K\u0002\b\u00053\u00022\u0001\u001dB.\u0013\r\u0011i&\u001d\u0002\tm>d\u0017\r^5mK\u0006\u0011rL\u001a:fcV,g\u000e^\"pY2,7\r^8s+\t\u0011\u0019\u0007E\u0002\u0003f]i\u0011\u0001\u0001\u0002\u0017\rJ,\u0017/^3oi\u000e{G\u000e\\3di&|g\u000eV1tWN!qc\u001cB6!\r\u0011)\u0007\u0006\u0002\u000f\u0007>dG.Z2uS>tG+Y:l'\t!r.\u0001\u0005tG\",G-\u001e7f)\u0011\u0011iE!\u001e\t\u000bm,\u0002\u0019\u0001?\u0002\u000f\rdW-\u00198vaR\u0011!Q\n\u000b\u0003\u0005G\nAb\u00183fM\u0006,H\u000e\u001e+bON,\"A!!\u0011\t\t\r%\u0011R\u0007\u0003\u0005\u000bS1Aa\"l\u0003\r!\u0018mZ\u0005\u0005\u0005\u0017\u0013)I\u0001\u0004UC\u001e\u001cV\r^\u0001\u000e?\u0012,g-Y;miR\u000bwm\u001d\u0011\u0002\u0017}\u001b\u0018p\u001d;f[&sgm\\\u000b\u0003\u0005'\u0003BA!&\u0003\u001c6\u0011!q\u0013\u0006\u0003\u00053\u000bAa\\:iS&!!Q\u0014BL\u0005)\u0019\u0016p\u001d;f[&sgm\\\u0001\r?NL8\u000f^3n\u0013:4w\u000eI\u0001\u0005?\"\fG.\u0006\u0002\u0003&B!!q\u0015BW\u001b\t\u0011IK\u0003\u0003\u0003,\n]\u0015\u0001\u00035be\u0012<\u0018M]3\n\t\t=&\u0011\u0016\u0002\u0019\u0011\u0006\u0014Hm^1sK\u0006\u00137\u000f\u001e:bGRLwN\u001c'bs\u0016\u0014\u0018!B0iC2\u0004\u0013aD0daVLen\u001d;sk6,g\u000e^:\u0016\u0005\t]\u0006\u0003\u0002B]\u0005\u001ftAAa/\u0003L:!!Q\u0018Be\u001d\u0011\u0011yLa2\u000f\t\t\u0005'Q\u0019\b\u0005\u0003S\u0012\u0019-C\u0001m\u0013\tQ7.\u0003\u0002iS&\u0011amZ\u0005\u0004\u0005\u001b,\u0017a\u0003%pgRlU\r\u001e:jGNLAA!5\u0003T\nq1\t];J]N$(/^7f]R\u001c(b\u0001BgK\u0006\u0001rl\u00199v\u0013:\u001cHO];nK:$8\u000fI\u0001\u0012?B\u0014XM^\"qk2{\u0017\r\u001a+jG.\u001cXC\u0001Bn!\u0015\u0001(Q\u001cBq\u0013\r\u0011y.\u001d\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004a\n\r\u0018b\u0001Bsc\n!Aj\u001c8h\u0003Uy\u0006O]3w\u0007B,Hj\\1e)&\u001c7n]0%KF$BA!\u0014\u0003l\"I\u00111\u001b\u0012\u0002\u0002\u0003\u0007!1\\\u0001\u0013?B\u0014XM^\"qk2{\u0017\r\u001a+jG.\u001c\b\u0005\u0006\u0003\u0003N\tE\b\"B>%\u0001\u0004a\u0018A\u0004:fG>\u0014Hm\u00119v+N\fw-Z\u0001\ni&\u001c7n\u001d#jM\u001a$\u0002B!9\u0003z\nu8\u0011\u0001\u0005\b\u0005w<\u0003\u0019\u0001Bn\u0003!\u0001(/\u001a<j_V\u001c\bb\u0002B\u0000O\u0001\u0007!1\\\u0001\bGV\u0014(/\u001a8u\u0011\u001d\u0019\u0019a\na\u0001\u0007\u000b\t\u0001\u0002^5dWRK\b/\u001a\t\u0005\u0007\u000f\u0019)B\u0004\u0003\u0004\n\rEa\u0002BB\u0006\u0007\u001fqA!!\u001b\u0004\u000e%\u0011!\u0011T\u0005\u0005\u0005W\u00139*\u0003\u0003\u0004\u0014\t%\u0016\u0001E\"f]R\u0014\u0018\r\u001c)s_\u000e,7o]8s\u0013\u0011\u00199b!\u0007\u0003\u0011QK7m\u001b+za\u0016TAaa\u0005\u0003*\u0006\u0019rL\u001a:fcV,g\u000e^\"pY2,7\r^8sA\u0005!r,\u001b8ge\u0016\fX/\u001a8u\u0007>dG.Z2u_J,\"a!\t\u0011\u0007\t\u0015\u0004F\u0001\rJ]\u001a\u0014X-];f]R\u001cu\u000e\u001c7fGRLwN\u001c+bg.\u001cB\u0001K8\u0003lQ\u00111\u0011E\u0001\u0004?>\u001cXCAB\u0017!\u0011\u0019yc!\u000f\u000e\u0005\rE\"\u0002BB\u001a\u0007k\t!a\\:\u000b\t\r]\"qS\u0001\tg>4Go^1sK&!11HB\u0019\u0005=y\u0005/\u001a:bi&twmU=ti\u0016l\u0017\u0001B0pg\u0002\n!cX7f[>\u0014\u00180\u00138tiJ,X.\u001a8ugV\u001111\t\t\u0005\u0005s\u001b)%\u0003\u0003\u0004H\tM'!E'f[>\u0014\u00180\u00138tiJ,X.\u001a8ug\u0006\u0019r,\\3n_JL\u0018J\\:ueVlWM\u001c;tA\u0005\u0001rl]<ba&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007\u001f\u0002BA!/\u0004R%!11\u000bBj\u0005=\u0019v/\u00199J]N$(/^7f]R\u001c\u0018!E0to\u0006\u0004\u0018J\\:ueVlWM\u001c;tA\u00059r\f\\8bI\u00063XM]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u00077\u0002BA!/\u0004^%!1q\fBj\u0005Yau.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\u0018\u0001G0m_\u0006$\u0017I^3sC\u001e,\u0017J\\:ueVlWM\u001c;tA\u0005YrLZ5mKNK8\u000f^3n+N\fw-Z%ogR\u0014X/\\3oiN,\"aa\u001a\u0011\t\te6\u0011N\u0005\u0005\u0007W\u0012\u0019NA\fTi>\u0014\u0018mZ3N_VtG/\u00138tiJ,X.\u001a8ug\u0006arLZ5mKNK8\u000f^3n+N\fw-Z%ogR\u0014X/\\3oiN\u0004\u0013AH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;t+\t\u0019\u0019\b\u0005\u0003\u0003:\u000eU\u0014\u0002BB<\u0005'\u0014\u0001d\u0015;pe\u0006<W\rR3wS\u000e,\u0017J\\:ueVlWM\u001c;t\u0003}yf-\u001b7f'f\u001cH/Z7BGRLg/\u001b;z\u0013:\u001cHO];nK:$8\u000fI\u0001\u001c?:,Go^8sW\u0006\u001bG/\u001b<jifLen\u001d;sk6,g\u000e^:\u0016\u0005\r}\u0004\u0003\u0002B]\u0007\u0003KAaa!\u0003T\nQb*\u001a;x_J\\\u0017i\u0019;jm&$\u00180\u00138tiJ,X.\u001a8ug\u0006arL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN\u0004C\u0003\u0002B'\u0007\u0013CQa\u001f A\u0002q\f\u0011C]3d_J$W*Z7pef,6/Y4f\u0003E\u0011XmY8sI2{\u0017\rZ!wKJ\fw-Z\u0001\u0013e\u0016\u001cwN\u001d3Ti>\u0014\u0018mZ3Vg\u0006<W-A\u000bsK\u000e|'\u000fZ*u_J\fw-Z!di&4\u0018\u000e^=\u0002+I,7m\u001c:e\u001d\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us\u0006)r,\u001b8ge\u0016\fX/\u001a8u\u0007>dG.Z2u_J\u0004\u0013aC0gGN\u001b\u0007.\u001a3vY\u0016,\"aa'1\t\ru5Q\u0016\t\u0007\u0007?\u001b)k!+\u000e\u0005\r\u0005&bA@\u0004$*!\u0011QQA\u000e\u0013\u0011\u00199k!)\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004Baa+\u0004.2\u0001AaCBX\u001b\u0005\u0005\t\u0011!B\u0001\u0007g\u0013!a\u0010\u0019\u0002\u0019}37mU2iK\u0012,H.\u001a\u0011\u0012\t\rU61\u0018\t\u0004a\u000e]\u0016bAB]c\n9aj\u001c;iS:<\u0007\u0003BA\u000b\u0005\u000b\nAbX5gGN\u001b\u0007.\u001a3vY\u0016,\"a!11\t\r\r7q\u0019\t\u0007\u0007?\u001b)k!2\u0011\t\r-6q\u0019\u0003\f\u0007_{\u0011\u0011!A\u0001\u0006\u0003\u0019\u0019,A\u0007`S\u001a\u001c7k\u00195fIVdW\rI\u0001\u0005gR|\u0007/A\u0006sK\u000e|gNZ5hkJ,G\u0003\u0002B'\u0007#Dqaa5\u0012\u0001\u0004\u0019).A\u0005oK^\u001cuN\u001c4jOB!1q[Bs\u001b\t\u0019IN\u0003\u0003\u0004\\\u000eu\u0017AB2p]\u001aLwM\u0003\u0003\u0004`\u000e\u0005\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\r\r\u0018aA2p[&!1q]Bm\u0005\u0019\u0019uN\u001c4jO\u0006a!/Z1e'\u0016$H/\u001b8hgR!\u0011\u0011FBw\u0011\u001d\u0019YN\u0005a\u0001\u0007+\f!c]2iK\u0012,H.Z(o\u001b>$W\u000f\\3F\u0007R!11_B}!\u0011\t)b!>\n\t\r]\u0018q\u0003\u0002\t%Vtg.\u00192mK\"911`\nA\u0002\t-\u0014\u0001\u0002;bg.\u0004")
public class HostMetricsCollector
implements Module {
    public final ExecutionContext kamon$instrumentation$system$host$HostMetricsCollector$$ec;
    private final String _configPath;
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    private final FrequentCollectionTask _frequentCollector;
    private final InfrequentCollectionTask _infrequentCollector;
    private final ScheduledFuture<?> _fcSchedule;
    private final ScheduledFuture<?> _ifcSchedule;

    private String _configPath() {
        return this._configPath;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    private ScheduledFuture<?> _fcSchedule() {
        return this._fcSchedule;
    }

    private ScheduledFuture<?> _ifcSchedule() {
        return this._ifcSchedule;
    }

    public void stop() {
        this._fcSchedule().cancel(false);
        this._ifcSchedule().cancel(false);
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    private Runnable scheduleOnModuleEC(CollectionTask task) {
        return new Runnable(this, task){
            private final /* synthetic */ HostMetricsCollector $outer;
            private final CollectionTask task$1;

            public void run() {
                this.task$1.schedule(this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$$ec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }
        };
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$ec = ec;
        this._configPath = "kamon.instrumentation.system.host";
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
        this._frequentCollector = new FrequentCollectionTask();
        this._infrequentCollector = new InfrequentCollectionTask();
        this._fcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._frequentCollector()), 1L, 1L, TimeUnit.SECONDS);
        this._ifcSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._infrequentCollector()), 1L, 10L, TimeUnit.SECONDS);
    }

    public interface CollectionTask {
        public void schedule(ExecutionContext var1);

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.recordCpuUsage(), ec);
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
            } else {
                this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
            }
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, (ClassTag)ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.recordMemoryUsage();
                this.recordLoadAverage();
                this.recordStorageUsage();
                this.recordStorageActivity();
                this.recordNetworkActivity();
            }, ec);
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            this._memoryInstruments().total().update((double)memory.getTotal());
            this._memoryInstruments().free().update((double)memory.getAvailable());
            this._memoryInstruments().used().update((double)(memory.getTotal() - memory.getAvailable()));
            this._swapInstruments().total().update((double)memory.getSwapTotal());
            this._swapInstruments().free().update((double)memory.getSwapUsed());
            this._swapInstruments().used().update((double)(memory.getSwapTotal() - memory.getSwapUsed()));
        }

        private void recordLoadAverage() {
            block0: {
                double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
                Object object = loadAverage[0] >= 0.0 ? this._loadAverageInstruments().oneMinute().update(loadAverage[0]) : BoxedUnit.UNIT;
                Object object2 = loadAverage[1] >= 0.0 ? this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]) : BoxedUnit.UNIT;
                if (!(loadAverage[2] >= 0.0)) break block0;
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            OSFileStore[] fileStores = this._os().getFileSystem().getFileStores();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fileStores), (Function1 & Serializable)fs -> {
                BoxedUnit boxedUnit;
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)fs.getTotalSpace());
                    boxedUnit = mountInstruments.used().update((double)(fs.getTotalSpace() - fs.getUsableSpace()));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        private void recordStorageActivity() {
            HWDiskStore[] devices = this._hal().getDiskStores();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])devices), (Function1 & Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            NetworkIF[] interfaces = this._hal().getNetworkIFs();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])interfaces), (Function1 & Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            block0: {
                if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])device.getPartitions()))) break block0;
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            block0: {
                if (!$this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) break block0;
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.trackedInterfaces();
                    break;
                }
                case 1: {
                    object = this.trackedMounts();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "trackedInterfaces";
                    break;
                }
                case 1: {
                    string = "trackedMounts";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

