/*
 * Copyright 2013-2020 The Kamon Project <https://kamon.io>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kamon.instrumentation.system.process

import kamon.Kamon
import kamon.metric.{InstrumentGroup, MeasurementUnit}
import kamon.tag.TagSet

object ProcessMetrics {

  val ProcessCpu = Kamon.histogram(
    name = "process.cpu.usage",
    description = "Samples the Process CPU usage",
    unit = MeasurementUnit.percentage
  )

  val ULimitMaxFileDescriptors = Kamon.gauge (
    name = "process.ulimit.file-descriptors.max",
    description = "Tracks the max number of file descriptors that can be used by the process"
  )
  val ULimitUsedFileDescriptors = Kamon.gauge (
    name = "process.ulimit.file-descriptors.used",
    description = "Tracks the number of file descriptors used by the process"
  )

  val Hiccups = Kamon.timer (
    name = "process.hiccups",
    description = "Tracks the process hiccups generated by either garbage collection or OS noise"
  )


  class ProcessInstruments(tags: TagSet) extends InstrumentGroup(tags) {
    val user = register(ProcessCpu, "mode", "user")
    val system = register(ProcessCpu, "mode", "system")
    val combined = register(ProcessCpu, "mode", "combined")
    val openFilesLimit = register(ULimitMaxFileDescriptors)
    val openFilesCurrent = register(ULimitUsedFileDescriptors)
    val hiccups = register(Hiccups)
  }
}
