/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.bridge;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kanela.agent.api.instrumentation.bridge.Bridge;
import kanela.agent.api.instrumentation.bridge.BridgeClassVisitorWrapper;
import kanela.agent.api.instrumentation.bridge.FieldBridge;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;

public final class BridgeDescription {
    private final Class<?> bridgeInterface;

    public static BridgeDescription of(Class<?> clazz) {
        return new BridgeDescription(clazz);
    }

    public AgentBuilder.Transformer makeTransformer() {
        return (builder, typeDescription, classLoader, module, domain) -> builder.implement(new TypeDescription.ForLoadedType(this.bridgeInterface)).visit(BridgeClassVisitorWrapper.of(this, typeDescription, classLoader));
    }

    public Set<Method> getMethods() {
        return Arrays.stream(this.bridgeInterface.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Bridge.class) || method.isAnnotationPresent(FieldBridge.class)).collect(Collectors.toSet());
    }

    public BridgeDescription(Class<?> bridgeInterface) {
        this.bridgeInterface = bridgeInterface;
    }

    public Class<?> getBridgeInterface() {
        return this.bridgeInterface;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BridgeDescription)) {
            return false;
        }
        BridgeDescription other = (BridgeDescription)o;
        Class<?> this$bridgeInterface = this.getBridgeInterface();
        Class<?> other$bridgeInterface = other.getBridgeInterface();
        return !(this$bridgeInterface == null ? other$bridgeInterface != null : !this$bridgeInterface.equals(other$bridgeInterface));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $bridgeInterface = this.getBridgeInterface();
        result = result * 59 + ($bridgeInterface == null ? 43 : $bridgeInterface.hashCode());
        return result;
    }

    public String toString() {
        return "BridgeDescription(bridgeInterface=" + this.getBridgeInterface() + ")";
    }
}

