/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kanela.agent.api.instrumentation.TypeTransformation;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.dynamic.DynamicType;
import kanela.agent.libs.net.bytebuddy.utility.JavaModule;
import kanela.agent.util.classloader.ClassLoaderNameMatcher;
import kanela.agent.util.classloader.ScalaCompilerClassLoaderMatcher;
import kanela.agent.util.conf.KanelaConfiguration;

public final class InstrumentationRegistryListener
extends AgentBuilder.Listener.Adapter {
    private static InstrumentationRegistryListener instance = new InstrumentationRegistryListener();
    private Map<String, Map<TypeTransformation, List<TypeDescription>>> moduleTransformers = new ConcurrentHashMap<String, Map<TypeTransformation, List<TypeDescription>>>();
    private Map<String, KanelaConfiguration.ModuleConfiguration> moduleConfigurations = new ConcurrentHashMap<String, KanelaConfiguration.ModuleConfiguration>();
    private Map<String, List<Throwable>> errors = new ConcurrentHashMap<String, List<Throwable>>();

    public static InstrumentationRegistryListener instance() {
        return instance;
    }

    public void clear() {
        this.moduleTransformers = new ConcurrentHashMap<String, Map<TypeTransformation, List<TypeDescription>>>();
        this.moduleConfigurations = new ConcurrentHashMap<String, KanelaConfiguration.ModuleConfiguration>();
        this.errors = new ConcurrentHashMap<String, List<Throwable>>();
    }

    public void register(KanelaConfiguration.ModuleConfiguration moduleConfig, TypeTransformation typeTransformation) {
        Map moduleTransformations = this.moduleTransformers.computeIfAbsent(moduleConfig.getConfigPath(), k -> new ConcurrentHashMap());
        moduleTransformations.putIfAbsent(typeTransformation, Collections.synchronizedList(new LinkedList()));
        this.moduleConfigurations.put(moduleConfig.getConfigPath(), moduleConfig);
    }

    @Override
    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
        this.moduleTransformers.values().forEach(moduleTypeTransformers -> moduleTypeTransformers.forEach((typeTransformation, targetedTypeDescriptions) -> {
            if (this.isTargetedByTransformation((TypeTransformation)typeTransformation, typeDescription, classLoader)) {
                targetedTypeDescriptions.add(typeDescription);
            }
        }));
    }

    @Override
    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        if (!ScalaCompilerClassLoaderMatcher.isScalaCompilerClassLoader(classLoader)) {
            List typeErrors = this.errors.computeIfAbsent(typeName, tn -> Collections.synchronizedList(new LinkedList()));
            typeErrors.add(throwable);
        }
    }

    private boolean isTargetedByTransformation(TypeTransformation tt, TypeDescription td, ClassLoader classLoader) {
        return tt.getElementMatcher().map(em -> em.matches(td)).getOrElse(false) != false && ClassLoaderNameMatcher.RefinedClassLoaderMatcher.from(tt.getClassLoaderRefiner()).matches(classLoader);
    }

    public boolean isModuleActive(String moduleKey) {
        Map moduleTransformations = this.moduleTransformers.getOrDefault(moduleKey, Collections.emptyMap());
        return moduleTransformations.values().stream().anyMatch(tds -> !tds.isEmpty());
    }

    public static List<Map<String, String>> shareModules() {
        LinkedList<Map<String, String>> modules = new LinkedList<Map<String, String>>();
        InstrumentationRegistryListener.instance().moduleConfigurations.values().forEach(moduleConfig -> {
            boolean isActive = InstrumentationRegistryListener.instance().isModuleActive(moduleConfig.getConfigPath());
            HashMap<String, String> moduleInfo = new HashMap<String, String>();
            moduleInfo.put("path", moduleConfig.getConfigPath());
            moduleInfo.put("name", moduleConfig.getName());
            moduleInfo.put("description", moduleConfig.getDescription());
            moduleInfo.put("enabled", String.valueOf(moduleConfig.isEnabled()));
            moduleInfo.put("active", String.valueOf(isActive));
            modules.add(moduleInfo);
        });
        return modules;
    }

    public static Map<String, List<Throwable>> shareErrors() {
        return InstrumentationRegistryListener.instance().errors;
    }
}

