/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.circuitbreaker;

import java.text.MessageFormat;
import kanela.agent.broker.EventBroker;
import kanela.agent.broker.Subscribe;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.reinstrument.Reinstrumenter;
import kanela.agent.util.annotation.Experimental;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.jvm.GcEvent;
import kanela.agent.util.jvm.Jvm;
import kanela.agent.util.log.Logger;

@Experimental
public final class SystemThroughputCircuitBreaker {
    private final KanelaConfiguration.CircuitBreakerConfig config;
    private final Jvm jvm;
    private volatile int tripped = 0;

    public static void attach(KanelaConfiguration.CircuitBreakerConfig config) {
        SystemThroughputCircuitBreaker.attach(config, Jvm.instance());
    }

    public static void attach(KanelaConfiguration.CircuitBreakerConfig config, Jvm jvm) {
        if (config.isEnabled()) {
            Try.of(() -> new SystemThroughputCircuitBreaker(config, jvm)).andThen(config::circuitBreakerRunning).andThen(() -> Logger.info(() -> "System Throughput CircuitBreaker activated.")).andThen(circuitBreaker -> EventBroker.instance().add(circuitBreaker)).andThen(() -> Logger.debug(() -> "System Throughput CircuitBreaker is listening for GCEvents.")).onFailure(cause -> Logger.error(() -> "Error when trying to activate System Throughput CircuitBreaker.", cause));
        }
    }

    @Subscribe
    public void onGCEvent(GcEvent event) {
        if (this.jvm.getGcCpuTimePercent(event) >= this.config.getGcProcessCPUThreshold() && event.getPercentageFreeMemoryAfterGc() <= this.config.getFreeMemoryThreshold()) {
            Logger.warn(() -> MessageFormat.format("System Throughput Circuit BreakerCircuit => percentage of free memory {0} and  Process GC CPU time percentage {1}.", event.getPercentageFreeMemoryAfterGc(), this.jvm.getGcCpuTimePercent(event)));
            EventBroker.instance().publish(Reinstrumenter.ReinstrumentationProtocol.StopModules.instance());
            this.trip();
        } else if (this.isTripped()) {
            Logger.info(() -> MessageFormat.format("System Throughput Circuit BreakerCircuit => The System back to normal :) free memory {0} and  Process GC CPU time percentage {1}.", event.getPercentageFreeMemoryAfterGc(), this.jvm.getGcCpuTimePercent(event)));
            this.reset();
            EventBroker.instance().publish(Reinstrumenter.ReinstrumentationProtocol.RestartModules.instance());
        }
    }

    private boolean isTripped() {
        return this.tripped == 1;
    }

    private void trip() {
        this.tripped = 1;
    }

    private void reset() {
        this.tripped = 0;
    }

    public KanelaConfiguration.CircuitBreakerConfig getConfig() {
        return this.config;
    }

    public Jvm getJvm() {
        return this.jvm;
    }

    public int getTripped() {
        return this.tripped;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemThroughputCircuitBreaker)) {
            return false;
        }
        SystemThroughputCircuitBreaker other = (SystemThroughputCircuitBreaker)o;
        if (this.getTripped() != other.getTripped()) {
            return false;
        }
        KanelaConfiguration.CircuitBreakerConfig this$config = this.getConfig();
        KanelaConfiguration.CircuitBreakerConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Jvm this$jvm = this.getJvm();
        Jvm other$jvm = other.getJvm();
        return !(this$jvm == null ? other$jvm != null : !((Object)this$jvm).equals(other$jvm));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTripped();
        KanelaConfiguration.CircuitBreakerConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Jvm $jvm = this.getJvm();
        result = result * 59 + ($jvm == null ? 43 : ((Object)$jvm).hashCode());
        return result;
    }

    public String toString() {
        return "SystemThroughputCircuitBreaker(config=" + this.getConfig() + ", jvm=" + this.getJvm() + ", tripped=" + this.getTripped() + ")";
    }

    public SystemThroughputCircuitBreaker(KanelaConfiguration.CircuitBreakerConfig config, Jvm jvm) {
        this.config = config;
        this.jvm = jvm;
    }
}

