/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.dynamic.ClassFileLocator;
import kanela.agent.libs.net.bytebuddy.dynamic.loading.ClassInjector;
import kanela.agent.util.Jar;
import kanela.agent.util.log.Logger;

public final class BootstrapInjector {
    public static void injectJar(Instrumentation instrumentation, String jarName) {
        JarFile jarFile = Jar.getEmbeddedJar(jarName + ".jar").onFailure(error -> Logger.error(error::getMessage, error)).get();
        instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
    }

    public static void inject(File folder, Instrumentation instrumentation, List<String> allClasses) {
        ClassInjector.UsingUnsafe.Factory.resolve(instrumentation).make(null, null).injectRaw(BootstrapInjector.getTypeDefinitions(allClasses));
    }

    private static Map<String, byte[]> getTypeDefinitions(List<String> helperClassNames) {
        return helperClassNames.stream().collect(Collectors.toMap(k -> k, BootstrapInjector::getClassBytes));
    }

    private static byte[] getClassBytes(String className) {
        return Try.of(() -> ClassFileLocator.ForClassLoader.of(ClassLoader.getSystemClassLoader()).locate(className).resolve()).onFailure(error -> Logger.error(error::getMessage, error)).getOrElseThrow(cause -> new RuntimeException("Could not locate class: " + className));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof BootstrapInjector;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BootstrapInjector()";
    }
}

