/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.jvm;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import kanela.agent.util.jvm.GcEvent;

public final class Jvm {
    private static final Jvm instance = new Jvm();

    public static Jvm instance() {
        return instance;
    }

    public double getGcCpuTimePercent(GcEvent event) {
        long totalGcDuration = event.getInfo().getGcInfo().getDuration();
        long percent = totalGcDuration * 1000L / event.getInfo().getGcInfo().getEndTime();
        return Double.parseDouble(percent / 10L + "." + percent % 10L);
    }

    public long getProcessCPUTime() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuTime();
    }

    static boolean isOldGenPool(MemoryPoolMXBean bean) {
        return bean.getName().endsWith("Old Gen") || bean.getName().endsWith("Tenured Gen");
    }

    boolean isEndOfMayorGC(String gcAction) {
        return "end of major GC".equalsIgnoreCase(gcAction);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Jvm;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Jvm()";
    }
}

