/*
 * Decompiled with CFR 0.152.
 */
package kamon.sigar;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.logging.Logger;
import kamon.sigar.SigarProvisioner;

public class SigarAgent {
    private static final Logger logger = Logger.getLogger(SigarAgent.class.getName());
    private static volatile String options;
    private static volatile Instrumentation instrumentation;

    public static void agentmain(String string, Instrumentation instrumentation) throws Exception {
        logger.info("Sigar loader via agent-main.");
        SigarAgent.configure(string, instrumentation);
    }

    public static void premain(String string, Instrumentation instrumentation) throws Exception {
        logger.info("Sigar loader via pre-main.");
        SigarAgent.configure(string, instrumentation);
    }

    public static synchronized void configure(String string, Instrumentation instrumentation) throws Exception {
        if (SigarAgent.instrumentation != null) {
            logger.severe("Duplicate agent setup attempt.");
            return;
        }
        options = string;
        SigarAgent.instrumentation = instrumentation;
        logger.info("Sigar loader options: " + string);
        File file = new File(SigarProvisioner.discoverLocation(string));
        SigarProvisioner.provision(file);
    }

    public static String options() {
        return options;
    }

    public static Instrumentation instrumentation() {
        return instrumentation;
    }
}

