/*
 * Decompiled with CFR 0.152.
 */
package kamon.sigar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Logger;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class SigarProvisioner {
    private static final Logger logger = Logger.getLogger(SigarProvisioner.class.getName());
    public static final String LIB_DIR = "native";
    public static final String ENVIRONMENT_VARIABLE = "KAMON_SIGAR_FOLDER";
    public static final String SYSTEM_PROPERTY = "kamon.sigar.folder";
    public static final String DEFAULT_LOCATION = System.getProperty("user.dir") + File.separator + "native";
    static final int EOF = -1;
    static final int SIZE = 65536;

    public static String discoverLocation(String string) {
        String[] stringArray;
        if (string != null) {
            for (String string2 : stringArray = string.split(",")) {
                if (!string2.startsWith(SYSTEM_PROPERTY) || !string2.contains("=")) continue;
                logger.info("Using location provided by options.");
                return string2.substring(string2.indexOf("=") + 1);
            }
        }
        if ((stringArray = System.getenv(ENVIRONMENT_VARIABLE)) != null) {
            logger.info("Using location provided by environment variable.");
            return stringArray;
        }
        String string3 = System.getProperty(SYSTEM_PROPERTY);
        if (string3 != null) {
            logger.info("Using location provided by system property.");
            return string3;
        }
        logger.info("Using location provided by hard coded value.");
        return DEFAULT_LOCATION;
    }

    public static synchronized boolean isNativeLoaded() {
        try {
            return SigarProvisioner.isSigarAlreadyLoaded();
        }
        catch (Throwable throwable) {
            try {
                Sigar sigar = new Sigar();
                sigar.getPid();
                sigar.close();
                return true;
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
    }

    public static void provision() throws Exception {
        SigarProvisioner.provision(new File(SigarProvisioner.discoverLocation(null)));
    }

    public static synchronized void provision(File file) throws Exception {
        if (SigarProvisioner.isNativeLoaded()) {
            logger.warning("Sigar library is already provisioned.");
            return;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        SigarLoader sigarLoader = new SigarLoader(Sigar.class);
        String string = sigarLoader.getLibraryName();
        String string2 = "/native/" + string;
        File file2 = new File(file, string).getAbsoluteFile();
        InputStream inputStream = SigarProvisioner.class.getResourceAsStream(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        SigarProvisioner.transfer(inputStream, fileOutputStream);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        String string3 = file2.getAbsolutePath();
        System.load(string3);
        System.setProperty("org.hyperic.sigar.path", "-");
        sigarLoader.load();
        logger.info("Sigar library provisioned: " + string3);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray, 0, 65536)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static boolean isSigarAlreadyLoaded() throws Exception {
        String string = new SigarLoader(Sigar.class).getLibraryName();
        Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
        field.setAccessible(true);
        Vector vector = (Vector)field.get(SigarProvisioner.class.getClassLoader());
        for (String string2 : vector) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }
}

