/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER;
    public static final boolean KARATE_TELEMETRY;
    public static final String KARATE_VERSION;
    public static final String KARATE_META;
    public static final String USER_UUID;
    public static final String USER_HASH;
    public static final File WORKING_DIR;

    private FileUtils() {
    }

    public static long checksum(String src) {
        byte[] bytes = src.getBytes(StandardCharsets.UTF_8);
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static StringUtils.Pair parsePathAndTags(String text) {
        int pos = text.indexOf(64);
        if (pos == -1) {
            text = StringUtils.trimToEmpty(text);
            return new StringUtils.Pair(text, null);
        }
        String left = StringUtils.trimToEmpty(text.substring(0, pos));
        String right = StringUtils.trimToEmpty(text.substring(pos));
        return new StringUtils.Pair(left, right);
    }

    public static FeatureCall parseFeatureAndCallTag(String path) {
        StringUtils.Pair pair = FileUtils.parsePathAndTags(path);
        Feature feature = Feature.read(pair.left);
        return new FeatureCall(feature, pair.right, -1, null);
    }

    public static String toString(File file) {
        try {
            return FileUtils.toString(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(InputStream is) {
        try {
            return FileUtils.toByteStream(is).toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(File file) {
        try {
            return FileUtils.toBytes(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(InputStream is) {
        return FileUtils.toByteStream(is).toByteArray();
    }

    private static ByteArrayOutputStream toByteStream(InputStream is) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static void copy(File src, File dest) {
        try {
            FileUtils.writeToFile(dest, FileUtils.toBytes(new FileInputStream(src)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToFile(File file, byte[] data) {
        try {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToFile(File file, String data) {
        FileUtils.writeToFile(file, data.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream toInputStream(String text) {
        return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
    }

    public static void deleteDirectory(File file) {
        Path pathToBeDeleted = file.toPath();
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static void renameFileIfZeroBytes(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            LOGGER.warn("file not found, previous write operation may have failed: {}", (Object)fileName);
        } else if (file.length() == 0L) {
            LOGGER.warn("file size is zero bytes, previous write operation may have failed: {}", (Object)fileName);
            try {
                File dest = new File(fileName + ".fail");
                file.renameTo(dest);
                LOGGER.warn("renamed zero length file to: {}", (Object)dest.getName());
            }
            catch (Exception e) {
                LOGGER.warn("failed to rename zero length file: {}", (Object)e.getMessage());
            }
        }
    }

    public static String getBuildDir() {
        String temp = System.getProperty("karate.output.dir");
        if (temp != null) {
            return temp;
        }
        String command = System.getProperty("sun.java.command", "");
        return command.contains("org.gradle.") ? "build" : "target";
    }

    public static boolean isOsWindows() {
        return FileUtils.getOsType() == OsType.WINDOWS;
    }

    public static boolean isOsMacOsX() {
        return FileUtils.getOsType() == OsType.MACOSX;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static OsType getOsType() {
        return FileUtils.getOsType(FileUtils.getOsName());
    }

    public static OsType getOsType(String name) {
        if ((name = name == null ? "unknown" : name.toLowerCase()).contains("win")) {
            return OsType.WINDOWS;
        }
        if (name.contains("mac")) {
            return OsType.MACOSX;
        }
        if (name.contains("nix") || name.contains("nux")) {
            return OsType.LINUX;
        }
        return OsType.UNKNOWN;
    }

    static {
        Object hash;
        String uuid;
        String version;
        LOGGER = LoggerFactory.getLogger(FileUtils.class);
        Properties props = new Properties();
        InputStream stream = FileUtils.class.getResourceAsStream("/karate-meta.properties");
        try {
            props.load(stream);
            stream.close();
            version = (String)props.get("karate.version");
        }
        catch (IOException e) {
            version = "(unknown)";
        }
        KARATE_VERSION = version;
        KARATE_META = System.getenv("KARATE_META");
        String telemetryEnv = System.getenv("KARATE_TELEMETRY");
        KARATE_TELEMETRY = telemetryEnv == null ? true : telemetryEnv.trim().equals("true");
        String userHome = System.getProperty("user.home", "");
        try {
            File uuidFile = new File(userHome + File.separator + ".karate" + File.separator + "uuid.txt");
            if (uuidFile.exists()) {
                uuid = FileUtils.toString(uuidFile);
            } else {
                uuid = UUID.randomUUID().toString();
                FileUtils.writeToFile(uuidFile, uuid);
            }
            hash = "" + FileUtils.checksum(userHome);
        }
        catch (Exception e) {
            hash = "unknown";
            uuid = "unknown";
        }
        USER_HASH = hash;
        USER_UUID = uuid;
        WORKING_DIR = new File("").getAbsoluteFile();
    }

    public static enum OsType {
        WINDOWS,
        MACOSX,
        LINUX,
        UNKNOWN;

    }
}

