/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.Results;
import com.intuit.karate.Runner;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.MockServer;
import com.intuit.karate.core.RuntimeHookFactory;
import com.intuit.karate.http.HttpServer;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.RequestHandler;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.resource.ResourceUtils;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main
implements Callable<Void> {
    private static final String LOGBACK_CONFIG = "logback.configurationFile";
    private static Logger logger;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean help;
    @CommandLine.Parameters(split="($|,)", description={"one or more tests (features) or search-paths to run"})
    List<String> paths;
    @CommandLine.Option(names={"-m", "--mock", "--mocks"}, split=",", description={"one or more mock server files"})
    List<String> mocks;
    @CommandLine.Option(names={"-P", "--prefix"}, description={"mock server path prefix (context-path)"})
    String prefix = "/";
    @CommandLine.Option(names={"-p", "--port"}, description={"server port (default 8080)"})
    int port = 8080;
    @CommandLine.Option(names={"-W", "--watch"}, description={"watch (and hot-reload) mock server file for changes"})
    boolean watch;
    @CommandLine.Option(names={"-S", "--serve"}, description={"app server using --workdir (experimental)"})
    boolean serve;
    @CommandLine.Option(names={"-s", "--ssl"}, description={"use ssl / https, will use 'cert.pem' and 'key.pem' if they exist in the working directory, or generate them"})
    boolean ssl;
    @CommandLine.Option(names={"-c", "--cert"}, description={"ssl certificate (default: cert.pem)"})
    File cert;
    @CommandLine.Option(names={"-k", "--key"}, description={"ssl private key (default: key.pem)"})
    File key;
    @CommandLine.Option(names={"-t", "--tags"}, description={"cucumber tags - e.g. '@smoke,~@skipme' [@ignore is always skipped by default]"})
    List<String> tags;
    @CommandLine.Option(names={"-T", "--threads"}, description={"number of threads when running tests"})
    int threads;
    @CommandLine.Option(names={"-o", "--output"}, description={"directory where logs and reports are output (default 'target')"})
    String output = FileUtils.getBuildDir();
    @CommandLine.Option(names={"-f", "--format"}, split=",", description={"comma separate report output formats. tilde excludes the output report. html report is included by default unless it's negated.e.g. '-f ~html,cucumber:json,junit:xml' - possible values [html: Karate HTML, cucumber:json: Cucumber JSON, junit:xml: JUnit XML]"})
    List<String> formats;
    @CommandLine.Option(names={"-n", "--name"}, description={"scenario name"})
    String name;
    @CommandLine.Option(names={"-e", "--env"}, description={"value of 'karate.env'"})
    String env;
    @CommandLine.Option(names={"-w", "--workdir"}, description={"working directory, defaults to '.'"})
    File workingDir = FileUtils.WORKING_DIR;
    @CommandLine.Option(names={"-g", "--configdir"}, description={"directory where 'karate-config.js' is expected (default 'classpath:' or <workingdir>)"})
    String configDir;
    @CommandLine.Option(names={"-C", "--clean"}, description={"clean output directory"})
    boolean clean;
    @CommandLine.Option(names={"-B", "--backup-reportdir"}, defaultValue="true", arity="0..1", fallbackValue="true", description={"backup report directory before running tests"})
    boolean backupReportDir = true;
    @CommandLine.Option(names={"-d", "--debug"}, arity="0..1", defaultValue="-1", fallbackValue="0", description={"debug mode (optional port else dynamically chosen)"})
    int debugPort = -1;
    @CommandLine.Option(names={"-D", "--dryrun"}, description={"dry run, generate html reports only"})
    boolean dryRun;
    @CommandLine.Option(names={"-H", "--hook"}, split=",", description={"class name of a RuntimeHook (or RuntimeHookFactory) to add"})
    List<String> hookFactoryClassNames;

    public void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(path);
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOutputHtmlReport() {
        return this.formats == null ? true : !this.formats.contains("~html");
    }

    public boolean isOutputCucumberJson() {
        return this.formats == null ? false : this.formats.contains("cucumber:json");
    }

    public boolean isOutputJunitXml() {
        return this.formats == null ? false : this.formats.contains("junit:xml");
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public static Main parseKarateOptions(String line) {
        String[] args = Command.tokenize(line);
        return (Main)CommandLine.populateCommand((Object)new Main(), (String[])args);
    }

    public static Main parseKarateArgs(List<String> args) {
        return (Main)CommandLine.populateCommand((Object)new Main(), (String[])args.toArray(new String[args.size()]));
    }

    public Collection<RuntimeHook> createHooks() {
        if (this.hookFactoryClassNames != null) {
            return this.hookFactoryClassNames.stream().map(c -> this.createHook((String)c)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private RuntimeHook createHook(String hookClassName) {
        if (hookClassName != null) {
            try {
                Class<?> clazz = Class.forName(hookClassName);
                if (RuntimeHookFactory.class.isAssignableFrom(clazz)) {
                    return ((RuntimeHookFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).create();
                }
                if (RuntimeHook.class.isAssignableFrom(clazz)) {
                    return (RuntimeHook)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                logger.error("error instantiating RuntimeHook: {}", (Object)hookClassName, (Object)e);
            }
            logger.error("provided hook / class is not a RuntimeHook or RuntimeHookFactory: {}", (Object)hookClassName);
        }
        return null;
    }

    public static void main(String[] args) {
        boolean isClean = false;
        boolean isOutputArg = false;
        String outputDir = FileUtils.getBuildDir();
        for (String s : args) {
            if (isOutputArg) {
                outputDir = s;
                isOutputArg = false;
            }
            if (s.startsWith("-o") || s.startsWith("--output")) {
                int pos = s.indexOf(61);
                if (pos != -1) {
                    outputDir = s.substring(pos + 1);
                } else {
                    isOutputArg = true;
                }
            }
            if (!s.startsWith("-C") && !s.startsWith("--clean")) continue;
            isClean = true;
        }
        if (isClean) {
            System.setProperty(LOGBACK_CONFIG, "logback-nofile.xml");
        } else {
            System.setProperty("karate.output.dir", outputDir);
            String logbackConfig = System.getProperty(LOGBACK_CONFIG);
            if (StringUtils.isBlank(logbackConfig)) {
                File logbackXml = ResourceUtils.classPathOrFile("logback.xml");
                File logbackTest = ResourceUtils.classPathOrFile("logback-test.xml");
                if (logbackTest != null) {
                    System.setProperty(LOGBACK_CONFIG, "logback-test.xml");
                } else if (logbackXml != null) {
                    System.setProperty(LOGBACK_CONFIG, "logback.xml");
                } else {
                    System.setProperty(LOGBACK_CONFIG, "logback-fatjar.xml");
                }
            }
        }
        Main.resetLoggerConfig();
        logger = LoggerFactory.getLogger((String)"com.intuit.karate");
        logger.info("Karate version: {}", (Object)FileUtils.KARATE_VERSION);
        CommandLine cmd = new CommandLine((Object)new Main());
        int returnCode = cmd.execute(args);
        System.exit(returnCode);
    }

    private static void resetLoggerConfig() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        try {
            Method reset = factory.getClass().getDeclaredMethod("reset", new Class[0]);
            reset.invoke((Object)factory, new Object[0]);
            Class<?> clazz = Class.forName("ch.qos.logback.classic.util.ContextInitializer");
            Object temp = clazz.getDeclaredConstructors()[0].newInstance(factory);
            Method autoConfig = clazz.getDeclaredMethod("autoConfig", new Class[0]);
            autoConfig.invoke(temp, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Results startDebugServer(String[] args) {
        try {
            Class<?> clazz = Class.forName("io.karatelabs.debug.Main");
            if (args.length > 1) {
                Method method = clazz.getMethod("run", String[].class);
                Object results = method.invoke(null, new Object[]{args});
                return (Results)results;
            }
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
            return null;
        }
        catch (Exception e) {
            String message = "debug server failed to start";
            System.out.println(message);
            throw new RuntimeException(message);
        }
    }

    @Override
    public Void call() throws Exception {
        if (this.clean) {
            FileUtils.deleteDirectory(new File(this.output));
            logger.info("deleted directory: {}", (Object)this.output);
        }
        if (this.debugPort != -1) {
            Main.startDebugServer(new String[]{"" + this.debugPort});
            return null;
        }
        if (this.paths != null) {
            Results results = ((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)((Runner.Builder)Runner.path(this.paths).tags(this.tags)).scenarioName(this.name)).karateEnv(this.env)).workingDir(this.workingDir)).buildDir(this.output)).backupReportDir(this.backupReportDir)).configDir(this.configDir)).outputHtmlReport(this.isOutputHtmlReport())).outputCucumberJson(this.isOutputCucumberJson())).outputJunitXml(this.isOutputJunitXml())).dryRun(this.dryRun)).hooks(this.createHooks())).parallel(this.threads);
            if (results.getFailCount() > 0) {
                KarateException ke = new KarateException("there are test failures !");
                StackTraceElement[] newTrace = new StackTraceElement[]{new StackTraceElement(".", ".", ".", -1)};
                ke.setStackTrace(newTrace);
                throw ke;
            }
            return null;
        }
        if (this.clean) {
            return null;
        }
        if (this.cert == null || this.key == null) {
            this.cert = new File("cert.pem");
            this.key = new File("key.pem");
        }
        if (this.env != null) {
            System.setProperty("karate.env", this.env);
        }
        if (this.serve) {
            ServerConfig config = new ServerConfig(this.workingDir.getPath()).noCache(true).devMode(true).autoCreateSession(true);
            RequestHandler handler = new RequestHandler(config);
            HttpServer.Builder builder = HttpServer.handler(handler).corsEnabled(true);
            if (this.ssl) {
                builder.https(this.port).certFile(this.cert).keyFile(this.key);
            } else {
                builder.http(this.port);
            }
            HttpServer server = builder.build();
            server.waitSync();
            return null;
        }
        if (this.mocks == null || this.mocks.isEmpty()) {
            CommandLine.usage((Object)this, (PrintStream)System.err);
            return null;
        }
        if (this.mocks.size() == 1 && this.mocks.get(0).endsWith(".js")) {
            ServerConfig config = new ServerConfig(this.workingDir.getPath()).useGlobalSession(true);
            config.contextFactory(request -> {
                ServerContext context = new ServerContext(config, (Request)request);
                context.setApi(true);
                request.setResourcePath(this.mocks.get(0));
                return context;
            });
            HttpServer.Builder builder = HttpServer.config(config).corsEnabled(true);
            if (this.ssl) {
                builder.https(this.port);
            } else {
                builder.http(this.port);
            }
            HttpServer server = builder.build();
            server.waitSync();
            return null;
        }
        MockServer.Builder builder = MockServer.featurePaths(this.mocks).pathPrefix(this.prefix).certFile(this.cert).keyFile(this.key).watch(this.watch);
        if (this.ssl) {
            builder.https(this.port);
        } else {
            builder.http(this.port);
        }
        MockServer server = builder.build();
        server.waitSync();
        return null;
    }
}

