/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Results;
import com.intuit.karate.Runner;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioCall;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.SyncExecutorService;
import com.intuit.karate.core.Tags;
import com.intuit.karate.driver.DriverRunner;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.report.ReportUtils;
import com.intuit.karate.report.SuiteReports;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Suite
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Suite.class);
    public final long startTime;
    protected long endTime;
    protected int skippedCount;
    private AtomicBoolean abort = new AtomicBoolean(false);
    public final String env;
    public final String tagSelector;
    public final boolean dryRun;
    public final boolean debugMode;
    public final File workingDir;
    public final String buildDir;
    public final String reportDir;
    public final ClassLoader classLoader;
    public final int threadCount;
    public final int timeoutMinutes;
    public final int featuresFound;
    public final List<FeatureCall> features;
    public final List<CompletableFuture> futures;
    public final Set<File> featureResultFiles;
    public final Collection<RuntimeHook> hooks;
    public final HttpClientFactory clientFactory;
    public final Map<String, String> systemProperties;
    public final boolean backupReportDir;
    public final SuiteReports suiteReports;
    public final boolean outputHtmlReport;
    public final boolean outputCucumberJson;
    public final boolean outputJunitXml;
    public final boolean parallel;
    public final ExecutorService scenarioExecutor;
    public final ExecutorService pendingTasks;
    public final String karateBase;
    public final String karateConfig;
    public final String karateConfigEnv;
    public final Map<String, Object> callSingleCache;
    public final Map<String, ScenarioCall.Result> callOnceCache;
    public final Map<String, DriverRunner> drivers;
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    private String read(String name) {
        try {
            Resource resource = ResourceUtils.getResource(this.workingDir, name);
            logger.debug("[config] {}", (Object)resource.getPrefixedPath());
            return FileUtils.toString(resource.getStream());
        }
        catch (Exception e) {
            logger.trace("file not found: {} - {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static Suite forTempUse(HttpClientFactory hcf) {
        return new Suite((Runner.Builder)((Runner.Builder)Runner.builder().clientFactory(hcf)).forTempUse());
    }

    public Suite() {
        this(Runner.builder());
    }

    public Suite(Runner.Builder rb) {
        if (rb.forTempUse) {
            this.dryRun = false;
            this.debugMode = false;
            this.backupReportDir = false;
            this.outputHtmlReport = false;
            this.outputCucumberJson = false;
            this.outputJunitXml = false;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            this.classLoader = contextClassLoader != null ? contextClassLoader : this.getClass().getClassLoader();
            this.clientFactory = rb.clientFactory == null ? HttpClientFactory.DEFAULT : rb.clientFactory;
            this.startTime = -1L;
            this.env = rb.env;
            this.systemProperties = null;
            this.tagSelector = null;
            this.threadCount = -1;
            this.timeoutMinutes = -1;
            this.hooks = Collections.EMPTY_LIST;
            this.features = null;
            this.featuresFound = -1;
            this.futures = null;
            this.featureResultFiles = null;
            this.workingDir = FileUtils.WORKING_DIR;
            this.buildDir = FileUtils.getBuildDir();
            this.reportDir = FileUtils.getBuildDir();
            this.karateBase = null;
            this.karateConfig = null;
            this.karateConfigEnv = null;
            this.parallel = false;
            this.scenarioExecutor = null;
            this.pendingTasks = null;
            this.callSingleCache = null;
            this.callOnceCache = null;
            this.suiteReports = null;
            this.drivers = null;
        } else {
            this.startTime = System.currentTimeMillis();
            rb.resolveAll();
            this.backupReportDir = rb.backupReportDir;
            this.outputHtmlReport = rb.outputHtmlReport;
            this.outputCucumberJson = rb.outputCucumberJson;
            this.outputJunitXml = rb.outputJunitXml;
            this.dryRun = rb.dryRun;
            this.debugMode = rb.debugMode;
            this.classLoader = rb.classLoader;
            this.clientFactory = rb.clientFactory;
            this.env = rb.env;
            this.systemProperties = rb.systemProperties;
            this.tagSelector = Tags.fromKarateOptionsTags(rb.tags);
            this.hooks = rb.hooks;
            this.features = rb.features;
            this.featuresFound = this.features.size();
            this.futures = new ArrayList<CompletableFuture>(this.featuresFound);
            this.callSingleCache = rb.callSingleCache;
            this.callOnceCache = rb.callOnceCache;
            this.suiteReports = rb.suiteReports;
            this.featureResultFiles = new HashSet<File>();
            this.workingDir = rb.workingDir;
            this.buildDir = rb.buildDir;
            this.reportDir = rb.reportDir;
            this.karateBase = this.read("classpath:karate-base.js");
            this.karateConfig = this.read(rb.configDir + "karate-config.js");
            this.karateConfigEnv = this.env != null ? this.read(rb.configDir + "karate-config-" + this.env + ".js") : null;
            this.drivers = rb.drivers;
            this.threadCount = rb.threadCount;
            this.timeoutMinutes = rb.timeoutMinutes;
            boolean bl = this.parallel = this.threadCount > 1;
            if (this.parallel) {
                this.scenarioExecutor = Executors.newFixedThreadPool(this.threadCount);
                this.pendingTasks = Executors.newSingleThreadExecutor();
            } else {
                this.scenarioExecutor = SyncExecutorService.INSTANCE;
                this.pendingTasks = SyncExecutorService.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.backupReportDir) {
                this.backupReportDirIfExists();
            }
            this.hooks.forEach(h -> h.beforeSuite(this));
            int index = 0;
            for (FeatureCall feature : this.features) {
                int featureNum = ++index;
                FeatureRuntime fr = FeatureRuntime.of(this, feature);
                CompletableFuture future = new CompletableFuture();
                this.futures.add(future);
                fr.setNext(() -> {
                    this.onFeatureDone(fr.result, featureNum);
                    future.complete(Boolean.TRUE);
                });
                this.pendingTasks.submit(fr);
            }
            if (this.featuresFound > 1) {
                logger.debug("waiting for {} features to complete", (Object)this.featuresFound);
            }
            CompletableFuture[] futuresArray = this.futures.toArray(new CompletableFuture[this.futures.size()]);
            if (this.timeoutMinutes > 0) {
                CompletableFuture.allOf(futuresArray).get(this.timeoutMinutes, TimeUnit.MINUTES);
            } else {
                CompletableFuture.allOf(futuresArray).join();
            }
            this.endTime = System.currentTimeMillis();
        }
        catch (Throwable t) {
            logger.error("runner failed: " + t);
        }
        finally {
            this.scenarioExecutor.shutdownNow();
            this.pendingTasks.shutdownNow();
            this.hooks.forEach(h -> h.afterSuite(this));
        }
    }

    public void abort() {
        this.abort.set(true);
    }

    public boolean isAborted() {
        return this.abort.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFeatureResults(FeatureResult fr) {
        File file = ReportUtils.saveKarateJson(this.reportDir, fr, null);
        Set<File> set = this.featureResultFiles;
        synchronized (set) {
            this.featureResultFiles.add(file);
        }
        if (this.outputHtmlReport) {
            this.suiteReports.featureReport(this, fr).render();
        }
        if (this.outputCucumberJson) {
            ReportUtils.saveCucumberJson(this.reportDir, fr, null);
        }
        if (this.outputJunitXml) {
            ReportUtils.saveJunitXml(this.reportDir, fr, null);
        }
        fr.printStats();
    }

    private void onFeatureDone(FeatureResult fr, int index) {
        if (fr.getRunCount() > 0) {
            try {
                this.saveFeatureResults(fr);
                String status = fr.isFailed() ? "fail" : "pass";
                logger.info("<<{}>> feature {} of {} ({} remaining) {}", new Object[]{status, index, this.featuresFound, this.getFeaturesRemaining() - 1L, fr.getFeature()});
            }
            catch (Throwable t) {
                logger.error("<<error>> unable to write report file(s): {} - {}", (Object)fr.getFeature(), (Object)("" + t));
                fr.printStats();
                return;
            }
        } else {
            ++this.skippedCount;
            if (logger.isTraceEnabled()) {
                logger.trace("<<skip>> feature {} of {}: {}", new Object[]{index, this.featuresFound, fr.getFeature()});
            }
        }
    }

    private static Map toKarateJson(File file) {
        String text = FileUtils.toString(file);
        try {
            return (Map)OBJECT_MAPPER.readValue(text, TYPE_REFERENCE);
        }
        catch (Exception e) {
            logger.warn("failed to convert json, will re-try: {}", (Object)e.getMessage());
            return (Map)JsonUtils.fromJson(text);
        }
    }

    public Stream<FeatureResult> getFeatureResults() {
        return this.featureResultFiles.stream().sorted().map(file -> FeatureResult.fromKarateJson(this.workingDir, Suite.toKarateJson(file)));
    }

    public Stream<ScenarioResult> getScenarioResults() {
        return this.getFeatureResults().flatMap(fr -> fr.getScenarioResults().stream());
    }

    public ScenarioResult retryScenario(Scenario scenario) {
        scenario.setSteps(scenario.getSteps().stream().filter(Predicate.not(Step::isFake)).collect(Collectors.toList()));
        FeatureRuntime fr = FeatureRuntime.of(this, new FeatureCall(scenario.getFeature()));
        ScenarioRuntime runtime = new ScenarioRuntime(fr, scenario);
        runtime.run();
        return runtime.result;
    }

    public Results updateResults(ScenarioResult sr) {
        FeatureResult fr;
        Scenario scenario = sr.getScenario();
        File file = new File(this.reportDir + File.separator + scenario.getFeature().getKarateJsonFileName());
        if (file.exists()) {
            String json = FileUtils.toString(file);
            fr = FeatureResult.fromKarateJson(this.workingDir, Json.of(json).asMap());
        } else {
            fr = new FeatureResult(scenario.getFeature());
        }
        List<ScenarioResult> scenarioResults = fr.getScenarioResults();
        int count = scenarioResults.size();
        int found = -1;
        for (int i = 0; i < count; ++i) {
            ScenarioResult temp = scenarioResults.get(i);
            if (!temp.getScenario().isEqualTo(scenario)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            scenarioResults.set(found, sr);
        } else {
            scenarioResults.add(sr);
        }
        fr.sortScenarioResults();
        this.saveFeatureResults(fr);
        return this.buildResults();
    }

    private void backupReportDirIfExists() {
        File file = new File(this.reportDir);
        if (file.exists()) {
            File dest = new File(this.reportDir + "_" + System.currentTimeMillis());
            if (file.renameTo(dest)) {
                logger.info("backed up existing '{}' dir to: {}", (Object)this.reportDir, (Object)dest);
            } else {
                logger.warn("failed to backup existing dir: {}", (Object)file);
            }
        }
    }

    public long getFeaturesRemaining() {
        return this.futures.stream().filter(f -> !f.isDone()).count();
    }

    public Results buildResults() {
        return Results.of(this);
    }
}

