/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.StepRuntime;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.DockerTarget;
import com.intuit.karate.driver.Target;
import com.intuit.karate.http.Cookies;
import com.intuit.karate.http.HttpLogModifier;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final int DEFAULT_RETRY_INTERVAL = 3000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final int DEFAULT_HIGHLIGHT_DURATION = 3000;
    public static final String DRIVER = "driver";
    public static final String ROBOT = "robot";
    public static final String KAFKA = "kafka";
    public static final String GRPC = "grpc";
    public static final String WEBSOCKET = "websocket";
    private String url;
    private boolean sslEnabled = false;
    private String sslAlgorithm = "TLS";
    private String sslKeyStore;
    private String sslKeyStorePassword;
    private String sslKeyStoreType;
    private String sslTrustStore;
    private String sslTrustStorePassword;
    private String sslTrustStoreType;
    private boolean sslTrustAll = true;
    private boolean followRedirects = true;
    private int readTimeout = 30000;
    private int connectTimeout = 30000;
    private Charset charset = StandardCharsets.UTF_8;
    private String proxyUri;
    private String proxyUsername;
    private String proxyPassword;
    private List<String> nonProxyHosts;
    private String localAddress;
    private int responseDelay;
    private boolean xmlNamespaceAware = false;
    private boolean lowerCaseResponseHeaders = false;
    private boolean corsEnabled = false;
    private boolean logPrettyRequest;
    private boolean logPrettyResponse;
    private boolean printEnabled = true;
    private boolean pauseIfNotPerf = false;
    private boolean abortedStepsShouldPass = false;
    private boolean matchEachEmptyAllowed = false;
    private Target driverTarget;
    private Map<String, Map<String, Object>> customOptions = new HashMap<String, Map<String, Object>>();
    private HttpLogModifier logModifier;
    private Variable afterScenario = Variable.NULL;
    private Variable afterFeature = Variable.NULL;
    private Variable headers = Variable.NULL;
    private Variable cookies = Variable.NULL;
    private Variable responseHeaders = Variable.NULL;
    private List<Method> continueOnStepFailureMethods = new ArrayList<Method>();
    private boolean continueAfterContinueOnStepFailure;
    private boolean abortSuiteOnFailure;
    private int retryInterval = 3000;
    private int retryCount = 3;
    private boolean showLog = true;
    private boolean showAllSteps = true;
    private int callSingleCacheMinutes = 0;
    private String callSingleCacheDir = FileUtils.getBuildDir();
    private Map<String, Object> imageComparisonOptions;
    private boolean ntlmEnabled = false;
    private boolean httpRetryEnabled = false;
    private String ntlmUsername;
    private String ntlmPassword;
    private String ntlmDomain;
    private String ntlmWorkstation;

    public Config() {
    }

    private static <T> T get(Map<String, Object> map, String key, T defaultValue) {
        Object o = map.get(key);
        return (T)(o == null ? defaultValue : o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean configure(String key, Variable value) {
        switch (key = StringUtils.trimToEmpty(key)) {
            case "url": {
                this.url = value.getAsString();
                return false;
            }
            case "headers": {
                this.headers = value;
                return false;
            }
            case "cookies": {
                if (!value.isNull()) {
                    value = new Variable(Cookies.normalize(value.getValue()));
                }
                this.cookies = value;
                return false;
            }
            case "responseHeaders": {
                this.responseHeaders = value;
                return false;
            }
            case "responseDelay": {
                this.responseDelay = value.isNull() ? 0 : value.getAsInt();
                return false;
            }
            case "xmlNamespaceAware": {
                this.xmlNamespaceAware = value.isTrue();
                return false;
            }
            case "lowerCaseResponseHeaders": {
                this.lowerCaseResponseHeaders = value.isTrue();
                return false;
            }
            case "cors": {
                this.corsEnabled = value.isTrue();
                return false;
            }
            case "logPrettyResponse": {
                this.logPrettyResponse = value.isTrue();
                return false;
            }
            case "logPrettyRequest": {
                this.logPrettyRequest = value.isTrue();
                return false;
            }
            case "printEnabled": {
                this.printEnabled = value.isTrue();
                return false;
            }
            case "afterScenario": {
                this.afterScenario = value;
                return false;
            }
            case "afterFeature": {
                this.afterFeature = value;
                return false;
            }
            case "report": {
                if (value.isMap()) {
                    Map map = (Map)value.getValue();
                    this.showLog = Config.get(map, "showLog", this.showLog);
                    this.showAllSteps = Config.get(map, "showAllSteps", this.showAllSteps);
                    return false;
                } else if (value.isTrue()) {
                    this.showLog = true;
                    this.showAllSteps = true;
                    return false;
                } else {
                    this.showLog = false;
                    this.showAllSteps = false;
                }
                return false;
            }
            case "driver": 
            case "robot": 
            case "kafka": 
            case "grpc": 
            case "websocket": {
                this.customOptions.put(key, (Map)value.getValue());
                return false;
            }
            case "driverTarget": {
                if (value.isMap()) {
                    Map map = (Map)value.getValue();
                    if (!map.containsKey("docker")) throw new RuntimeException("bad driverTarget config, expected key 'docker': " + map);
                    this.driverTarget = new DockerTarget(map);
                    return false;
                } else {
                    this.driverTarget = (Target)value.getValue();
                }
                return false;
            }
            case "retry": {
                if (!value.isMap()) return false;
                Map map = (Map)value.getValue();
                this.retryInterval = Config.get(map, "interval", this.retryInterval);
                this.retryCount = Config.get(map, "count", this.retryCount);
                return false;
            }
            case "pauseIfNotPerf": {
                this.pauseIfNotPerf = value.isTrue();
                return false;
            }
            case "abortedStepsShouldPass": {
                this.abortedStepsShouldPass = value.isTrue();
                return false;
            }
            case "abortSuiteOnFailure": {
                this.abortSuiteOnFailure = value.isTrue();
                return false;
            }
            case "callSingleCache": {
                if (!value.isMap()) return false;
                Map map = (Map)value.getValue();
                this.callSingleCacheMinutes = Config.get(map, "minutes", this.callSingleCacheMinutes);
                this.callSingleCacheDir = Config.get(map, "dir", this.callSingleCacheDir);
                return false;
            }
            case "logModifier": {
                this.logModifier = (HttpLogModifier)value.getValue();
                return false;
            }
            case "imageComparison": {
                this.imageComparisonOptions = (Map)value.getValue();
                return false;
            }
            case "matchEachEmptyAllowed": {
                this.matchEachEmptyAllowed = (Boolean)value.getValue();
                return false;
            }
            case "continueOnStepFailure": {
                this.continueOnStepFailureMethods.clear();
                boolean enableContinueOnStepFailureFeature = false;
                Boolean continueAfterIgnoredFailure = null;
                List stepKeywords = null;
                if (value.isMap()) {
                    Map map = (Map)value.getValue();
                    stepKeywords = (List)map.get("keywords");
                    continueAfterIgnoredFailure = (Boolean)map.get("continueAfter");
                    boolean bl = enableContinueOnStepFailureFeature = map.get("enabled") != null && (Boolean)map.get("enabled") != false;
                }
                if (value.isTrue() || enableContinueOnStepFailureFeature) {
                    this.continueOnStepFailureMethods.addAll(stepKeywords == null ? StepRuntime.METHOD_MATCH : StepRuntime.findMethodsByKeywords(stepKeywords));
                } else if (stepKeywords == null) {
                    this.continueOnStepFailureMethods.clear();
                } else {
                    this.continueOnStepFailureMethods.removeAll(StepRuntime.findMethodsByKeywords(stepKeywords));
                }
                if (continueAfterIgnoredFailure == null) return false;
                this.continueAfterContinueOnStepFailure = continueAfterIgnoredFailure;
                return false;
            }
            case "charset": {
                this.charset = value.isNull() ? null : Charset.forName(value.getAsString());
                return true;
            }
            case "ssl": {
                if (value.isString()) {
                    this.sslEnabled = true;
                    this.sslAlgorithm = value.getAsString();
                    return true;
                } else if (value.isMap()) {
                    this.sslEnabled = true;
                    Map map = (Map)value.getValue();
                    this.sslKeyStore = (String)map.get("keyStore");
                    this.sslKeyStorePassword = (String)map.get("keyStorePassword");
                    this.sslKeyStoreType = (String)map.get("keyStoreType");
                    this.sslTrustStore = (String)map.get("trustStore");
                    this.sslTrustStorePassword = (String)map.get("trustStorePassword");
                    this.sslTrustStoreType = (String)map.get("trustStoreType");
                    Boolean trustAll = (Boolean)map.get("trustAll");
                    if (trustAll != null) {
                        this.sslTrustAll = trustAll;
                    }
                    this.sslAlgorithm = (String)map.get("algorithm");
                    return true;
                } else {
                    this.sslEnabled = value.isTrue();
                }
                return true;
            }
            case "followRedirects": {
                this.followRedirects = value.isTrue();
                return true;
            }
            case "connectTimeout": {
                this.connectTimeout = value.getAsInt();
                return true;
            }
            case "readTimeout": {
                this.readTimeout = value.getAsInt();
                return true;
            }
            case "proxy": {
                if (value.isNull()) {
                    this.proxyUri = null;
                    return true;
                } else if (value.isString()) {
                    this.proxyUri = value.getAsString();
                    return true;
                } else {
                    Map map = (Map)value.getValue();
                    this.proxyUri = (String)map.get("uri");
                    this.proxyUsername = (String)map.get("username");
                    this.proxyPassword = (String)map.get("password");
                    this.nonProxyHosts = (List)map.get("nonProxyHosts");
                }
                return true;
            }
            case "httpRetryEnabled": {
                this.httpRetryEnabled = value.isTrue();
                return true;
            }
            case "localAddress": {
                this.localAddress = value.getAsString();
                return true;
            }
            case "ntlmAuth": {
                if (value.isNull()) {
                    this.ntlmEnabled = false;
                    return true;
                } else {
                    Map map = (Map)value.getValue();
                    this.ntlmEnabled = true;
                    this.ntlmUsername = (String)map.get("username");
                    this.ntlmPassword = (String)map.get("password");
                    this.ntlmDomain = (String)map.get("domain");
                    this.ntlmWorkstation = (String)map.get("workstation");
                }
                return true;
            }
        }
        throw new RuntimeException("unexpected 'configure' key: '" + key + "'");
    }

    public Config(Config parent) {
        this.url = parent.url;
        this.sslEnabled = parent.sslEnabled;
        this.sslAlgorithm = parent.sslAlgorithm;
        this.sslTrustStore = parent.sslTrustStore;
        this.sslTrustStorePassword = parent.sslTrustStorePassword;
        this.sslTrustStoreType = parent.sslTrustStoreType;
        this.sslKeyStore = parent.sslKeyStore;
        this.sslKeyStorePassword = parent.sslKeyStorePassword;
        this.sslKeyStoreType = parent.sslKeyStoreType;
        this.sslTrustAll = parent.sslTrustAll;
        this.followRedirects = parent.followRedirects;
        this.readTimeout = parent.readTimeout;
        this.connectTimeout = parent.connectTimeout;
        this.charset = parent.charset;
        this.proxyUri = parent.proxyUri;
        this.proxyUsername = parent.proxyUsername;
        this.proxyPassword = parent.proxyPassword;
        this.nonProxyHosts = parent.nonProxyHosts;
        this.localAddress = parent.localAddress;
        this.responseDelay = parent.responseDelay;
        this.xmlNamespaceAware = parent.xmlNamespaceAware;
        this.lowerCaseResponseHeaders = parent.lowerCaseResponseHeaders;
        this.corsEnabled = parent.corsEnabled;
        this.logPrettyRequest = parent.logPrettyRequest;
        this.logPrettyResponse = parent.logPrettyResponse;
        this.printEnabled = parent.printEnabled;
        this.driverTarget = parent.driverTarget;
        this.customOptions = parent.customOptions;
        this.showLog = parent.showLog;
        this.showAllSteps = parent.showAllSteps;
        this.retryInterval = parent.retryInterval;
        this.retryCount = parent.retryCount;
        this.pauseIfNotPerf = parent.pauseIfNotPerf;
        this.abortedStepsShouldPass = parent.abortedStepsShouldPass;
        this.logModifier = parent.logModifier;
        this.callSingleCacheMinutes = parent.callSingleCacheMinutes;
        this.callSingleCacheDir = parent.callSingleCacheDir;
        this.headers = parent.headers;
        this.cookies = parent.cookies;
        this.responseHeaders = parent.responseHeaders;
        this.afterScenario = parent.afterScenario;
        this.afterFeature = parent.afterFeature;
        this.continueOnStepFailureMethods = parent.continueOnStepFailureMethods;
        this.continueAfterContinueOnStepFailure = parent.continueAfterContinueOnStepFailure;
        this.abortSuiteOnFailure = parent.abortSuiteOnFailure;
        this.imageComparisonOptions = parent.imageComparisonOptions;
        this.matchEachEmptyAllowed = parent.matchEachEmptyAllowed;
        this.ntlmEnabled = parent.ntlmEnabled;
        this.httpRetryEnabled = parent.httpRetryEnabled;
        this.ntlmUsername = parent.ntlmUsername;
        this.ntlmPassword = parent.ntlmPassword;
        this.ntlmDomain = parent.ntlmDomain;
        this.ntlmWorkstation = parent.ntlmWorkstation;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setCookies(Variable cookies) {
        this.cookies = cookies;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public boolean isSslTrustAll() {
        return this.sslTrustAll;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public Variable getHeaders() {
        return this.headers;
    }

    public Variable getCookies() {
        return this.cookies;
    }

    public Variable getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getResponseDelay() {
        return this.responseDelay;
    }

    public boolean isXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public boolean isLowerCaseResponseHeaders() {
        return this.lowerCaseResponseHeaders;
    }

    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }

    public boolean isLogPrettyRequest() {
        return this.logPrettyRequest;
    }

    public boolean isLogPrettyResponse() {
        return this.logPrettyResponse;
    }

    public boolean isPrintEnabled() {
        return this.printEnabled;
    }

    public boolean isHttpRetryEnabled() {
        return this.httpRetryEnabled;
    }

    public Map<String, Map<String, Object>> getCustomOptions() {
        return this.customOptions;
    }

    public Variable getAfterScenario() {
        return this.afterScenario;
    }

    public void setAfterScenario(Variable afterScenario) {
        this.afterScenario = afterScenario;
    }

    public Variable getAfterFeature() {
        return this.afterFeature;
    }

    public void setAfterFeature(Variable afterFeature) {
        this.afterFeature = afterFeature;
    }

    public boolean isShowLog() {
        return this.showLog;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public boolean isShowAllSteps() {
        return this.showAllSteps;
    }

    public void setShowAllSteps(boolean showAllSteps) {
        this.showAllSteps = showAllSteps;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isPauseIfNotPerf() {
        return this.pauseIfNotPerf;
    }

    public boolean isAbortedStepsShouldPass() {
        return this.abortedStepsShouldPass;
    }

    public Target getDriverTarget() {
        return this.driverTarget;
    }

    public void setDriverTarget(Target driverTarget) {
        this.driverTarget = driverTarget;
    }

    public HttpLogModifier getLogModifier() {
        return this.logModifier;
    }

    public String getCallSingleCacheDir() {
        return this.callSingleCacheDir;
    }

    public int getCallSingleCacheMinutes() {
        return this.callSingleCacheMinutes;
    }

    public List<Method> getContinueOnStepFailureMethods() {
        return this.continueOnStepFailureMethods;
    }

    public void setContinueOnStepFailureMethods(List<Method> continueOnStepFailureMethods) {
        this.continueOnStepFailureMethods = continueOnStepFailureMethods;
    }

    public boolean isContinueAfterContinueOnStepFailure() {
        return this.continueAfterContinueOnStepFailure;
    }

    public void setContinueAfterContinueOnStepFailure(boolean continueAfterContinueOnStepFailure) {
        this.continueAfterContinueOnStepFailure = continueAfterContinueOnStepFailure;
    }

    public void setAbortSuiteOnFailure(boolean abortSuiteOnFailure) {
        this.abortSuiteOnFailure = abortSuiteOnFailure;
    }

    public boolean isAbortSuiteOnFailure() {
        return this.abortSuiteOnFailure;
    }

    public Map<String, Object> getImageComparisonOptions() {
        return this.imageComparisonOptions;
    }

    public boolean isMatchEachEmptyAllowed() {
        return this.matchEachEmptyAllowed;
    }

    public boolean isNtlmEnabled() {
        return this.ntlmEnabled;
    }

    public void setNtlmEnabled(boolean ntlmEnabled) {
        this.ntlmEnabled = ntlmEnabled;
    }

    public String getNtlmUsername() {
        return this.ntlmUsername;
    }

    public void setNtlmUsername(String ntlmUsername) {
        this.ntlmUsername = ntlmUsername;
    }

    public String getNtlmPassword() {
        return this.ntlmPassword;
    }

    public void setNtlmPassword(String ntlmPassword) {
        this.ntlmPassword = ntlmPassword;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    public String getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public void setNtlmWorkstation(String ntlmWorkstation) {
        this.ntlmWorkstation = ntlmWorkstation;
    }

    public void setHttpRetryEnabled(boolean httpRetryEnabled) {
        this.httpRetryEnabled = httpRetryEnabled;
    }
}

