/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Config;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.report.ReportUtils;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureResult {
    private final Feature feature;
    private final List<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
    private String resultDate;
    private String displayName;
    private Map<String, Object> resultVariables;
    private Map<String, Object> callArg;
    private Config config;
    private int loopIndex = -1;
    private int callDepth;
    private int skippedCount;

    public FeatureResult(Feature feature) {
        this.feature = feature;
        this.displayName = feature.getResource().getRelativePath();
    }

    public void printStats() {
        String featureName = this.feature.getResource().getPrefixedPath();
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------------------------------\n");
        sb.append("feature: ").append(featureName).append('\n');
        sb.append(String.format("scenarios: %2d | passed: %2d | failed: %2d | time: %.4f\n", this.getRunCount(), this.getPassedCount(), this.getFailedCount(), this.getDurationMillis() / 1000.0));
        sb.append("---------------------------------------------------------\n");
        System.out.println(sb);
    }

    public List<File> getAllEmbedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (ScenarioResult sr : this.scenarioResults) {
            for (StepResult stepResult : sr.getStepResults()) {
                if (stepResult.getEmbeds() == null) continue;
                for (Embed embed : stepResult.getEmbeds()) {
                    files.add(embed.getFile());
                }
            }
        }
        return files;
    }

    public static FeatureResult fromKarateJson(File workingDir, Map<String, Object> map) {
        String featurePath = (String)map.get("prefixedPath");
        Resource resource = ResourceUtils.getResource(workingDir, featurePath);
        Feature feature = Feature.read(resource);
        FeatureResult fr = new FeatureResult(feature);
        fr.callArg = (Map)map.get("callArg");
        fr.loopIndex = (Integer)map.get("loopIndex");
        fr.resultDate = (String)map.get("resultDate");
        fr.callDepth = (Integer)map.get("callDepth");
        fr.setSkippedCount((Integer)map.get("skippedCount"));
        List list = (List)map.get("scenarioResults");
        if (list != null) {
            for (Map srMap : list) {
                ScenarioResult sr = ScenarioResult.fromKarateJson(workingDir, feature, srMap);
                if (sr.getStepResults().isEmpty()) continue;
                fr.addResult(sr);
            }
        }
        return fr;
    }

    public Map<String, Object> toInfoJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.feature.getName());
        map.put("description", this.feature.getDescription());
        map.put("prefixedPath", this.feature.getResource().getPrefixedPath());
        File file = this.feature.getResource().getFile();
        if (file != null) {
            map.put("fileName", file.getName());
            map.put("parentDir", file.getParent());
        }
        return map;
    }

    public Map<String, Object> toSummaryJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failed", this.isFailed());
        map.put("name", this.feature.getName());
        map.put("description", this.feature.getDescription());
        map.put("durationMillis", this.getDurationMillis());
        map.put("passedCount", this.getPassedCount());
        map.put("failedCount", this.getFailedCount());
        map.put("skippedCount", this.getSkippedCount());
        map.put("totalRunCount", this.getRunCount());
        map.put("totalCount", this.getTotalCount());
        map.put("scenarioCount", this.getRunCount());
        map.put("packageQualifiedName", this.feature.getPackageQualifiedName());
        map.put("relativePath", this.feature.getResource().getRelativePath());
        return map;
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.feature.getName());
        map.put("description", this.feature.getDescription());
        map.put("durationMillis", this.getDurationMillis());
        map.put("passedCount", this.getPassedCount());
        map.put("failedCount", this.getFailedCount());
        map.put("skippedCount", this.getSkippedCount());
        map.put("totalRunCount", this.getRunCount());
        map.put("totalCount", this.getTotalCount());
        map.put("packageQualifiedName", this.feature.getPackageQualifiedName());
        map.put("relativePath", this.feature.getResource().getRelativePath());
        if (this.resultDate == null) {
            this.resultDate = ReportUtils.getDateString();
        }
        map.put("resultDate", this.resultDate);
        map.put("prefixedPath", this.feature.getResource().getPrefixedPath());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.scenarioResults.size());
        map.put("scenarioResults", list);
        for (ScenarioResult sr : this.scenarioResults) {
            list.add(sr.toKarateJson());
        }
        if (this.callArg != null) {
            String json = JsonUtils.toJsonSafe(this.callArg, false);
            map.put("callArg", JsonUtils.fromJson(json));
        }
        map.put("loopIndex", this.loopIndex);
        map.put("callDepth", this.callDepth);
        return map;
    }

    public Map<String, Object> toCucumberJson() {
        Object temp;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keyword", "Feature");
        map.put("line", this.feature.getLine());
        map.put("uri", this.displayName);
        map.put("name", this.displayName);
        map.put("id", StringUtils.toIdString(this.feature.getName()));
        Object object = temp = this.feature.getName() == null ? "" : this.feature.getName();
        if (this.feature.getDescription() != null) {
            temp = (String)temp + "\n" + this.feature.getDescription();
        }
        map.put("description", ((String)temp).trim());
        if (this.feature.getTags() != null) {
            map.put("tags", ScenarioResult.tagsToCucumberJson(this.feature.getTags()));
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.scenarioResults.size());
        map.put("elements", list);
        for (ScenarioResult sr : this.scenarioResults) {
            Map<String, Object> backgroundMap = sr.backgroundToCucumberJson();
            if (backgroundMap != null) {
                list.add(backgroundMap);
            }
            list.add(sr.toCucumberJson());
        }
        return map;
    }

    public List<StepResult> getAllScenarioStepResultsNotHidden() {
        ArrayList<StepResult> list = new ArrayList<StepResult>();
        for (ScenarioResult sr : this.scenarioResults) {
            list.addAll(sr.getStepResultsNotHidden());
        }
        return list;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public KarateException getErrorMessagesCombined() {
        List<String> errors = this.getErrors();
        if (errors.size() == 1) {
            return new KarateException(errors.get(0));
        }
        return new KarateException(this.getErrorMessages());
    }

    public String getErrorMessages() {
        return StringUtils.join(this.getErrors(), "\n");
    }

    public String getCallNameForReport() {
        String append = this.loopIndex == -1 ? "" : "[" + this.loopIndex + "] ";
        return append + this.displayName;
    }

    public String getCallArgPretty() {
        if (this.callArg == null) {
            return null;
        }
        try {
            return JsonUtils.toJsonSafe(this.callArg, true);
        }
        catch (Throwable t) {
            return "#error: " + t.getMessage();
        }
    }

    public void setCallDepth(int callDepth) {
        this.callDepth = callDepth;
    }

    public Map<String, Object> getCallArg() {
        return this.callArg;
    }

    public void setCallArg(Map<String, Object> callArg) {
        this.callArg = callArg;
    }

    public int getLoopIndex() {
        return this.loopIndex;
    }

    public void setLoopIndex(int loopIndex) {
        this.loopIndex = loopIndex;
    }

    public double getDurationMillis() {
        long durationNanos = 0L;
        for (ScenarioResult sr : this.scenarioResults) {
            durationNanos += sr.getDurationNanos();
        }
        return ReportUtils.nanosToMillis(durationNanos);
    }

    public int getFailedCount() {
        return this.getErrors().size();
    }

    public boolean isEmpty() {
        return this.scenarioResults.isEmpty();
    }

    public int getRunCount() {
        return this.scenarioResults.size();
    }

    public int getPassedCount() {
        return this.getRunCount() - this.getFailedCount();
    }

    public boolean isFailed() {
        return this.getFailedCount() > 0;
    }

    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (ScenarioResult sr : this.scenarioResults) {
            if (!sr.isFailed()) continue;
            errors.add(sr.getErrorMessage());
        }
        return errors;
    }

    public void addResult(ScenarioResult result) {
        this.scenarioResults.add(result);
    }

    public void setVariables(Map<String, Object> resultVariables) {
        this.resultVariables = resultVariables;
    }

    public Map<String, Object> getVariables() {
        return this.resultVariables == null ? new HashMap() : this.resultVariables;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void sortScenarioResults() {
        Collections.sort(this.scenarioResults);
    }

    public List<ScenarioResult> getScenarioResults() {
        return this.scenarioResults;
    }

    public String toString() {
        return this.displayName;
    }

    public int getTotalCount() {
        return this.getRunCount() + this.getSkippedCount();
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public void setSkippedCount(int skippedCount) {
        this.skippedCount = skippedCount;
    }
}

