/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelProcessor<T> {
    private static final Logger logger = LoggerFactory.getLogger(ParallelProcessor.class);
    private final ExecutorService executor;
    private final ExecutorService monitor;
    private final Iterator<T> publisher;
    private final List<CompletableFuture> futures = new ArrayList<CompletableFuture>();

    public ParallelProcessor(ExecutorService executor, Iterator<T> publisher, ExecutorService monitor) {
        this.executor = executor;
        this.publisher = publisher;
        this.monitor = monitor;
    }

    private Runnable toRunnable(CompletableFuture prevFuture, T next, CompletableFuture future) {
        return () -> {
            if (prevFuture != null) {
                prevFuture.join();
            }
            try {
                this.process(next);
            }
            catch (Exception e) {
                logger.error("[parallel] input item failed: {}", (Object)e.getMessage());
            }
            future.complete(Boolean.TRUE);
        };
    }

    public void execute() {
        CompletableFuture prevFuture = null;
        while (this.publisher.hasNext()) {
            CompletableFuture future = new CompletableFuture();
            this.futures.add(future);
            T next = this.publisher.next();
            boolean sync = this.shouldRunSynchronously(next);
            this.executor.submit(this.toRunnable(prevFuture, next, future));
            prevFuture = sync ? future : null;
        }
        CompletableFuture[] futuresArray = this.futures.toArray(new CompletableFuture[this.futures.size()]);
        this.monitor.submit(() -> {
            CompletableFuture.allOf(futuresArray).join();
            this.onComplete();
        });
    }

    public boolean shouldRunSynchronously(T in) {
        return false;
    }

    public abstract void process(T var1);

    public abstract void onComplete();
}

