/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.Variable;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;

public class ScenarioFileReader {
    private final ScenarioEngine engine;
    private final FeatureRuntime featureRuntime;

    public ScenarioFileReader(ScenarioEngine engine, FeatureRuntime featureRuntime) {
        this.engine = engine;
        this.featureRuntime = featureRuntime;
    }

    public Object readFile(String text) {
        StringUtils.Pair pair = ScenarioFileReader.parsePathAndTags(text);
        text = pair.left;
        if (text == null && pair.right != null && pair.right.startsWith("@")) {
            return new FeatureCall(this.featureRuntime.featureCall.feature, pair.right, -1, null);
        }
        if (ScenarioFileReader.isJsonFile(text) || ScenarioFileReader.isXmlFile(text)) {
            String contents = this.readFileAsString(text);
            Variable temp = this.engine.evalKarateExpression(contents);
            return temp.getValue();
        }
        if (ScenarioFileReader.isJavaScriptFile(text)) {
            String contents = this.readFileAsString(text);
            Variable temp = this.engine.evalJs("(" + contents + ")");
            return temp.getValue();
        }
        if (ScenarioFileReader.isTextFile(text) || ScenarioFileReader.isGraphQlFile(text)) {
            return this.readFileAsString(text);
        }
        if (ScenarioFileReader.isFeatureFile(text)) {
            Resource fr = this.toResource(text);
            Feature feature = Feature.read(fr);
            return new FeatureCall(feature, pair.right, -1, null);
        }
        if (ScenarioFileReader.isCsvFile(text)) {
            String contents = this.readFileAsString(text);
            return JsonUtils.fromCsv(contents);
        }
        if (ScenarioFileReader.isYamlFile(text)) {
            String contents = this.readFileAsString(text);
            Object asJson = JsonUtils.fromYaml(contents);
            Variable temp = this.engine.evalKarateExpression(JsonUtils.toJson(asJson));
            return temp.getValue();
        }
        InputStream is = this.readFileAsStream(text);
        return FileUtils.toBytes(is);
    }

    public String toAbsolutePath(String relativePath) {
        Resource resource = this.toResource(relativePath);
        try {
            return resource.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            return resource.getFile().getAbsolutePath();
        }
    }

    public byte[] readFileAsBytes(String path) {
        return FileUtils.toBytes(this.readFileAsStream(path));
    }

    public String readFileAsString(String path) {
        return FileUtils.toString(this.readFileAsStream(path));
    }

    public InputStream readFileAsStream(String path) {
        return this.toResource(path).getStream();
    }

    private static String removePrefix(String text) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(58);
        return pos == -1 ? text : text.substring(pos + 1);
    }

    private static StringUtils.Pair parsePathAndTags(String text) {
        if (text.startsWith("@")) {
            return new StringUtils.Pair(null, StringUtils.trimToEmpty(text));
        }
        int pos = text.indexOf(".feature@");
        if (pos == -1) {
            pos = text.indexOf(".feature?");
            if (pos != -1) {
                text = text.substring(0, pos + 8);
            }
            text = StringUtils.trimToEmpty(text);
            return new StringUtils.Pair(text, null);
        }
        return new StringUtils.Pair(StringUtils.trimToEmpty(text.substring(0, pos + 8)), StringUtils.trimToEmpty(text.substring(pos + 9)));
    }

    public Resource toResource(String path) {
        if (ScenarioFileReader.isClassPath(path)) {
            return ResourceUtils.getResource(this.featureRuntime.suite.workingDir, path);
        }
        if (ScenarioFileReader.isFilePath(path)) {
            return ResourceUtils.getResource(this.featureRuntime.suite.workingDir, ScenarioFileReader.removePrefix(path));
        }
        if (ScenarioFileReader.isThisPath(path)) {
            return this.featureRuntime.resolveFromThis(ScenarioFileReader.removePrefix(path));
        }
        return this.featureRuntime.resolveFromRoot(path);
    }

    private static boolean isClassPath(String text) {
        return text.startsWith("classpath:");
    }

    private static boolean isFilePath(String text) {
        return text.startsWith("file:");
    }

    private static boolean isThisPath(String text) {
        return text.startsWith("this:");
    }

    private static boolean isJsonFile(String text) {
        return text.endsWith(".json");
    }

    private static boolean isJavaScriptFile(String text) {
        return text.endsWith(".js");
    }

    private static boolean isYamlFile(String text) {
        return text.endsWith(".yaml") || text.endsWith(".yml");
    }

    private static boolean isXmlFile(String text) {
        return text.endsWith(".xml");
    }

    private static boolean isTextFile(String text) {
        return text.endsWith(".txt");
    }

    private static boolean isCsvFile(String text) {
        return text.endsWith(".csv");
    }

    private static boolean isGraphQlFile(String text) {
        return text.endsWith(".graphql") || text.endsWith(".gql");
    }

    private static boolean isFeatureFile(String text) {
        return text.endsWith(".feature");
    }
}

