/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tag;
import com.intuit.karate.report.ReportUtils;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScenarioResult
implements Comparable<ScenarioResult> {
    private final List<StepResult> stepResults = new ArrayList<StepResult>();
    private final Scenario scenario;
    private StepResult failedStep;
    private String executorName;
    private long startTime;
    private long endTime;
    private long durationNanos;

    @Override
    public int compareTo(ScenarioResult sr) {
        if (sr == null) {
            return 1;
        }
        int delta = this.scenario.getLine() - sr.scenario.getLine();
        if (delta != 0) {
            return delta;
        }
        return this.scenario.getExampleIndex() - sr.scenario.getExampleIndex();
    }

    public String getFailureMessageForDisplay() {
        if (this.failedStep == null) {
            return null;
        }
        Step step = this.failedStep.getStep();
        String featureName = this.scenario.getFeature().getResource().getRelativePath();
        return featureName + ":" + step.getLine() + " " + step.getText();
    }

    public StepResult addFakeStepResult(String message, Throwable error) {
        Step step = new Step(this.scenario, -1);
        step.setLine(this.scenario.getLine());
        step.setPrefix("*");
        step.setText(message);
        Result result = error == null ? Result.passed(System.currentTimeMillis(), 0L) : Result.failed(System.currentTimeMillis(), 0L, error, step);
        StepResult sr = new StepResult(step, result);
        if (error != null) {
            sr.setStepLog(error.getMessage());
        }
        this.addStepResult(sr);
        return sr;
    }

    public void addStepResults(List<StepResult> value) {
        if (value != null) {
            value.forEach(this::addStepResult);
        }
    }

    public void addStepResult(StepResult stepResult) {
        this.stepResults.add(stepResult);
        Result result = stepResult.getResult();
        this.durationNanos += result.getDurationNanos();
        if (result.isFailed()) {
            this.failedStep = stepResult;
        }
    }

    private static void recurse(List<Map> list, StepResult stepResult, int depth) {
        if (stepResult.getCallResults() != null) {
            for (FeatureResult fr : stepResult.getCallResults()) {
                Step call = new Step(stepResult.getStep().getFeature(), -1);
                call.setLine(stepResult.getStep().getLine());
                call.setPrefix(StringUtils.repeat('>', depth));
                call.setText(fr.getCallNameForReport());
                StepResult callResult = new StepResult(call, Result.passed(stepResult.getResult().getStartTime(), 0L));
                callResult.setHidden(stepResult.isHidden());
                list.add(callResult.toCucumberJson());
                for (StepResult sr : fr.getAllScenarioStepResultsNotHidden()) {
                    Map<String, Object> map = sr.toCucumberJson();
                    String temp = (String)map.get("keyword");
                    map.put("keyword", StringUtils.repeat('>', depth + 1) + " " + temp);
                    list.add(map);
                    ScenarioResult.recurse(list, sr, depth + 1);
                }
            }
        }
    }

    private List<Map> getStepResults(boolean background) {
        ArrayList<Map> list = new ArrayList<Map>(this.stepResults.size());
        for (StepResult stepResult : this.stepResults) {
            if (stepResult.isHidden() || background != stepResult.getStep().isBackground()) continue;
            list.add(stepResult.toCucumberJson());
            ScenarioResult.recurse(list, stepResult, 0);
        }
        return list;
    }

    public static ScenarioResult fromKarateJson(File workingDir, Feature feature, Map<String, Object> map) {
        List list;
        int sectionIndex = (Integer)map.get("sectionIndex");
        int exampleIndex = (Integer)map.get("exampleIndex");
        FeatureSection section = feature.getSection(sectionIndex);
        Scenario scenario = new Scenario(feature, section, exampleIndex);
        if (section.isOutline()) {
            scenario.setTags(section.getScenarioOutline().getTags());
            scenario.setDescription(section.getScenarioOutline().getDescription());
        } else {
            scenario.setTags(section.getScenario().getTags());
            scenario.setDescription(section.getScenario().getDescription());
        }
        scenario.setName((String)map.get("name"));
        scenario.setDescription((String)map.get("description"));
        scenario.setLine((Integer)map.get("line"));
        scenario.setExampleData((Map)map.get("exampleData"));
        ScenarioResult sr = new ScenarioResult(scenario);
        String executorName = (String)map.get("executorName");
        Number startTime = (Number)map.get("startTime");
        Number endTime = (Number)map.get("endTime");
        sr.setExecutorName(executorName);
        if (startTime != null) {
            sr.setStartTime(startTime.longValue());
        }
        if (endTime != null) {
            sr.setEndTime(endTime.longValue());
        }
        if ((list = (List)map.get("stepResults")) != null) {
            ArrayList<Step> steps = new ArrayList<Step>(list.size());
            for (Map stepResultMap : list) {
                StepResult stepResult = StepResult.fromKarateJson(workingDir, scenario, stepResultMap);
                sr.addStepResult(stepResult);
                Step step = stepResult.getStep();
                if (step.isBackground() || step.getLine() == -1) continue;
                steps.add(step);
            }
            scenario.setSteps(steps);
        }
        return sr;
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("durationMillis", this.getDurationMillis());
        List<String> tags = this.scenario.getTagsEffective().getTags();
        if (tags != null && !tags.isEmpty()) {
            map.put("tags", tags);
        }
        map.put("failed", this.isFailed());
        map.put("refId", this.scenario.getRefId());
        if (this.isFailed()) {
            map.put("error", this.getErrorMessage());
        }
        map.put("sectionIndex", this.scenario.getSection().getIndex());
        map.put("exampleIndex", this.scenario.getExampleIndex());
        Map<String, Object> exampleData = this.scenario.getExampleData();
        if (exampleData != null) {
            map.put("exampleData", exampleData);
        }
        map.put("name", this.scenario.getName());
        map.put("description", this.scenario.getDescription());
        map.put("line", this.scenario.getLine());
        map.put("executorName", this.executorName);
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.stepResults.size());
        map.put("stepResults", list);
        for (StepResult sr : this.stepResults) {
            list.add(sr.toKarateJson());
        }
        return map;
    }

    public Map<String, Object> toCucumberJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.scenario.getName());
        map.put("steps", this.getStepResults(false));
        map.put("line", this.scenario.getLine());
        map.put("id", StringUtils.toIdString(this.scenario.getName()));
        map.put("description", this.scenario.getDescription());
        map.put("type", "scenario");
        map.put("keyword", this.scenario.isOutlineExample() ? "Scenario Outline" : "Scenario");
        map.put("tags", ScenarioResult.tagsToCucumberJson(this.scenario.getTagsEffective().getOriginal()));
        map.put("start_timestamp", Instant.ofEpochMilli(this.startTime).toString());
        return map;
    }

    public static List<Map> tagsToCucumberJson(Collection<Tag> tags) {
        ArrayList<Map> list = new ArrayList<Map>(tags.size());
        for (Tag tag : tags) {
            HashMap<String, Object> tagMap = new HashMap<String, Object>(2);
            tagMap.put("line", tag.getLine());
            tagMap.put("name", "@" + tag.getText());
            list.add(tagMap);
        }
        return list;
    }

    public Map<String, Object> backgroundToCucumberJson() {
        if (!this.scenario.getFeature().isBackgroundPresent()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "");
        map.put("steps", this.getStepResults(true));
        map.put("line", this.scenario.getFeature().getBackground().getLine());
        map.put("description", "");
        map.put("type", "background");
        map.put("keyword", "Background");
        return map;
    }

    public ScenarioResult(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public List<StepResult> getStepResults() {
        return this.stepResults;
    }

    public List<StepResult> getStepResultsNotHidden() {
        ArrayList<StepResult> list = new ArrayList<StepResult>(this.stepResults.size());
        for (StepResult sr : this.stepResults) {
            if (sr.isHidden()) continue;
            list.add(sr);
        }
        return list;
    }

    public boolean isFailed() {
        return this.failedStep != null;
    }

    public StepResult getFailedStep() {
        return this.failedStep;
    }

    public Throwable getError() {
        return this.failedStep == null ? null : this.failedStep.getResult().getError();
    }

    public String getErrorMessage() {
        return this.failedStep == null ? null : this.failedStep.getResult().getErrorMessage();
    }

    public long getDurationNanos() {
        return this.durationNanos;
    }

    public double getDurationMillis() {
        return ReportUtils.nanosToMillis(this.durationNanos);
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String toString() {
        return this.failedStep == null ? this.scenario.toString() : "" + this.failedStep;
    }
}

