/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Constants;
import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.MockHandler;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.DevToolsMessage;
import com.intuit.karate.driver.DevToolsMock;
import com.intuit.karate.driver.DevToolsWait;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.Frame;
import com.intuit.karate.driver.Input;
import com.intuit.karate.driver.Keys;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.WebSocketClient;
import com.intuit.karate.http.WebSocketOptions;
import com.intuit.karate.shell.Command;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.polyglot.Value;

public abstract class DevToolsDriver
implements Driver {
    protected final DriverOptions options;
    protected final Command command;
    protected final WebSocketClient client;
    private boolean terminated;
    private final DevToolsWait wait;
    protected final String rootFrameId;
    private Integer windowId;
    private String windowState;
    protected String sessionId;
    protected String mainFrameId;
    private Frame frame;
    private final Map<String, Integer> frameContexts = new HashMap<String, Integer>();
    private final Map<String, String> frameSessions = new HashMap<String, String>();
    protected boolean domContentEventFired;
    protected final Set<String> framesStillLoading = new HashSet<String>();
    private boolean submit;
    protected String currentDialogText;
    private int nextId;
    private MockHandler mockHandler;
    protected final Logger logger;
    protected int currentMouseXpos;
    protected int currentMouseYpos;

    public int nextId() {
        return ++this.nextId;
    }

    protected DevToolsDriver(DriverOptions options, Command command, String webSocketUrl) {
        this.logger = options.driverLogger;
        this.options = options;
        this.command = command;
        if (options.isRemoteHost()) {
            String host = options.host;
            Integer port = options.port;
            webSocketUrl = webSocketUrl.replace("ws://localhost/", "ws://" + host + ":" + port + "/");
        }
        this.wait = new DevToolsWait(this, options);
        int pos = webSocketUrl.lastIndexOf(47);
        this.mainFrameId = this.rootFrameId = webSocketUrl.substring(pos + 1);
        this.logger.debug("root frame id: {}", this.rootFrameId);
        WebSocketOptions wsOptions = new WebSocketOptions(webSocketUrl);
        wsOptions.setMaxPayloadSize(options.maxPayloadSize);
        wsOptions.setTextConsumer(text -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< {}", text);
            } else {
                this.logger.debug("<< {}", StringUtils.truncate(text, 1024, true));
            }
            Map map = (Map)Json.of(text).value();
            DevToolsMessage dtm = new DevToolsMessage(this, map);
            this.receive(dtm);
        });
        this.client = new WebSocketClient(wsOptions, this.logger);
    }

    @Override
    public Driver timeout(Integer millis) {
        this.options.setTimeout(millis);
        return this;
    }

    @Override
    public Driver timeout() {
        return this.timeout(null);
    }

    public DevToolsMessage method(String method) {
        return new DevToolsMessage(this, method);
    }

    public Map<String, Object> send(Map<String, Object> map) {
        DevToolsMessage dtm = new DevToolsMessage(this, map);
        dtm.setId(this.nextId());
        return this.sendAndWait(dtm, null).toMap();
    }

    public void send(DevToolsMessage dtm) {
        String json = JsonUtils.toJson(dtm.toMap());
        this.logger.debug(">> {}", json);
        this.client.send(json);
    }

    public DevToolsMessage sendAndWait(DevToolsMessage dtm, Predicate<DevToolsMessage> condition) {
        DevToolsMessage result;
        boolean wasSubmit = this.submit;
        if (condition == null && this.submit) {
            this.submit = false;
            condition = DevToolsWait.ALL_FRAMES_LOADED;
        }
        if ((result = this.wait.send(dtm, condition)) == null && !wasSubmit) {
            if (condition == DevToolsWait.ALL_FRAMES_LOADED) {
                this.logger.error("failed to get reply for :" + dtm + ". Will try to check by running a script.", new Object[0]);
                boolean readyState = (Boolean)this.script("document.readyState === 'complete'");
                if (!readyState) {
                    throw new RuntimeException("failed to get reply for: " + dtm);
                }
                this.logger.warn("document is ready, but no reply for: " + dtm + " with a ready event received. Will proceed.", new Object[0]);
            } else {
                throw new RuntimeException("failed to get reply for: " + dtm);
            }
        }
        return result;
    }

    public void receive(DevToolsMessage dtm) {
        String targetType;
        String frameId;
        Integer frameContextId;
        if (dtm.methodIs("Page.domContentEventFired")) {
            this.domContentEventFired = true;
            this.logger.trace("** set dom ready flag to true", new Object[0]);
        }
        if (dtm.methodIs("Page.javascriptDialogOpening")) {
            this.currentDialogText = (String)dtm.getParam("message");
            this.wait.setCondition(DevToolsWait.DIALOG_OPENING);
        }
        if (dtm.methodIs("Page.frameStartedLoading")) {
            String frameLoadingId = (String)dtm.getParam("frameId");
            if (this.rootFrameId.equals(frameLoadingId)) {
                this.domContentEventFired = false;
                this.framesStillLoading.clear();
                this.logger.trace("** root frame started loading, cleared all page state: {}", frameLoadingId);
            } else {
                this.framesStillLoading.add(frameLoadingId);
                this.logger.trace("** frame started loading, added to in-progress list: {}", this.framesStillLoading);
            }
        }
        if (dtm.methodIs("Page.frameStoppedLoading")) {
            String frameLoadedId = (String)dtm.getParam("frameId");
            this.framesStillLoading.remove(frameLoadedId);
            this.logger.trace("** frame stopped loading: {}, remaining in-progress: {}", frameLoadedId, this.framesStillLoading);
        }
        if (dtm.methodIs("Page.frameNavigated")) {
            Frame newFrame = new Frame((String)dtm.getParam("frame.id"), (String)dtm.getParam("frame.url"), (String)dtm.getParam("frame.name"));
            this.logger.trace("** detected new frame: {}", newFrame);
            if (this.frame != null && (this.frame.name.equals(newFrame.name) || this.frame.url.equals(newFrame.url))) {
                this.logger.trace("** auto switching frame: {} -> {}", this.frame, newFrame);
                this.frame = newFrame;
            }
        }
        if (dtm.methodIs("Runtime.executionContextCreated")) {
            String newFrameId = (String)dtm.getParam("context.auxData.frameId");
            Integer contextId = (Integer)dtm.getParam("context.id");
            this.frameContexts.put(newFrameId, contextId);
            this.logger.trace("** new frame execution context: {} - {}", newFrameId, contextId);
        }
        if (dtm.methodIs("Runtime.executionContextsCleared")) {
            this.frame = null;
            this.frameContexts.clear();
            this.framesStillLoading.clear();
        }
        if (dtm.methodIs("Runtime.consoleAPICalled") && this.options.showBrowserLog) {
            List values = (List)dtm.getParam("args[*].value");
            for (Object value : values) {
                this.logger.debug("[console] {}", value);
            }
        }
        if (dtm.methodIs("Fetch.requestPaused")) {
            this.handleInterceptedRequest(dtm);
        }
        if (dtm.methodIs("Target.targetInfoChanged") && (frameContextId = this.frameContexts.get(frameId = (String)dtm.getParam("targetInfo.targetId"))) != null) {
            this.logger.trace("** removed stale execution context: {} - {}", frameId, frameContextId);
            this.frameContexts.remove(frameId);
        }
        if (dtm.methodIs("Target.attachedToTarget") && ("iframe".equals(targetType = (String)dtm.getParam("targetInfo.type")) || "frame".equals(targetType))) {
            String targetSessionId = (String)dtm.getParam("sessionId");
            String targetFrameId = (String)dtm.getParam("targetInfo.targetId");
            this.frameSessions.put(targetFrameId, targetSessionId);
            this.logger.trace("** new frame session: {} - {}", targetFrameId, targetSessionId);
        }
        this.wait.receive(dtm);
    }

    private void handleInterceptedRequest(DevToolsMessage dtm) {
        String requestId = (String)dtm.getParam("requestId");
        String requestUrl = (String)dtm.getParam("request.url");
        if (this.mockHandler != null) {
            String method = (String)dtm.getParam("request.method");
            Map headers = (Map)dtm.getParam("request.headers");
            String postData = (String)dtm.getParam("request.postData");
            this.logger.debug("intercepting request for url: {}", requestUrl);
            HttpRequest request = new HttpRequest();
            request.setUrl(requestUrl);
            request.setMethod(method);
            headers.forEach((k, v) -> request.putHeader((String)k, (String)v));
            if (postData != null) {
                request.setBody(FileUtils.toBytes(postData));
            } else {
                request.setBody(Constants.ZERO_BYTES);
            }
            Response response = this.mockHandler.handle(request.toRequest());
            String responseBody = response.getBody() == null ? "" : Base64.getEncoder().encodeToString(response.getBody());
            ArrayList responseHeaders = new ArrayList();
            Map<String, List<String>> map = response.getHeaders();
            if (map != null) {
                map.forEach((k, v) -> {
                    if (v != null && !v.isEmpty()) {
                        HashMap<String, String> nv = new HashMap<String, String>(2);
                        nv.put("name", (String)k);
                        nv.put("value", (String)v.get(0));
                        responseHeaders.add(nv);
                    }
                });
            }
            this.method("Fetch.fulfillRequest").param("requestId", requestId).param("responseCode", response.getStatus()).param("responseHeaders", responseHeaders).param("body", responseBody).sendWithoutWaiting();
        } else {
            this.logger.warn("no mock server, continuing paused request to url: {}", requestUrl);
            this.method("Fetch.continueRequest").param("requestId", requestId).sendWithoutWaiting();
        }
    }

    private DevToolsMessage evalOnce(String expression, boolean quickly, boolean fireAndForget, boolean returnByValue) {
        Integer contextId;
        DevToolsMessage toSend = this.method("Runtime.evaluate").param("expression", expression);
        if (returnByValue) {
            toSend.param("returnByValue", true);
        }
        if ((contextId = this.getFrameContext()) != null) {
            toSend.param("contextId", contextId);
        }
        if (quickly) {
            toSend.setTimeout(this.options.getRetryInterval());
        }
        if (fireAndForget) {
            toSend.sendWithoutWaiting();
            return null;
        }
        return toSend.send();
    }

    protected DevToolsMessage eval(String expression) {
        return this.evalInternal(expression, false, true);
    }

    protected DevToolsMessage evalQuickly(String expression) {
        return this.evalInternal(expression, true, true);
    }

    protected String evalForObjectId(String expression) {
        return this.options.retry(() -> {
            DevToolsMessage dtm = this.evalInternal(expression, true, false);
            return (String)dtm.getResult("objectId");
        }, returned -> returned != null, "eval for object id: " + expression, true);
    }

    private DevToolsMessage evalInternal(String expression, boolean quickly, boolean returnByValue) {
        DevToolsMessage dtm = this.evalOnce(expression, quickly, false, returnByValue);
        if (dtm.isResultError()) {
            Object errorCode;
            Map<String, Object> error = dtm.getError();
            if (error != null && (errorCode = error.get("code")) instanceof Integer && (Integer)errorCode == -32000) {
                dtm.setResult(Variable.NULL);
                return dtm;
            }
            String message = "js eval failed once:" + expression + ", error: " + dtm.getResult();
            this.logger.warn(message, new Object[0]);
            this.options.sleep();
            dtm = this.evalOnce(expression, quickly, false, returnByValue);
            if (dtm.isResultError()) {
                message = "js eval failed twice:" + expression + ", error: " + dtm.getResult();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return dtm;
    }

    protected void retryIfEnabled(String locator) {
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        if (this.options.highlight) {
            String highlightJs = this.options.highlight(locator, this.options.highlightDuration);
            this.evalOnce(highlightJs, true, true, true);
        }
    }

    protected int getRootNodeId() {
        return (Integer)this.method("DOM.getDocument").param("depth", 0).send().getResult("root.nodeId");
    }

    @Override
    public String elementId(String locator) {
        return this.evalForObjectId(DriverOptions.selector(locator));
    }

    @Override
    public List elementIds(String locator) {
        List<Element> elements = this.locateAll(locator);
        ArrayList<String> objectIds = new ArrayList<String>(elements.size());
        for (Element e : elements) {
            String objectId = this.evalForObjectId(e.getLocator());
            objectIds.add(objectId);
        }
        return objectIds;
    }

    @Override
    public DriverOptions getOptions() {
        return this.options;
    }

    private void attachAndActivate(String targetId, boolean isFrame) {
        DevToolsMessage dtm = this.method("Target.attachToTarget").param("targetId", targetId).param("flatten", true).send();
        this.sessionId = (String)dtm.getResult("sessionId");
        this.frameSessions.put(targetId, this.sessionId);
        if (!isFrame) {
            this.mainFrameId = targetId;
        }
        this.method("Target.activateTarget").param("targetId", targetId).send();
        this.method("Target.setDiscoverTargets").param("discover", true).send();
    }

    @Override
    public void activate() {
        this.attachAndActivate(this.rootFrameId, false);
    }

    protected void initWindowIdAndState() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.rootFrameId).send();
        if (!dtm.isResultError()) {
            this.windowId = (Integer)dtm.getResultVariable("windowId").getValue();
            this.windowState = (String)((Map)dtm.getResultVariable("bounds").getValue()).get("windowState");
        }
    }

    @Override
    public Map<String, Object> getDimensions() {
        DevToolsMessage dtm = this.method("Browser.getWindowForTarget").param("targetId", this.rootFrameId).send();
        Map map = (Map)dtm.getResultVariable("bounds").getValue();
        Integer x = (Integer)map.remove("left");
        Integer y = (Integer)map.remove("top");
        map.put("x", x);
        map.put("y", y);
        return map;
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Integer left = (Integer)map.remove("x");
        Integer top = (Integer)map.remove("y");
        map.put("left", left);
        map.put("top", top);
        Map<String, Object> temp = this.getDimensions();
        temp.putAll(map);
        temp.remove("windowState");
        this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", temp).send();
    }

    public void emulateDevice(int width, int height, String userAgent) {
        this.method("Network.setUserAgentOverride").param("userAgent", userAgent).send();
        this.method("Emulation.setDeviceMetricsOverride").param("width", width).param("height", height).param("deviceScaleFactor", 1).param("mobile", true).send();
    }

    @Override
    public void close() {
        this.method("Page.close").sendWithoutWaiting();
        this.sessionId = this.frameSessions.get(this.rootFrameId);
    }

    @Override
    public void quit() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.method("Target.closeTarget").param("targetId", this.rootFrameId).sendWithoutWaiting();
        this.client.close();
        if (this.command != null) {
            this.command.close(true);
        }
        this.getRuntime().engine.setDriverToNull();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void setUrl(String url) {
        this.method("Page.navigate").param("url", url).send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void refresh() {
        this.method("Page.reload").send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void reload() {
        this.method("Page.reload").param("ignoreCache", true).send();
    }

    private void history(int delta) {
        DevToolsMessage dtm = this.method("Page.getNavigationHistory").send();
        int currentIndex = (Integer)dtm.getResultVariable("currentIndex").getValue();
        List list = (List)dtm.getResultVariable("entries").getValue();
        int targetIndex = currentIndex + delta;
        if (targetIndex < 0 || targetIndex == list.size()) {
            return;
        }
        Map entry = (Map)list.get(targetIndex);
        Integer id = (Integer)entry.get("id");
        this.method("Page.navigateToHistoryEntry").param("entryId", id).send(DevToolsWait.ALL_FRAMES_LOADED);
    }

    @Override
    public void back() {
        this.history(-1);
    }

    @Override
    public void forward() {
        this.history(1);
    }

    private void setWindowState(String state) {
        if (!"normal".equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", "normal")).send();
            this.windowState = "normal";
        }
        if (!state.equals(this.windowState)) {
            this.method("Browser.setWindowBounds").param("windowId", this.windowId).param("bounds", Collections.singletonMap("windowState", state)).send();
            this.windowState = state;
        }
    }

    @Override
    public void maximize() {
        this.setWindowState("maximized");
    }

    @Override
    public void minimize() {
        this.setWindowState("minimized");
    }

    @Override
    public void fullscreen() {
        this.setWindowState("fullscreen");
    }

    @Override
    public Element click(String locator) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".click()");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element select(String locator, String text) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, text));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element select(String locator, int index) {
        this.retryIfEnabled(locator);
        this.eval(this.options.optionSelector(locator, index));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Driver submit() {
        this.submit = true;
        return this;
    }

    @Override
    public Element focus(String locator) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public Element clear(String locator) {
        this.eval(DriverOptions.selector(locator) + ".value = ''");
        return DriverElement.locatorExists(this, locator);
    }

    private void sendKey(Character c, int modifiers, String type, Integer keyCode) {
        DevToolsMessage dtm = this.method("Input.dispatchKeyEvent").param("modifiers", modifiers).param("type", type);
        if (keyCode == null) {
            if (c != null) {
                dtm.param("text", c.toString());
            }
        } else {
            switch (keyCode) {
                case 9: {
                    if ("char".equals(type)) {
                        return;
                    }
                    dtm.param("text", "");
                    break;
                }
                case 13: {
                    dtm.param("text", "\r");
                    break;
                }
                case 46: {
                    if ("rawKeyDown".equals(type)) {
                        dtm.param("type", "keyDown");
                    }
                    dtm.param("text", ".");
                    break;
                }
                default: {
                    if (c == null) break;
                    dtm.param("text", c.toString());
                }
            }
            dtm.param("windowsVirtualKeyCode", keyCode);
        }
        dtm.send();
    }

    @Override
    public Element input(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(this.options.focusJs(locator));
        Input input = new Input(value);
        block3: while (input.hasNext()) {
            char c = input.next();
            int modifiers = input.getModifierFlags();
            Integer keyCode = Keys.code(c);
            if (keyCode != null) {
                switch (keyCode) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 91: {
                        if (input.release) {
                            this.sendKey(null, modifiers, "keyUp", keyCode);
                            continue block3;
                        }
                        this.sendKey(null, modifiers, "rawKeyDown", keyCode);
                        continue block3;
                    }
                }
                this.sendKey(Character.valueOf(c), modifiers, "rawKeyDown", keyCode);
                this.sendKey(Character.valueOf(c), modifiers, "char", keyCode);
                this.sendKey(Character.valueOf(c), modifiers, "keyUp", keyCode);
                continue;
            }
            this.logger.warn("unknown character / key code: {}", Character.valueOf(c));
            this.sendKey(Character.valueOf(c), modifiers, "char", null);
        }
        for (int keyCode : input.getKeyCodesToRelease()) {
            this.sendKey(null, 0, "keyUp", keyCode);
        }
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public void actions(List<Map<String, Object>> sequence) {
        boolean submitRequested = this.submit;
        this.submit = false;
        for (Map<String, Object> map : sequence) {
            List actions = (List)map.get("actions");
            if (actions == null) {
                this.logger.warn("no actions property found: {}", sequence);
                return;
            }
            Iterator iterator = actions.iterator();
            block11: while (iterator.hasNext()) {
                String chromeType;
                Map action = (Map)iterator.next();
                String type = (String)action.get("type");
                if (type == null) {
                    this.logger.warn("no type property found: {}", action);
                    continue;
                }
                switch (type) {
                    case "pointerMove": {
                        chromeType = "mouseMoved";
                        break;
                    }
                    case "pointerDown": {
                        chromeType = "mousePressed";
                        break;
                    }
                    case "pointerUp": {
                        chromeType = "mouseReleased";
                        break;
                    }
                    default: {
                        this.logger.warn("unexpected action type: {}", action);
                        continue block11;
                    }
                }
                Integer x = (Integer)action.get("x");
                Integer y = (Integer)action.get("y");
                if (x != null) {
                    this.currentMouseXpos = x;
                }
                if (y != null) {
                    this.currentMouseYpos = y;
                }
                Integer duration = (Integer)action.get("duration");
                DevToolsMessage toSend = this.method("Input.dispatchMouseEvent").param("type", chromeType).param("x", this.currentMouseXpos).param("y", this.currentMouseYpos);
                if ("mousePressed".equals(chromeType) || "mouseReleased".equals(chromeType)) {
                    toSend.param("button", "left").param("clickCount", 1);
                }
                if (!iterator.hasNext() && submitRequested) {
                    this.submit = true;
                }
                toSend.send();
                if (duration == null) continue;
                this.options.sleep(duration);
            }
        }
    }

    @Override
    public String text(String id) {
        return this.property(id, "textContent");
    }

    @Override
    public String html(String id) {
        return this.property(id, "outerHTML");
    }

    @Override
    public String value(String locator) {
        return this.property(locator, "value");
    }

    @Override
    public Element value(String locator, String value) {
        this.retryIfEnabled(locator);
        this.eval(DriverOptions.selector(locator) + ".value = '" + value + "'");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public String attribute(String id, String name) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + ".getAttribute('" + name + "')");
        return dtm.getResult().getAsString();
    }

    @Override
    public String property(String id, String name) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + "['" + name + "']");
        return dtm.getResult().getAsString();
    }

    @Override
    public boolean enabled(String id) {
        this.retryIfEnabled(id);
        DevToolsMessage dtm = this.eval(DriverOptions.selector(id) + ".disabled");
        return !dtm.getResult().isTrue();
    }

    @Override
    public boolean waitUntil(String expression) {
        return this.options.retry(() -> {
            try {
                return this.evalQuickly(expression).getResult().isTrue();
            }
            catch (Exception e) {
                this.logger.warn("waitUntil evaluate failed: {}", e.getMessage());
                return false;
            }
        }, b -> b, "waitUntil (js)", true);
    }

    @Override
    public Object script(String expression) {
        return this.eval(expression).getResult().getValue();
    }

    @Override
    public String getTitle() {
        return this.eval("document.title").getResult().getAsString();
    }

    @Override
    public String getUrl() {
        return this.eval("document.location.href").getResult().getAsString();
    }

    @Override
    public List<Map> getCookies() {
        DevToolsMessage dtm = this.method("Network.getAllCookies").send();
        return (List)dtm.getResultVariable("cookies").getValue();
    }

    @Override
    public Map<String, Object> cookie(String name) {
        List<Map> list = this.getCookies();
        if (list == null) {
            return null;
        }
        for (Map map : list) {
            if (map == null || !name.equals(map.get("name"))) continue;
            return map;
        }
        return null;
    }

    @Override
    public void cookie(Map<String, Object> cookie) {
        if (cookie.get("url") == null && cookie.get("domain") == null) {
            cookie = new HashMap<String, Object>(cookie);
            cookie.put("url", this.getUrl());
        }
        this.method("Network.setCookie").params(cookie).send();
    }

    @Override
    public void deleteCookie(String name) {
        this.method("Network.deleteCookies").param("name", name).param("url", this.getUrl()).send();
    }

    @Override
    public void clearCookies() {
        this.method("Network.clearBrowserCookies").send();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public void dialog(boolean accept, String text) {
        DevToolsMessage temp = this.method("Page.handleJavaScriptDialog").param("accept", accept);
        if (text == null) {
            temp.send();
        } else {
            temp.param("promptText", text).send();
        }
    }

    @Override
    public String getDialogText() {
        return this.currentDialogText;
    }

    @Override
    public byte[] pdf(Map<String, Object> options) {
        DevToolsMessage dtm = this.method("Page.printToPDF").params(options).send();
        String temp = dtm.getResultVariable("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public byte[] screenshot(boolean embed) {
        return this.screenshot(null, embed);
    }

    @Override
    public Map<String, Object> position(String locator) {
        return this.position(locator, false);
    }

    @Override
    public Map<String, Object> position(String locator, boolean relative) {
        boolean submitTemp = this.submit;
        this.submit = false;
        this.retryIfEnabled(locator);
        Map map = (Map)this.eval(relative ? DriverOptions.getRelativePositionJs(locator) : DriverOptions.getPositionJs(locator)).getResult().getValue();
        this.submit = submitTemp;
        return map;
    }

    @Override
    public byte[] screenshot(String id, boolean embed) {
        try {
            DevToolsMessage dtm;
            if (id == null) {
                dtm = this.method("Page.captureScreenshot").send();
            } else {
                Map<String, Object> map = this.position(id);
                map.put("scale", 1);
                dtm = this.method("Page.captureScreenshot").param("clip", map).send();
            }
            if (dtm == null) {
                this.logger.error("unable to capture screenshot - no data returned", new Object[0]);
                return Constants.ZERO_BYTES;
            }
            String temp = dtm.getResultVariable("data").getAsString();
            byte[] bytes = Base64.getDecoder().decode(temp);
            if (embed) {
                this.getRuntime().embed(bytes, ResourceType.PNG);
            }
            return bytes;
        }
        catch (Exception e) {
            this.logger.error("screenshot failed: {}", e.getMessage());
            return Constants.ZERO_BYTES;
        }
    }

    public byte[] screenshotFull() {
        DevToolsMessage layout = this.method("Page.getLayoutMetrics").send();
        Map size = (Map)layout.getResultVariable("contentSize").getValue();
        Map<String, Object> map = this.options.newMapWithSelectedKeys(size, "height", "width");
        map.put("x", 0);
        map.put("y", 0);
        map.put("scale", 1);
        DevToolsMessage dtm = this.method("Page.captureScreenshot").param("clip", map).send();
        if (dtm.isResultError()) {
            this.logger.error("unable to capture screenshot: {}", dtm);
            return new byte[0];
        }
        String temp = dtm.getResultVariable("data").getAsString();
        return Base64.getDecoder().decode(temp);
    }

    @Override
    public List<String> getPages() {
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        return (List)dtm.getResultVariable("targetInfos.targetId").getValue();
    }

    @Override
    public void switchPage(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        String targetId = this.options.retry(() -> {
            DevToolsMessage dtm = this.method("Target.getTargets").send();
            List targets = (List)dtm.getResultVariable("targetInfos").getValue();
            for (Map map : targets) {
                String title = (String)map.get("title");
                String url = (String)map.get("url");
                if ((title == null || !title.contains(titleOrUrl)) && (url == null || !url.contains(titleOrUrl))) continue;
                return (String)map.get("targetId");
            }
            return null;
        }, returned -> returned != null, "waiting to switch to tab: " + titleOrUrl, true);
        this.attachAndActivate(targetId, false);
    }

    @Override
    public void switchPage(int index) {
        if (index == -1) {
            return;
        }
        DevToolsMessage dtm = this.method("Target.getTargets").send();
        List targets = (List)dtm.getResultVariable("targetInfos").getValue();
        if (index < targets.size()) {
            Map target = (Map)targets.get(index);
            String targetId = (String)target.get("targetId");
            this.attachAndActivate(targetId, false);
        } else {
            this.logger.warn("failed to switch frame by index: {}", index);
        }
    }

    @Override
    public void switchFrame(int index) {
        if (index == -1) {
            this.frame = null;
            this.sessionId = this.frameSessions.get(this.mainFrameId);
            return;
        }
        List objectIds = this.elementIds("iframe,frame");
        if (index < objectIds.size()) {
            String objectId = (String)objectIds.get(index);
            if (!this.setExecutionContext(objectId)) {
                this.logger.warn("failed to switch frame by index: {}", index);
            }
        } else {
            this.logger.warn("unable to switch frame by index: {}", index);
        }
    }

    @Override
    public void switchFrame(String locator) {
        if (locator == null) {
            this.frame = null;
            this.sessionId = this.frameSessions.get(this.mainFrameId);
            return;
        }
        this.retryIfEnabled(locator);
        String objectId = this.evalForObjectId(DriverOptions.selector(locator));
        if (!this.setExecutionContext(objectId)) {
            this.logger.warn("failed to switch frame by locator: {}", locator);
        }
    }

    private Integer getFrameContext() {
        if (this.frame == null) {
            return null;
        }
        Integer result = this.frameContexts.get(this.frame.id);
        this.logger.trace("** get frame context: {} - {}", this.frame, result);
        return result;
    }

    private boolean setExecutionContext(String objectId) {
        String frameName;
        String frameUrl;
        DevToolsMessage dtm = this.method("DOM.describeNode").param("objectId", objectId).param("depth", 0).send();
        String frameId = (String)dtm.getResult("node.frameId");
        if (frameId == null) {
            return false;
        }
        dtm = this.method("Page.getFrameTree").send();
        this.frame = null;
        try {
            List childFrames = (List)dtm.getResult("frameTree.childFrames[*]");
            List<Map> flattenFrameTree = this.getFrameTree(childFrames);
            for (Map frameMap : flattenFrameTree) {
                String frameMapTemp = (String)frameMap.get("id");
                if (!frameId.equals(frameMapTemp)) continue;
                frameUrl = (String)frameMap.get("url");
                frameName = (String)frameMap.get("name");
                this.frame = new Frame(frameId, frameUrl, frameName);
                this.logger.trace("** switched to frame: {}", this.frame);
                break;
            }
        }
        catch (PathNotFoundException e) {
            this.logger.trace("** childFrames not found. Will try to change to a different Target in Chrome.", new Object[0]);
        }
        if (this.frame == null) {
            dtm = this.method("Target.getTargets").send();
            if (this.frameSessions.get(frameId) == null) {
                this.attachAndActivate(frameId, true);
            }
            List targetInfos = (List)dtm.getResult("targetInfos");
            for (Map targetInfo : targetInfos) {
                String temp = (String)targetInfo.get("targetId");
                String tempType = (String)targetInfo.get("type");
                if (!frameId.equals(temp) || !"iframe".equals(tempType) && !"frame".equals(tempType)) continue;
                frameUrl = (String)targetInfo.get("url");
                frameName = (String)targetInfo.get("title");
                this.frame = new Frame(frameId, frameUrl, frameName);
                this.logger.trace("** switched to frame: {}", this.frame);
            }
        }
        if (this.frame == null) {
            return false;
        }
        if (this.frameSessions.get(frameId) != null) {
            this.sessionId = this.frameSessions.get(frameId);
        } else {
            this.attachAndActivate(frameId, true);
            if (this.sessionId == null) {
                this.sessionId = this.frameSessions.get(this.mainFrameId);
            }
        }
        Integer contextId = this.getFrameContext();
        if (contextId != null) {
            return true;
        }
        dtm = this.method("Page.createIsolatedWorld").param("frameId", frameId).send();
        contextId = (Integer)dtm.getResult("executionContextId");
        this.frameContexts.put(frameId, contextId);
        return true;
    }

    private List<Map> getFrameTree(List<Map> frames) {
        ArrayList<Map> resultFrames = new ArrayList<Map>();
        for (Map frame : frames) {
            Map currFrame = (Map)frame.get("frame");
            List childFrames = (List)frame.get("childFrames");
            if (currFrame != null) {
                resultFrames.add((Map)frame.get("frame"));
            }
            if (childFrames == null) continue;
            resultFrames.addAll(this.getFrameTree(childFrames));
        }
        return resultFrames;
    }

    public void enableNetworkEvents() {
        this.method("Network.enable").send();
    }

    public void enablePageEvents() {
        this.method("Page.enable").send();
    }

    public void enableRuntimeEvents() {
        this.method("Runtime.enable").send();
    }

    public DevToolsMock intercept(Value value) {
        Map config = (Map)JsValue.toJava(value);
        config = (Map)new Variable(config).getValue();
        return this.intercept(config);
    }

    public DevToolsMock intercept(Map<String, Object> config) {
        List patterns = (List)config.get("patterns");
        if (patterns == null) {
            throw new RuntimeException("missing array argument 'patterns': " + config);
        }
        if (this.mockHandler != null) {
            throw new RuntimeException("'intercept()' can be called only once");
        }
        String mock = (String)config.get("mock");
        if (mock == null) {
            throw new RuntimeException("missing argument 'mock': " + config);
        }
        Object o = this.getRuntime().engine.fileReader.readFile(mock);
        if (!(o instanceof FeatureCall)) {
            throw new RuntimeException("'mock' is not a feature file: " + config + ", " + mock);
        }
        FeatureCall fc = (FeatureCall)o;
        this.mockHandler = new MockHandler(fc.feature);
        this.method("Fetch.enable").param("patterns", patterns).send();
        return new DevToolsMock(this.mockHandler);
    }

    public void inputFile(String locator, String ... relativePaths) {
        this.retryIfEnabled(locator);
        ArrayList<String> files = new ArrayList<String>(relativePaths.length);
        ScenarioEngine engine = ScenarioEngine.get();
        for (String p : relativePaths) {
            files.add(engine.fileReader.toAbsolutePath(p));
        }
        String objectId = this.evalForObjectId(DriverOptions.selector(locator));
        this.method("DOM.setFileInputFiles").param("files", files).param("objectId", objectId).send();
    }

    public Object scriptAwait(String expression) {
        DevToolsMessage toSend = this.method("Runtime.evaluate").param("expression", expression).param("returnByValue", true).param("awaitPromise", true);
        Integer contextId = this.getFrameContext();
        if (contextId != null) {
            toSend.param("contextId", contextId);
        }
        return toSend.send().getResult().getValue();
    }
}

