/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Input {
    protected boolean control;
    protected boolean alt;
    protected boolean shift;
    protected boolean meta;
    protected boolean release;
    private int pos = 0;
    public final char[] chars;

    public Input(String chars) {
        this.chars = chars.toCharArray();
    }

    public boolean hasNext() {
        return this.pos < this.chars.length;
    }

    public List<Integer> getKeyCodesToRelease() {
        if (this.control || this.alt || this.shift || this.meta) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (this.shift) {
                list.add(16);
            }
            if (this.control) {
                list.add(17);
            }
            if (this.alt) {
                list.add(18);
            }
            if (this.meta) {
                list.add(91);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private void updateModifiers(char c) {
        switch (c) {
            case '\ue009': {
                this.release = this.control;
                this.control = !this.control;
                break;
            }
            case '\ue00a': {
                this.release = this.alt;
                this.alt = !this.alt;
                break;
            }
            case '\ue008': {
                this.release = this.shift;
                this.shift = !this.shift;
                break;
            }
            case '\ue03d': {
                this.release = this.meta;
                this.meta = !this.meta;
                break;
            }
        }
    }

    public char next() {
        char c = this.chars[this.pos++];
        this.updateModifiers(c);
        return c;
    }

    public int getModifierFlags() {
        int modifier = 0;
        if (this.control) {
            modifier += 2;
        }
        if (this.alt) {
            ++modifier;
        }
        if (this.shift) {
            modifier += 8;
        }
        if (this.meta) {
            modifier += 4;
        }
        return modifier;
    }
}

