/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.report;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportUtils {
    private static final String[] STATIC_RESOURCES = new String[]{"favicon.ico", "karate-logo.png", "karate-logo.svg", "karate-labs-logo-ring.svg", "com/intuit/karate/report/bootstrap.min.css", "com/intuit/karate/report/bootstrap.min.js", "com/intuit/karate/report/jquery.min.js", "com/intuit/karate/report/jquery.tablesorter.min.js", "com/intuit/karate/report/jquery-ui.min.js", "com/intuit/karate/report/vis.min.css", "com/intuit/karate/report/vis.min.js", "com/intuit/karate/report/karate-report.css", "com/intuit/karate/report/karate-report.js", "com/intuit/karate/report/Resemble.js"};
    private static final double MILLION = 1000000.0;
    private static final double BILLION = 1.0E9;

    private ReportUtils() {
    }

    public static Map<String, Object> commonVars() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userUuid", FileUtils.USER_UUID);
        map.put("karateVersion", FileUtils.KARATE_VERSION);
        map.put("karateMeta", FileUtils.KARATE_META);
        map.put("karateTelemetry", FileUtils.KARATE_TELEMETRY);
        return map;
    }

    public static String getDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
        return sdf.format(new Date());
    }

    private static void copyToFile(String classPath, String destPath) {
        InputStream is = ResourceUtils.classPathResourceToStream(classPath);
        byte[] bytes = FileUtils.toBytes(is);
        FileUtils.writeToFile(new File(destPath), bytes);
    }

    public static void initStaticResources(String targetDir) {
        String resPath = targetDir + File.separator + "res" + File.separator;
        File resFile = new File(resPath);
        if (resFile.exists()) {
            return;
        }
        for (String path : STATIC_RESOURCES) {
            int pos = path.lastIndexOf(47);
            if (pos == -1) {
                ReportUtils.copyToFile(path, resFile.getParent() + File.separator + path);
                continue;
            }
            ReportUtils.copyToFile(path, resPath + path.substring(pos + 1));
        }
    }

    public static double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static double nanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static File saveKarateJson(String targetDir, FeatureResult result, String fileName) {
        if (fileName == null) {
            fileName = result.getFeature().getKarateJsonFileName();
        }
        File file = new File(targetDir + File.separator + fileName);
        FileUtils.writeToFile(file, JsonUtils.toJson(result.toKarateJson()));
        return file;
    }

    public static File saveCucumberJson(String targetDir, FeatureResult result, String fileName) {
        if (fileName == null) {
            fileName = result.getFeature().getPackageQualifiedName() + ".json";
        }
        File file = new File(targetDir + File.separator + (String)fileName);
        String json = JsonUtils.toJson(Collections.singletonList(result.toCucumberJson()));
        FileUtils.writeToFile(file, json);
        return file;
    }

    private static Throwable appendSteps(List<StepResult> steps, StringBuilder sb) {
        Throwable error = null;
        for (StepResult sr : steps) {
            int length = sb.length();
            sb.append(sr.getStep().getPrefix());
            sb.append(' ');
            sb.append(sr.getStep().getText());
            sb.append(' ');
            do {
                sb.append('.');
            } while (sb.length() - length < 75);
            sb.append(' ');
            sb.append(sr.getResult().getStatus());
            sb.append('\n');
            if (!sr.getResult().isFailed()) continue;
            sb.append("\nStack Trace:\n");
            error = sr.getResult().getError();
            sb.append(StringUtils.throwableToString(error));
            sb.append('\n');
        }
        return error;
    }

    private static Element addCustomTags(Element testCase, Document doc, ScenarioResult sr) {
        List<String> tags;
        Element properties = null;
        if (sr.getScenario() != null && (tags = sr.getScenario().getTagsEffective().getTags()).size() > 0) {
            properties = doc.createElement("properties");
            for (String tag : tags) {
                String[] innerTags = tag.split("=");
                int size = innerTags.length;
                Element requirement = doc.createElement("property");
                if (size <= 1) continue;
                requirement.setAttribute("name", innerTags[0]);
                requirement.setAttribute("value", innerTags[1]);
                properties.appendChild(requirement);
            }
        }
        return properties;
    }

    public static File saveJunitXml(String targetDir, FeatureResult result, String fileName) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.######");
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement("testsuite");
        doc.appendChild(root);
        root.setAttribute("tests", "" + result.getRunCount());
        root.setAttribute("failures", "" + result.getFailedCount());
        root.setAttribute("time", formatter.format(result.getDurationMillis() / 1000.0));
        root.setAttribute("name", result.getDisplayName());
        root.setAttribute("skipped", "0");
        StringBuilder xmlString = new StringBuilder();
        xmlString.append(XmlUtils.toString(doc, false).replace("/>", ">"));
        String baseName = result.getFeature().getPackageQualifiedName();
        for (ScenarioResult sr : result.getScenarioResults()) {
            Element stepsHolder;
            Element testCase = doc.createElement("testcase");
            testCase.setAttribute("classname", baseName);
            StringBuilder sb = new StringBuilder();
            Throwable error = ReportUtils.appendSteps(sr.getStepResults(), sb);
            String name = sr.getScenario().getName();
            if (StringUtils.isBlank(name)) {
                name = sr.getScenario().getUniqueId();
            }
            testCase.setAttribute("name", name);
            testCase.setAttribute("time", formatter.format(sr.getDurationMillis() / 1000.0));
            if (error != null) {
                stepsHolder = doc.createElement("failure");
                stepsHolder.setAttribute("message", error.getMessage());
            } else {
                stepsHolder = doc.createElement("system-out");
            }
            Element properties = null;
            properties = ReportUtils.addCustomTags(testCase, doc, sr);
            if (properties != null && properties.getChildNodes().getLength() > 0) {
                testCase.appendChild(properties);
            }
            testCase.appendChild(stepsHolder);
            stepsHolder.setTextContent(sb.toString());
            xmlString.append(XmlUtils.toString(testCase)).append('\n');
        }
        xmlString.append("</testsuite>");
        if (fileName == null) {
            fileName = baseName + ".xml";
        }
        File file = new File(targetDir + File.separator + (String)fileName);
        FileUtils.writeToFile(file, xmlString.toString());
        return file;
    }
}

