/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.report;

import com.intuit.karate.Results;
import com.intuit.karate.Suite;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.TagResults;
import com.intuit.karate.core.TimelineResults;
import com.intuit.karate.report.Report;
import com.intuit.karate.report.ReportUtils;
import java.util.Map;

public interface SuiteReports {
    public static final SuiteReports DEFAULT = new SuiteReports(){};

    default public Report featureReport(Suite suite, FeatureResult featureResult) {
        Map<String, Object> map = featureResult.toKarateJson();
        map.put("env", suite.env);
        return Report.template("karate-feature.html").reportDir(suite.reportDir).reportFileName(featureResult.getFeature().getPackageQualifiedName() + ".html").variable("results", map).variables(ReportUtils.commonVars()).build();
    }

    default public Report tagsReport(Suite suite, TagResults tagResults) {
        Map<String, Object> map = tagResults.toKarateJson();
        map.put("env", suite.env);
        return Report.template("karate-tags.html").reportDir(suite.reportDir).variable("results", map).build();
    }

    default public Report timelineReport(Suite suite, TimelineResults timelineResults) {
        return Report.template("karate-timeline.html").reportDir(suite.reportDir).variable("results", timelineResults.toKarateJson()).build();
    }

    default public Report summaryReport(Suite suite, Results results) {
        Map<String, Object> map = results.toKarateJson();
        map.put("env", suite.env);
        return Report.template("karate-summary.html").reportDir(suite.reportDir).variable("results", map).variables(ReportUtils.commonVars()).build();
    }
}

