/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.FileUtils;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;

public class ResourceResolver {
    public final boolean classpath;
    public final String root;
    private static final String EMPTY = "";
    private static final String SLASH = "/";

    public ResourceResolver(String root) {
        if (root == null) {
            root = EMPTY;
        }
        this.classpath = ((String)root).startsWith("classpath:");
        if (!((String)(root = ResourceUtils.removePrefix((String)root))).isEmpty() && !((String)root).endsWith(SLASH)) {
            root = (String)root + SLASH;
        }
        this.root = root;
    }

    public Resource resolve(String path) {
        return this.resolve(null, path);
    }

    public Resource resolve(String caller, String path) {
        Object prefix;
        if (path.startsWith("classpath:")) {
            return this.get(path);
        }
        Object object = prefix = this.classpath ? "classpath:" + this.root : this.root;
        if (path.startsWith("this:") && caller != null) {
            return this.get((String)prefix + ResourceUtils.getParentPath(caller) + path.substring(5));
        }
        return this.get((String)prefix + (path.charAt(0) == '/' ? path.substring(1) : path));
    }

    private Resource get(String path) {
        return ResourceUtils.getResource(FileUtils.WORKING_DIR, path);
    }

    public String toString() {
        return this.classpath ? "classpath:" + this.root : this.root;
    }
}

