/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Main;
import com.intuit.karate.PerfHook;
import com.intuit.karate.Results;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.StringUtils;
import com.intuit.karate.Suite;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.RuntimeHookFactory;
import com.intuit.karate.core.ScenarioCall;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.DriverRunner;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.report.SuiteReports;
import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Runner.class);

    public static Map<String, Object> runFeature(FeatureCall feature, Map<String, Object> vars, boolean evalKarateConfig) {
        Suite suite = new Suite();
        FeatureRuntime featureRuntime = FeatureRuntime.of(suite, feature, vars);
        featureRuntime.caller.setKarateConfigDisabled(!evalKarateConfig);
        featureRuntime.run();
        FeatureResult result = featureRuntime.result;
        if (result.isFailed()) {
            throw result.getErrorMessagesCombined();
        }
        return result.getVariables();
    }

    public static Map<String, Object> runFeature(File file, Map<String, Object> vars, boolean evalKarateConfig) {
        Feature feature = Feature.read(file);
        return Runner.runFeature(new FeatureCall(feature), vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(Class relativeTo, String path, Map<String, Object> vars, boolean evalKarateConfig) {
        File file = ResourceUtils.getFileRelativeTo(relativeTo, path);
        return Runner.runFeature(file, vars, evalKarateConfig);
    }

    public static Map<String, Object> runFeature(String path, Map<String, Object> vars, boolean evalKarateConfig) {
        FeatureCall feature = FileUtils.parseFeatureAndCallTag(path);
        return Runner.runFeature(feature, vars, evalKarateConfig);
    }

    public static void callAsync(Builder builder, String path, Map<String, Object> arg, PerfHook perfHook) {
        builder.features = Collections.emptyList();
        Suite suite = new Suite(builder);
        FeatureCall feature = FileUtils.parseFeatureAndCallTag(path);
        FeatureRuntime featureRuntime = FeatureRuntime.of(suite, feature, arg, perfHook);
        featureRuntime.setNext(() -> perfHook.afterFeature(featureRuntime.result));
        perfHook.submit(featureRuntime);
    }

    public static Builder path(String ... paths) {
        Builder builder = new Builder();
        return builder.path(paths);
    }

    public static Builder path(List<String> paths) {
        Builder builder = new Builder();
        return builder.path(paths);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder> {
        ClassLoader classLoader;
        Class optionsClass;
        String env;
        File workingDir;
        String buildDir;
        String configDir;
        int threadCount;
        int timeoutMinutes;
        String reportDir;
        String scenarioName;
        List<String> tags;
        List<String> paths;
        List<FeatureCall> features;
        String relativeTo;
        final Collection<RuntimeHook> hooks = new ArrayList<RuntimeHook>();
        RuntimeHookFactory hookFactory;
        HttpClientFactory clientFactory;
        boolean forTempUse;
        boolean backupReportDir = true;
        boolean outputHtmlReport = true;
        boolean outputJunitXml;
        boolean outputCucumberJson;
        boolean dryRun;
        boolean debugMode;
        boolean failWhenNoScenariosFound;
        Map<String, String> systemProperties;
        Map<String, Object> callSingleCache;
        Map<String, ScenarioCall.Result> callOnceCache;
        SuiteReports suiteReports;
        Map<String, DriverRunner> drivers;

        public synchronized Builder copy() {
            Builder<T> b = new Builder<T>();
            b.classLoader = this.classLoader;
            b.optionsClass = this.optionsClass;
            b.env = this.env;
            b.workingDir = this.workingDir;
            b.buildDir = this.buildDir;
            b.configDir = this.configDir;
            b.threadCount = this.threadCount;
            b.timeoutMinutes = this.timeoutMinutes;
            b.reportDir = this.reportDir;
            b.scenarioName = this.scenarioName;
            b.tags = this.tags;
            b.paths = this.paths;
            b.features = this.features;
            b.relativeTo = this.relativeTo;
            b.hooks.addAll(this.hooks);
            b.hookFactory = this.hookFactory;
            b.clientFactory = this.clientFactory;
            b.forTempUse = this.forTempUse;
            b.backupReportDir = this.backupReportDir;
            b.outputHtmlReport = this.outputHtmlReport;
            b.outputJunitXml = this.outputJunitXml;
            b.outputCucumberJson = this.outputCucumberJson;
            b.dryRun = this.dryRun;
            b.debugMode = this.debugMode;
            b.failWhenNoScenariosFound = this.failWhenNoScenariosFound;
            b.systemProperties = this.systemProperties;
            b.callSingleCache = this.callSingleCache;
            b.callOnceCache = this.callOnceCache;
            b.suiteReports = this.suiteReports;
            b.drivers = this.drivers;
            return b;
        }

        public List<FeatureCall> resolveAll() {
            String tempEnv;
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (this.clientFactory == null) {
                this.clientFactory = HttpClientFactory.DEFAULT;
            }
            if (this.systemProperties == null) {
                this.systemProperties = new HashMap<Object, Object>(System.getProperties());
            } else {
                this.systemProperties.putAll(new HashMap<Object, Object>(System.getProperties()));
            }
            String tempOptions = StringUtils.trimToNull(this.systemProperties.get("karate.options"));
            if (tempOptions != null) {
                LOGGER.info("using system property '{}': {}", (Object)"karate.options", (Object)tempOptions);
                Main ko = Main.parseKarateOptions(tempOptions);
                if (ko.tags != null) {
                    this.tags = ko.tags;
                }
                if (ko.paths != null) {
                    this.paths = ko.paths;
                }
                if (ko.threads != 0) {
                    this.threadCount = ko.threads;
                }
                boolean bl = this.dryRun = ko.dryRun || this.dryRun;
            }
            if ((tempEnv = StringUtils.trimToNull(this.systemProperties.get("karate.env"))) != null) {
                LOGGER.info("using system property '{}': {}", (Object)"karate.env", (Object)tempEnv);
                this.env = tempEnv;
            } else if (this.env != null) {
                LOGGER.info("karate.env is: '{}'", (Object)this.env);
            }
            String tempConfig = StringUtils.trimToNull(this.systemProperties.get("karate.config.dir"));
            if (tempConfig != null) {
                LOGGER.info("using system property '{}': {}", (Object)"karate.config.dir", (Object)tempConfig);
                this.configDir = tempConfig;
            }
            if (this.workingDir == null) {
                this.workingDir = FileUtils.WORKING_DIR;
            }
            if (this.configDir == null) {
                try {
                    ResourceUtils.getResource(this.workingDir, "classpath:karate-config.js");
                    this.configDir = "classpath:";
                }
                catch (Exception e) {
                    this.configDir = this.workingDir.getPath();
                }
            }
            if (!this.configDir.startsWith("file:") && !this.configDir.startsWith("classpath:")) {
                this.configDir = "file:" + this.configDir;
            }
            if (!(this.configDir.endsWith(":") || this.configDir.endsWith("/") || this.configDir.endsWith("\\"))) {
                this.configDir = this.configDir + File.separator;
            }
            if (this.buildDir == null) {
                this.buildDir = FileUtils.getBuildDir();
            }
            if (this.reportDir == null) {
                this.reportDir = this.buildDir + File.separator + "karate-reports";
            }
            if (this.hookFactory != null) {
                this.hook(this.hookFactory.create());
            }
            if (this.features == null) {
                if (this.paths != null && !this.paths.isEmpty()) {
                    if (this.relativeTo != null) {
                        this.paths = this.paths.stream().map(p -> {
                            if (((String)p).startsWith("classpath:")) {
                                return p;
                            }
                            if (!((String)p).endsWith(".feature")) {
                                p = (String)p + ".feature";
                            }
                            return this.relativeTo + "/" + (String)p;
                        }).collect(Collectors.toList());
                    }
                } else if (this.relativeTo != null) {
                    this.paths = new ArrayList<String>();
                    this.paths.add(this.relativeTo);
                }
                this.features = ResourceUtils.findFeatureFiles(this.workingDir, this.paths, this.scenarioName);
            }
            if (this.callSingleCache == null) {
                this.callSingleCache = new HashMap<String, Object>();
            }
            if (this.callOnceCache == null) {
                this.callOnceCache = new HashMap<String, ScenarioCall.Result>();
            }
            if (this.suiteReports == null) {
                this.suiteReports = SuiteReports.DEFAULT;
            }
            if (this.drivers != null) {
                Map<String, DriverRunner> customDrivers = this.drivers;
                this.drivers = DriverOptions.driverRunners();
                this.drivers.putAll(customDrivers);
            } else {
                this.drivers = DriverOptions.driverRunners();
            }
            if (this.threadCount < 1) {
                this.threadCount = 1;
            }
            return this.features;
        }

        public T forTempUse() {
            this.forTempUse = true;
            return (T)this;
        }

        public T configDir(String dir) {
            this.configDir = dir;
            return (T)this;
        }

        public T karateEnv(String env) {
            this.env = env;
            return (T)this;
        }

        public T systemProperty(String key, String value) {
            if (this.systemProperties == null) {
                this.systemProperties = new HashMap<String, String>();
            }
            this.systemProperties.put(key, value);
            return (T)this;
        }

        public T workingDir(File value) {
            if (value != null) {
                this.workingDir = value;
            }
            return (T)this;
        }

        public T buildDir(String value) {
            if (value != null) {
                this.buildDir = value;
            }
            return (T)this;
        }

        public T classLoader(ClassLoader value) {
            this.classLoader = value;
            return (T)this;
        }

        public T relativeTo(Class clazz) {
            this.relativeTo = "classpath:" + ResourceUtils.toPathFromClassPathRoot(clazz);
            return (T)this;
        }

        public T path(String ... value) {
            this.path(Arrays.asList(value));
            return (T)this;
        }

        public T path(List<String> value) {
            if (value != null) {
                if (this.paths == null) {
                    this.paths = new ArrayList<String>();
                }
                this.paths.addAll(value);
            }
            return (T)this;
        }

        public T tags(List<String> value) {
            if (value != null) {
                if (this.tags == null) {
                    this.tags = new ArrayList<String>();
                }
                this.tags.addAll(value);
            }
            return (T)this;
        }

        public T tags(String ... tags) {
            this.tags(Arrays.asList(tags));
            return (T)this;
        }

        public T features(Collection<Feature> value) {
            if (value != null) {
                if (this.features == null) {
                    this.features = new ArrayList<FeatureCall>();
                }
                this.features.addAll(value.stream().map(FeatureCall::new).collect(Collectors.toList()));
            }
            return (T)this;
        }

        public T features(Feature ... value) {
            return this.features(Arrays.asList(value));
        }

        public T reportDir(String value) {
            if (value != null) {
                this.reportDir = value;
            }
            return (T)this;
        }

        public T scenarioName(String name) {
            this.scenarioName = name;
            return (T)this;
        }

        public T timeoutMinutes(int timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return (T)this;
        }

        public T hook(RuntimeHook hook) {
            if (hook != null) {
                this.hooks.add(hook);
            }
            return (T)this;
        }

        public T hooks(Collection<RuntimeHook> hooks) {
            if (hooks != null) {
                this.hooks.addAll(hooks);
            }
            return (T)this;
        }

        public T hookFactory(RuntimeHookFactory hookFactory) {
            this.hookFactory = hookFactory;
            return (T)this;
        }

        public T clientFactory(HttpClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return (T)this;
        }

        public Builder threads(int value) {
            this.threadCount = value;
            return this;
        }

        public T outputHtmlReport(boolean value) {
            this.outputHtmlReport = value;
            return (T)this;
        }

        public T backupReportDir(boolean value) {
            this.backupReportDir = value;
            return (T)this;
        }

        public T outputCucumberJson(boolean value) {
            this.outputCucumberJson = value;
            return (T)this;
        }

        public T outputJunitXml(boolean value) {
            this.outputJunitXml = value;
            return (T)this;
        }

        public T dryRun(boolean value) {
            this.dryRun = value;
            return (T)this;
        }

        public T debugMode(boolean value) {
            this.debugMode = value;
            return (T)this;
        }

        public T failWhenNoScenariosFound(boolean value) {
            this.failWhenNoScenariosFound = value;
            return (T)this;
        }

        public T callSingleCache(Map<String, Object> value) {
            this.callSingleCache = value;
            return (T)this;
        }

        public T callOnceCache(Map<String, ScenarioCall.Result> value) {
            this.callOnceCache = value;
            return (T)this;
        }

        public T suiteReports(SuiteReports value) {
            this.suiteReports = value;
            return (T)this;
        }

        public T customDrivers(Map<String, DriverRunner> customDrivers) {
            this.drivers = customDrivers;
            return (T)this;
        }

        private Integer getDebugPort() {
            String debugPortString = StringUtils.trimToNull(System.getProperty("karate.debug.port"));
            if (debugPortString == null) {
                return null;
            }
            int debugPort = 0;
            try {
                debugPort = Integer.valueOf(debugPortString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return debugPort;
        }

        private String[] getDebugArgs(int debugPort) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add("-d");
            args.add("" + debugPort);
            if (this.env != null) {
                args.add("-e");
                args.add(this.env);
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    args.add("-t");
                    args.add(tag);
                }
            }
            if (this.threadCount != 1) {
                args.add("-T");
                args.add("" + this.threadCount);
            }
            if (this.paths != null) {
                args.addAll(this.paths);
            }
            return args.toArray(new String[0]);
        }

        public Results parallel(int threadCount) {
            this.threads(threadCount);
            Integer debugPort = this.getDebugPort();
            if (debugPort != null && !this.debugMode) {
                String[] args = this.getDebugArgs(debugPort);
                if (this.systemProperties != null) {
                    this.systemProperties.forEach((k, v) -> System.setProperty(k, v));
                }
                return Main.startDebugServer(args);
            }
            Suite suite = new Suite(this);
            suite.run();
            return suite.buildResults();
        }

        public String toString() {
            return "" + this.paths;
        }
    }
}

