/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.ExamplesTable;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import com.intuit.karate.core.Tag;
import com.intuit.karate.core.Tags;
import java.util.ArrayList;
import java.util.List;

public class ScenarioOutline {
    private final Feature feature;
    private final FeatureSection section;
    private int line;
    private List<Tag> tags;
    private String name;
    private String description;
    private List<Step> steps;
    private List<ExamplesTable> examplesTables;

    public ScenarioOutline(Feature feature, FeatureSection section) {
        this.feature = feature;
        this.section = section;
    }

    public Scenario toScenario(String dynamicExpression, int exampleIndex, int updateLine, List<Tag> tagsForExamples) {
        ArrayList<Step> temp;
        Scenario s = new Scenario(this.feature, this.section, exampleIndex);
        s.setName(this.name);
        s.setDescription(this.description);
        s.setLine(updateLine);
        s.setDynamicExpression(dynamicExpression);
        if (this.tags != null || tagsForExamples != null) {
            temp = new ArrayList<Step>();
            if (this.tags != null) {
                temp.addAll(this.tags);
            }
            if (tagsForExamples != null) {
                temp.addAll(tagsForExamples);
            }
            s.setTags(temp);
        }
        temp = new ArrayList(this.steps.size());
        s.setSteps(temp);
        for (Step original : this.steps) {
            Step step = new Step(s, original.getIndex());
            temp.add(step);
            step.setLine(original.getLine());
            step.setEndLine(original.getEndLine());
            step.setPrefix(original.getPrefix());
            step.setText(original.getText());
            step.setDocString(original.getDocString());
            step.setTable(original.getTable());
            step.setComments(original.getComments());
        }
        return s;
    }

    public List<Scenario> getScenarios() {
        return this.getScenarios(null);
    }

    public List<Scenario> getScenarios(FeatureRuntime fr) {
        ArrayList<Scenario> list = new ArrayList<Scenario>();
        boolean examplesHaveTags = this.examplesTables.stream().anyMatch(t -> !t.getTags().isEmpty());
        for (ExamplesTable examples : this.examplesTables) {
            boolean selectedForExecution = false;
            if (fr != null && examplesHaveTags && fr.caller.isNone()) {
                Tags tableTags = Tags.merge(fr.featureCall.feature.getTags(), this.tags, examples.getTags());
                boolean executeForTable = tableTags.evaluate(fr.suite.tagSelector, fr.suite.env);
                if (executeForTable) {
                    selectedForExecution = true;
                }
            } else {
                selectedForExecution = true;
            }
            if (!selectedForExecution) continue;
            Table table = examples.getTable();
            if (table.isDynamic()) {
                Scenario scenario = this.toScenario(table.getDynamicExpression(), -1, table.getLineNumberForRow(0), examples.getTags());
                list.add(scenario);
                continue;
            }
            int rowCount = table.getRows().size();
            for (int i = 1; i < rowCount; ++i) {
                int exampleIndex = i - 1;
                Scenario scenario = this.toScenario(null, exampleIndex, table.getLineNumberForRow(i), examples.getTags());
                scenario.setExampleData(table.getExampleData(exampleIndex));
                list.add(scenario);
                for (String key : table.getKeys()) {
                    scenario.replace("<" + key + ">", table.getValueAsString(key, i));
                }
            }
        }
        return list;
    }

    public FeatureSection getSection() {
        return this.section;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public List<ExamplesTable> getExamplesTables() {
        return this.examplesTables;
    }

    public void setExamplesTables(List<ExamplesTable> examplesTables) {
        this.examplesTables = examplesTables;
    }
}

