/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Tag;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.Value;

public class Tags
implements Iterable<Tag> {
    public static final Tags EMPTY = new Tags(Collections.EMPTY_LIST);
    private final Collection<Tag> original;
    private final List<String> tags;
    private Map<String, List<String>> tagValues;

    @Override
    public Iterator<Tag> iterator() {
        return this.original.iterator();
    }

    public static Tags merge(List<Tag> ... lists) {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (List<Tag> list : lists) {
            if (list == null) continue;
            tags.addAll(list);
        }
        return new Tags(tags);
    }

    public Tags(Collection<Tag> in) {
        if (in == null) {
            this.original = Collections.EMPTY_LIST;
            this.tags = Collections.EMPTY_LIST;
        } else {
            this.original = in;
            this.tags = new ArrayList<String>(in.size());
            this.tagValues = new HashMap<String, List<String>>(in.size());
            for (Tag tag : in) {
                this.tags.add(tag.getText());
                this.tagValues.put(tag.getName(), tag.getValues());
            }
        }
    }

    public boolean evaluate(String tagSelector, String karateEnv) {
        if (StringUtils.containsIgnoreCase(this.tags, "ignore")) {
            return false;
        }
        if (this.tagValues.containsKey("setup")) {
            return false;
        }
        Values envValues = this.valuesFor("env");
        if (envValues.isPresent) {
            if (karateEnv == null) {
                return false;
            }
            if (!envValues.isAnyOf(karateEnv)) {
                return false;
            }
        }
        if (karateEnv != null && this.valuesFor("envnot").isAnyOf(karateEnv)) {
            return false;
        }
        if (tagSelector == null) {
            return true;
        }
        JsEngine je = JsEngine.global();
        je.put("anyOf", this::anyOf);
        je.put("allOf", this::allOf);
        je.put("not", this::not);
        je.put("valuesFor", this::valuesFor);
        JsValue jv = je.eval(tagSelector);
        return jv.isTrue();
    }

    public boolean anyOf(Object ... values) {
        for (String s : Tags.removeTagPrefixes(values)) {
            if (!this.tags.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean allOf(Object ... values) {
        return this.tags.containsAll(Tags.removeTagPrefixes(values));
    }

    public boolean not(Object ... values) {
        return !this.anyOf(values);
    }

    public Values valuesFor(String name) {
        List<String> list = this.tagValues.get(Tags.removeTagPrefix(name));
        return new Values(list);
    }

    public boolean contains(String tagText) {
        return this.tags.contains(Tags.removeTagPrefix(tagText));
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Collection<String> getTagKeys() {
        return this.tagValues.keySet();
    }

    public Map<String, List<String>> getTagValues() {
        return this.tagValues;
    }

    public Collection<Tag> getOriginal() {
        return this.original;
    }

    private static String removeTagPrefix(String s) {
        if (s.charAt(0) == '@') {
            return s.substring(1);
        }
        return s;
    }

    private static Collection<String> removeTagPrefixes(Object ... values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (Object o : values) {
            list.add(Tags.removeTagPrefix(o.toString()));
        }
        return list;
    }

    public static String fromKarateOptionsTags(List<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        return Tags.fromKarateOptionsTags(tags.toArray(new String[0]));
    }

    public static String fromKarateOptionsTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return null;
        }
        for (String s : tags) {
            if (s.indexOf(40) == -1) continue;
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.length; ++i) {
            String and = StringUtils.trimToEmpty(tags[i]);
            if (and.startsWith("~")) {
                sb.append("not('").append(and.substring(1)).append("')");
            } else {
                sb.append("anyOf(");
                List<String> or = StringUtils.split(and, ',', false);
                for (String tag : or) {
                    sb.append('\'').append(tag.trim()).append('\'').append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append(')');
            }
            if (i >= tags.length - 1) continue;
            sb.append(" && ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.tags.toString();
    }

    public static class Values {
        public final List<String> values;
        public final boolean isPresent;

        public Values(List<String> values) {
            this.values = values == null ? Collections.EMPTY_LIST : values;
            this.isPresent = !this.values.isEmpty();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public boolean isAnyOf(Object ... args) {
            for (Object o : args) {
                if (!this.values.contains(o.toString())) continue;
                return true;
            }
            return false;
        }

        public boolean isAllOf(Object ... args) {
            ArrayList<String> list = new ArrayList<String>(args.length);
            for (Object o : args) {
                list.add(o.toString());
            }
            return this.values.containsAll(list);
        }

        public boolean isOnly(Object ... args) {
            return this.isAllOf(args) && args.length == this.values.size();
        }

        public boolean isEach(Value v) {
            if (!v.canExecute()) {
                return false;
            }
            for (String s : this.values) {
                JsValue jv = new JsValue(JsEngine.execute(v, s));
                if (jv.isTrue()) continue;
                return false;
            }
            return true;
        }
    }
}

