/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.microsoft;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.http.Response;
import com.intuit.karate.shell.Command;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdgeChromium
extends DevToolsDriver {
    public static final String DRIVER_TYPE = "msedge";
    public static final String DEFAULT_PATH_MAC = "/Applications/Microsoft Edge.app/Contents/MacOS/Microsoft Edge";
    public static final String DEFAULT_PATH_WIN32 = "C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\msedge.exe";
    public static final String DEFAULT_PATH_WIN64 = "C:\\Program Files\\Microsoft\\Edge\\Application\\msedge.exe";
    public static final String DEFAULT_PATH_WIN = Files.isRegularFile(Paths.get("C:\\Program Files\\Microsoft\\Edge\\Application\\msedge.exe", new String[0]), new LinkOption[0]) && Files.isReadable(Paths.get("C:\\Program Files\\Microsoft\\Edge\\Application\\msedge.exe", new String[0])) ? "C:\\Program Files\\Microsoft\\Edge\\Application\\msedge.exe" : "C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\msedge.exe";
    public static final String DEFAULT_PATH_LINUX = "/dev/null";

    public EdgeChromium(DriverOptions options, Command command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static EdgeChromium start(Map<String, Object> map, ScenarioRuntime sr) {
        if (!FileUtils.isOsWindows() && !FileUtils.isOsMacOsX()) {
            throw new UnsupportedOperationException("edge browser is not yet available on linux!");
        }
        DriverOptions options = new DriverOptions(map, sr, 9222, FileUtils.isOsWindows() ? DEFAULT_PATH_WIN : (FileUtils.isOsMacOsX() ? DEFAULT_PATH_MAC : DEFAULT_PATH_LINUX));
        options.arg("--remote-debugging-port=" + options.port);
        options.arg("--no-first-run");
        if (options.userDataDir != null) {
            options.arg("--user-data-dir=" + options.userDataDir);
        }
        options.arg("--disable-popup-blocking");
        if (options.headless) {
            options.arg("--headless");
        }
        Command command = options.startProcess();
        Http http = options.getHttp();
        Command.waitForHttp(http.urlBase);
        Response res = http.path("json").get();
        if (res.json().asList().isEmpty()) {
            if (command != null) {
                command.close(true);
            }
            throw new RuntimeException("edge server returned empty list from " + http.urlBase);
        }
        String webSocketUrl = null;
        List targets = res.json().asList();
        for (Map target : targets) {
            String targetType;
            String targetUrl = (String)target.get("url");
            if (targetUrl == null || targetUrl.startsWith("edge-") || !"page".equals(targetType = (String)target.get("type"))) continue;
            webSocketUrl = (String)target.get("webSocketDebuggerUrl");
            if (options.attach != null && !targetUrl.contains(options.attach)) continue;
            break;
        }
        if (webSocketUrl == null) {
            throw new RuntimeException("failed to attach to Edge-Chromium debug server");
        }
        EdgeChromium edgeChromium = new EdgeChromium(options, command, webSocketUrl);
        edgeChromium.activate();
        edgeChromium.enablePageEvents();
        edgeChromium.enableRuntimeEvents();
        if (!options.headless) {
            edgeChromium.initWindowIdAndState();
        }
        return edgeChromium;
    }

    public static EdgeChromium start(String chromeExecutablePath, boolean headless) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("executable", chromeExecutablePath);
        options.put("headless", headless);
        return EdgeChromium.start(options);
    }

    public static EdgeChromium start(Map<String, Object> options) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        options.putIfAbsent("type", DRIVER_TYPE);
        ScenarioRuntime runtime = FeatureRuntime.forTempUse((HttpClientFactory)HttpClientFactory.DEFAULT).scenarios.next();
        ScenarioEngine.set(runtime.engine);
        return EdgeChromium.start(options, runtime);
    }

    public static EdgeChromium start() {
        return EdgeChromium.start(null);
    }

    public static EdgeChromium startHeadless() {
        return EdgeChromium.start(Collections.singletonMap("headless", true));
    }
}

