/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    private static final Logger logger = LoggerFactory.getLogger(Json.class);
    private final DocumentContext doc;
    private final boolean array;
    private final String prefix;

    private String prefix(String path) {
        return path.charAt(0) == '$' ? path : this.prefix + path;
    }

    public static Json object() {
        return Json.of("{}");
    }

    public static Json array() {
        return Json.of("[]");
    }

    public static Json of(Object any) {
        if (any instanceof String) {
            return new Json(JsonPath.parse((String)((String)any)));
        }
        if (any instanceof List) {
            return new Json(JsonPath.parse((Object)((List)any)));
        }
        if (any instanceof Map) {
            return new Json(JsonPath.parse((Object)((Map)any)));
        }
        String json = JsonUtils.toJson(any);
        return new Json(JsonPath.parse((String)json));
    }

    public static <T> T parse(String json) {
        return Json.of(json).value();
    }

    private Json(DocumentContext doc) {
        this.doc = doc;
        this.array = doc.json() instanceof List;
        this.prefix = this.array ? "$" : "$.";
    }

    public Json getJson(String path) {
        return Json.of(this.get(path, Object.class));
    }

    public <T> List<T> getAll(String prefix, List<String> paths) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (String path : paths) {
            res.add(this.doc.read(this.prefix(prefix + path), new Predicate[0]));
        }
        return res;
    }

    public <T> List<T> getAll(List<String> paths) {
        return this.getAll("", paths);
    }

    public <T> T get(String path) {
        return (T)this.doc.read(this.prefix(path), new Predicate[0]);
    }

    public <T> T get(String path, T defaultValue) {
        return this.getOptional(path).orElse(defaultValue);
    }

    public <T> Optional<T> getOptional(String path) {
        try {
            return Optional.of(this.get(path));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <T> T getFirst(String path) {
        List list = (List)this.get(path);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    public <T> T getAs(String path, Class<T> clazz) {
        return (T)this.doc.read(this.prefix(path), clazz, new Predicate[0]);
    }

    public String toString() {
        return this.doc.jsonString();
    }

    public String toStringPretty() {
        return JsonUtils.toJson(this.value(), true);
    }

    public boolean isArray() {
        return this.array;
    }

    public <T> T value() {
        return (T)this.doc.read("$", new Predicate[0]);
    }

    public List asList() {
        return (List)this.value();
    }

    public Map<String, Object> asMap() {
        return (Map)this.value();
    }

    public Json set(String path, Object value) {
        this.setInternal(path, value);
        return this;
    }

    public Json set(String path, String value) {
        if (JsonUtils.isJson(value)) {
            this.setInternal(path, Json.of(value).value());
        } else {
            if (value != null && !value.isEmpty() && value.charAt(0) == '\\') {
                value = value.substring(1);
            }
            this.setInternal(path, value);
        }
        return this;
    }

    public Json setAsString(String path, String value) {
        this.setInternal(path, value);
        return this;
    }

    public Json remove(String path) {
        this.doc.delete(this.prefix(path), new Predicate[0]);
        return this;
    }

    private boolean isArrayPath(String s) {
        return s.endsWith("]") && !s.endsWith("']");
    }

    private String arrayKey(String s) {
        int pos = s.lastIndexOf(91);
        return s.substring(0, pos);
    }

    private int arrayIndex(String s) {
        int leftPos = s.lastIndexOf(91);
        if (leftPos == -1) {
            return -1;
        }
        int rightPos = s.indexOf(93, leftPos);
        if (leftPos == -1) {
            return -1;
        }
        String num = s.substring(leftPos + 1, rightPos);
        if (num.isEmpty()) {
            return -1;
        }
        try {
            return Integer.valueOf(num);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void setInternal(String path, Object o) {
        if ("$".equals(path = this.prefix(path))) {
            throw new RuntimeException("cannot replace root path $");
        }
        boolean forArray = this.isArrayPath(path);
        if (!this.pathExists(path)) {
            this.createPath(path, forArray);
        }
        StringUtils.Pair pair = Json.toParentAndLeaf(path);
        if (forArray) {
            int index = this.arrayIndex(pair.right);
            if (index == -1) {
                this.doc.add(this.arrayKey(path), o, new Predicate[0]);
            } else {
                this.doc.set(path, o, new Predicate[0]);
            }
        } else {
            this.doc.put(pair.left, pair.right, o, new Predicate[0]);
        }
    }

    public boolean pathExists(String path) {
        if (path.endsWith("[]")) {
            path = path.substring(0, path.length() - 2);
        }
        try {
            Object temp = this.doc.read(path, new Predicate[0]);
            return temp != null;
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
    }

    private void createPath(String path, boolean array) {
        if (this.isArrayPath(path)) {
            ArrayList list;
            String parentPath = this.arrayKey(path);
            if (!this.pathExists(parentPath)) {
                this.createPath(parentPath, true);
            }
            if ((list = (ArrayList)this.get(parentPath)) == null) {
                list = new ArrayList();
                this.set(parentPath, list);
            }
            int index = this.arrayIndex(path);
            if (list.size() <= index) {
                for (int i = list.size(); i <= index; ++i) {
                    list.add(null);
                }
            }
        } else {
            StringUtils.Pair pair = Json.toParentAndLeaf(path);
            if (!this.pathExists(pair.left)) {
                this.createPath(pair.left, false);
            }
            if (this.isArrayPath(pair.left)) {
                if (this.isArrayPath(pair.right)) {
                    this.doc.set(pair.left, new ArrayList(), new Predicate[0]);
                } else {
                    if (!this.pathExists(pair.left)) {
                        this.doc.set(pair.left, new LinkedHashMap(), new Predicate[0]);
                    }
                    this.doc.put(pair.left, pair.right, array ? new ArrayList() : new LinkedHashMap(), new Predicate[0]);
                }
            } else {
                this.doc.put(pair.left, pair.right, array ? new ArrayList() : new LinkedHashMap(), new Predicate[0]);
            }
        }
    }

    public static StringUtils.Pair toParentAndLeaf(String path) {
        String right;
        int pos = path.lastIndexOf(46);
        int temp = path.lastIndexOf("['");
        if (temp != -1 && temp > pos) {
            pos = temp - 1;
        }
        if ((right = path.substring(pos + 1)).startsWith("[")) {
            ++pos;
        }
        String left = path.substring(0, pos == -1 ? 0 : pos);
        return StringUtils.pair(left, right);
    }
}

