/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.http.ResourceType;
import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class Embed {
    private final File file;
    private final ResourceType resourceType;

    public Embed(File file, ResourceType resourceType) {
        this.file = file;
        this.resourceType = resourceType;
    }

    public String getAsHtmlForReport() {
        if (this.resourceType.isImage() || this.resourceType.isVideo() || this.resourceType.isScript()) {
            return this.getAsHtmlTag();
        }
        return this.getAsString();
    }

    public static Embed fromKarateJson(Map<String, Object> map) {
        String fileName = (String)map.get("file");
        String rtName = (String)map.get("resourceType");
        File file = new File(fileName);
        ResourceType rt = ResourceType.valueOf(rtName);
        return new Embed(file, rt);
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file", this.file.getPath());
        map.put("resourceType", this.resourceType.name());
        map.put("html", this.getAsHtmlForReport());
        return map;
    }

    public File getFile() {
        return this.file;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public byte[] getBytes() {
        return FileUtils.toBytes(this.file);
    }

    public String getBase64() {
        return Base64.getEncoder().encodeToString(this.getBytes());
    }

    public String getAsString() {
        return FileUtils.toString(this.file);
    }

    public String getAsHtmlData() {
        return "data:" + this.resourceType.contentType + ";base64," + this.getBase64();
    }

    public String getAsHtmlTag() {
        if (this.resourceType == ResourceType.MP4) {
            return "<video controls=\"true\" width=\"100%\"><source src=\"" + this.file.getName() + "\" type=\"video/mp4\"/></video>";
        }
        if (this.resourceType.isImage()) {
            return "<img src=\"" + this.file.getName() + "\"/>";
        }
        if (this.resourceType.isScript()) {
            return this.resourceType == ResourceType.DEFERRED_JS ? "<div data-deferred=\"true\" data-src=\"" + this.file.getName() + "\">Loading...</div>" : "<script type=\"text/javascript\" src=\"" + this.file.getName() + "\"></script>";
        }
        return "<a href=\"" + this.file.getName() + "\">" + this.file.getName() + "</a>";
    }

    public Map toMap() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (this.resourceType == ResourceType.MP4) {
            byte[] bytes = FileUtils.toBytes(this.getAsHtmlTag());
            String base64 = Base64.getEncoder().encodeToString(bytes);
            map.put("data", base64);
            map.put("mime_type", ResourceType.HTML.contentType);
        } else {
            map.put("data", this.getBase64());
            map.put("mime_type", this.resourceType.contentType);
        }
        return map;
    }

    public String toString() {
        return this.file.toString();
    }
}

