/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ResponseBuilder;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.http.Session;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.template.KarateTemplateEngine;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycle {
    private static final Logger logger = LoggerFactory.getLogger(RequestCycle.class);
    public static final String CONTEXT = "context";
    private static final String REQUEST = "request";
    protected static final String SESSION = "session";
    private static final String RESPONSE = "response";
    private static final ThreadLocal<RequestCycle> THREAD_LOCAL = new ThreadLocal();
    private final JsEngine engine;
    private final KarateTemplateEngine templateEngine;
    private final Request request;
    private final Response response;
    private final ServerContext context;
    private final ServerConfig config;
    private final Function<ServerContext, Boolean> requestValidator;
    private String switchTemplate;
    private Map<String, Object> switchParams;
    private static final String DOT_JS = ".js";

    public static RequestCycle get() {
        return THREAD_LOCAL.get();
    }

    protected static RequestCycle init(KarateTemplateEngine te, ServerContext context) {
        RequestCycle rc = new RequestCycle(JsEngine.global(), te, context);
        THREAD_LOCAL.set(rc);
        return rc;
    }

    private RequestCycle(JsEngine engine, KarateTemplateEngine templateEngine, ServerContext context) {
        this.engine = engine;
        this.templateEngine = templateEngine;
        this.requestValidator = context.getRequestValidator();
        this.context = context;
        this.config = context.getConfig();
        Session session = context.getSession();
        if (session != null && !session.isTemporary()) {
            engine.put(SESSION, session.getData());
        } else {
            engine.put(SESSION, Collections.emptyMap());
        }
        Map<String, Object> variables = context.getVariables();
        if (variables != null) {
            engine.putAll(variables);
        }
        this.request = context.getRequest();
        this.request.processBody();
        engine.put(REQUEST, this.request);
        this.response = new Response(200);
        engine.put(RESPONSE, this.response);
        engine.put(CONTEXT, context);
    }

    public RequestCycle copy(Request request, Map<String, Object> variables) {
        ServerContext temp = new ServerContext(this.config, request, variables);
        temp.setSession(this.context.getSession());
        return new RequestCycle(JsEngine.local(), this.templateEngine, temp);
    }

    public JsEngine getEngine() {
        return this.engine;
    }

    public KarateTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public ResourceResolver getResourceResolver() {
        return this.config.getResourceResolver();
    }

    private void close() {
        Session session = this.context.getSession();
        if (session != null && !session.isTemporary()) {
            if (this.context.isClosed()) {
                this.context.getConfig().getSessionStore().delete(session.getId());
                session.getData().clear();
                logger.debug("session deleted: {}", (Object)session.getId());
            } else {
                JsValue sessionValue = this.engine.get(SESSION);
                if (sessionValue.isObject()) {
                    session.getData().putAll(sessionValue.getAsMap());
                    this.context.getConfig().getSessionStore().save(session);
                } else {
                    logger.error("invalid session, not map-like: {}", (Object)sessionValue);
                }
            }
        }
        JsEngine.remove();
        THREAD_LOCAL.remove();
    }

    public Session getSession() {
        return this.context.getSession();
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public ServerContext getContext() {
        return this.context;
    }

    public void setSwitchTemplate(String switchTemplate) {
        this.switchTemplate = switchTemplate;
    }

    public String getSwitchTemplate() {
        return this.switchTemplate;
    }

    public void setSwitchParams(Map<String, Object> switchParams) {
        this.switchParams = new HashMap<String, Object>(switchParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response handle() {
        Object is;
        block17: {
            Object object;
            block16: {
                Boolean valid;
                if (this.requestValidator == null || (valid = this.requestValidator.apply(this.context)) != null && valid.booleanValue()) break block16;
                logger.error("unauthorized request: {}", (Object)this.request);
                this.response.setStatus(401);
                Response response = this.response().buildWithStatus(401);
                this.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} {} [{} ms]", new Object[]{this.request, this.response.getStatus(), System.currentTimeMillis() - this.request.getStartTime()});
                }
                return response;
            }
            if (!this.context.isApi()) break block17;
            is = this.apiResource();
            if (this.context.isLockNeeded()) {
                object = this.config;
                synchronized (object) {
                    this.engine.eval((InputStream)is);
                }
            } else {
                this.engine.eval((InputStream)is);
            }
            object = this.response().build();
            this.close();
            if (logger.isDebugEnabled()) {
                logger.debug("{} {} [{} ms]", new Object[]{this.request, this.response.getStatus(), System.currentTimeMillis() - this.request.getStartTime()});
            }
            return object;
        }
        try {
            is = this.htmlResponse();
            this.close();
        }
        catch (Exception e) {
            Response response;
            try {
                logger.error("handle failed: {}", (Object)e.getMessage());
                this.response.setStatus(500);
                response = this.response().buildWithStatus(500);
                this.close();
            }
            catch (Throwable throwable) {
                this.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} {} [{} ms]", new Object[]{this.request, this.response.getStatus(), System.currentTimeMillis() - this.request.getStartTime()});
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} {} [{} ms]", new Object[]{this.request, this.response.getStatus(), System.currentTimeMillis() - this.request.getStartTime()});
            }
            return response;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} {} [{} ms]", new Object[]{this.request, this.response.getStatus(), System.currentTimeMillis() - this.request.getStartTime()});
        }
        return is;
    }

    private Response htmlResponse() {
        String html;
        try {
            html = this.templateEngine.process(this.request.getPath());
        }
        catch (Exception e) {
            if (this.context.isSwitched()) {
                if (this.switchTemplate == null) {
                    logger.debug("abort template requested");
                    html = null;
                } else {
                    logger.debug("switch template requested: {}", (Object)this.switchTemplate);
                    this.request.getParams().clear();
                    if (this.switchParams != null) {
                        this.switchParams.forEach((k, v) -> this.request.setParam((String)k, v));
                    }
                    html = this.templateEngine.process(this.switchTemplate);
                }
            }
            throw e;
        }
        return this.response().html(html).build();
    }

    private InputStream apiResource() {
        String resourcePath = this.request.getResourcePath();
        String jsPath = resourcePath == null ? this.request.getPathOriginal() + DOT_JS : resourcePath;
        try {
            return this.config.getResourceResolver().resolve(jsPath).getStream();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to resolve api resource: " + resourcePath + ", " + this.request + ", " + e.getMessage());
        }
    }

    public ResponseBuilder response() {
        return new ResponseBuilder(this.config, this).session(this.context.getSession(), this.context.isNewSession());
    }
}

