/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsValue;
import com.intuit.karate.template.KarateEngineContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.processor.StandardConditionalFixedValueTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.EscapedAttributeUtils;

abstract class KarateAttributeTagProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KarateAttributeTagProcessor.class);
    private final ModificationType modificationType;

    protected KarateAttributeTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, ModificationType modificationType) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
        this.modificationType = modificationType;
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String av, IElementTagStructureHandler structureHandler) {
        JsValue jv = KarateEngineContext.get().evalLocalAsObject(av);
        if (!jv.isObject()) {
            logger.warn("value did not evaluate to json: {}", (Object)av);
            return;
        }
        Map<String, Object> map = jv.getAsMap();
        map.forEach((k, v) -> {
            if (this.getTemplateMode() == TemplateMode.HTML && this.modificationType == ModificationType.SUBSTITUTION && ArrayUtils.contains((Object[])StandardConditionalFixedValueTagProcessor.ATTR_NAMES, (Object)k)) {
                if (JsValue.isTruthy(v)) {
                    structureHandler.setAttribute(k, k);
                } else {
                    structureHandler.removeAttribute(k);
                }
            } else {
                String newAttributeValue = EscapedAttributeUtils.escapeAttribute((TemplateMode)this.getTemplateMode(), (String)(v == null ? null : v.toString()));
                if (newAttributeValue == null || newAttributeValue.length() == 0) {
                    if (this.modificationType == ModificationType.SUBSTITUTION) {
                        structureHandler.removeAttribute(k);
                    }
                } else if (this.modificationType == ModificationType.SUBSTITUTION || !tag.hasAttribute(k) || tag.getAttributeValue(k).length() == 0) {
                    structureHandler.setAttribute(k, newAttributeValue);
                } else {
                    String currentValue = tag.getAttributeValue(k);
                    if (this.modificationType == ModificationType.APPEND) {
                        structureHandler.setAttribute(k, currentValue + newAttributeValue);
                    } else if (this.modificationType == ModificationType.APPEND_WITH_SPACE) {
                        structureHandler.setAttribute(k, currentValue + " " + newAttributeValue);
                    } else if (this.modificationType == ModificationType.PREPEND) {
                        structureHandler.setAttribute(k, newAttributeValue + currentValue);
                    } else {
                        structureHandler.setAttribute(k, newAttributeValue + " " + currentValue);
                    }
                }
            }
        });
    }

    protected static enum ModificationType {
        SUBSTITUTION,
        APPEND,
        PREPEND,
        APPEND_WITH_SPACE,
        PREPEND_WITH_SPACE;

    }

    public static class KarateAttrprependTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrprependTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attrprepend", 900, ModificationType.PREPEND);
        }
    }

    public static class KarateAttrappendTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrappendTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attrappend", 900, ModificationType.APPEND);
        }
    }

    public static class KarateAttrTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attr", 700, ModificationType.SUBSTITUTION);
        }
    }
}

