/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Background;
import com.intuit.karate.core.ExamplesTable;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.KarateLexer;
import com.intuit.karate.core.KarateParser;
import com.intuit.karate.core.KarateParserBaseListener;
import com.intuit.karate.core.ParserErrorListener;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioOutline;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import com.intuit.karate.core.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import karate.org.antlr.v4.runtime.CharStream;
import karate.org.antlr.v4.runtime.CharStreams;
import karate.org.antlr.v4.runtime.CommonTokenStream;
import karate.org.antlr.v4.runtime.ParserRuleContext;
import karate.org.antlr.v4.runtime.Token;
import karate.org.antlr.v4.runtime.tree.ParseTreeWalker;
import karate.org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParser
extends KarateParserBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(FeatureParser.class);
    private final ParserErrorListener errorListener = new ParserErrorListener();
    private final Feature feature;
    private final CommonTokenStream tokenStream;
    public static final String TRIPLE_QUOTES = "\"\"\"";

    private FeatureParser(Feature feature, InputStream is) {
        CharStream stream;
        this.feature = feature;
        try {
            stream = CharStreams.fromStream(is, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KarateLexer lexer = new KarateLexer(stream);
        this.tokenStream = new CommonTokenStream(lexer);
        KarateParser parser = new KarateParser(this.tokenStream);
        parser.addErrorListener(this.errorListener);
        KarateParser.FeatureContext tree = parser.feature();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(this, tree);
    }

    protected static void parse(Feature feature) {
        FeatureParser fp = new FeatureParser(feature, feature.getResource().getStream());
        if (fp.errorListener.isFail()) {
            String errorMessage = fp.errorListener.getMessage();
            logger.error("not a valid feature file: {} - {}", (Object)feature.getResource().getRelativePath(), (Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    private static int getActualLine(TerminalNode node) {
        int count = 0;
        for (char c : node.getText().toCharArray()) {
            if (c == '\n') {
                ++count;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return node.getSymbol().getLine() + count;
    }

    private static List<Tag> toTags(int line, List<TerminalNode> nodes) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (TerminalNode node : nodes) {
            String[] tokens;
            String text = node.getText();
            if (line == -1) {
                line = FeatureParser.getActualLine(node);
            }
            for (String t : tokens = text.trim().split("\\s+")) {
                tags.add(new Tag(line, t));
            }
        }
        return tags;
    }

    private static Table toTable(KarateParser.TableContext ctx) {
        List<TerminalNode> nodes = ctx.TABLE_ROW();
        int rowCount = nodes.size();
        if (rowCount < 1) {
            return null;
        }
        ArrayList<List<String>> rows = new ArrayList<List<String>>(rowCount);
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>(rowCount);
        int prevCount = -1;
        for (TerminalNode node : nodes) {
            List<String> tokens = StringUtils.split(node.getText().trim(), '|', true);
            int count = tokens.size();
            if (prevCount != -1 && prevCount != count) {
                throw new RuntimeException("examples column count mismatch at line: " + FeatureParser.getActualLine(node) + "\n" + node.getText() + "\n\nrows:" + nodes);
            }
            prevCount = count;
            for (int i = 0; i < count; ++i) {
                tokens.set(i, tokens.get(i).trim());
            }
            rows.add(tokens);
            lineNumbers.add(FeatureParser.getActualLine(node));
        }
        return new Table(rows, lineNumbers);
    }

    private static int indexOfFirstText(String s) {
        int pos = 0;
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return pos;
            }
            ++pos;
        }
        return 0;
    }

    private static String fixDocString(String temp) {
        int quotePos = temp.indexOf(TRIPLE_QUOTES);
        int endPos = temp.lastIndexOf(TRIPLE_QUOTES);
        String raw = temp.substring(quotePos + 3, endPos).replaceAll("\r", "");
        List<String> lines = StringUtils.split(raw, '\n', false);
        StringBuilder sb = new StringBuilder();
        int marginPos = -1;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            int firstTextPos = FeatureParser.indexOfFirstText(line);
            if (marginPos == -1) {
                marginPos = firstTextPos;
            }
            if (marginPos < line.length() && marginPos <= firstTextPos) {
                line = line.substring(marginPos);
            }
            if (iterator.hasNext()) {
                sb.append(line).append('\n');
                continue;
            }
            sb.append(line);
        }
        return sb.toString().trim();
    }

    private List<String> collectComments(ParserRuleContext prc) {
        List<Token> tokens = this.tokenStream.getHiddenTokensToLeft(prc.start.getTokenIndex());
        if (tokens == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>(tokens.size());
        for (Token t : tokens) {
            comments.add(StringUtils.trimToNull(t.getText()));
        }
        return comments;
    }

    private List<Step> toSteps(Scenario scenario, List<KarateParser.StepContext> list) {
        ArrayList<Step> steps = new ArrayList<Step>(list.size());
        int index = 0;
        for (KarateParser.StepContext sc : list) {
            Step step;
            if (scenario == null) {
                ++index;
                step = new Step(this.feature, index);
            } else {
                ++index;
                step = new Step(scenario, index);
            }
            Step step2 = step;
            step2.setComments(this.collectComments(sc));
            steps.add(step2);
            int stepLine = sc.line().getStart().getLine();
            step2.setLine(stepLine);
            step2.setPrefix(sc.prefix().getText().trim());
            step2.setText(sc.line().getText().trim());
            if (sc.docString() != null) {
                String raw = sc.docString().getText();
                step2.setDocString(FeatureParser.fixDocString(raw));
                step2.setEndLine(stepLine + StringUtils.countLineFeeds(raw));
                continue;
            }
            if (sc.table() != null) {
                Table table = FeatureParser.toTable(sc.table());
                step2.setTable(table);
                step2.setEndLine(stepLine + StringUtils.countLineFeeds(sc.table().getText()));
                continue;
            }
            step2.setEndLine(stepLine);
        }
        return steps;
    }

    @Override
    public void enterFeatureHeader(KarateParser.FeatureHeaderContext ctx) {
        if (ctx.featureTags() != null) {
            this.feature.setTags(FeatureParser.toTags(ctx.featureTags().getStart().getLine(), ctx.featureTags().FEATURE_TAGS()));
        }
        if (ctx.FEATURE() != null) {
            this.feature.setLine(ctx.FEATURE().getSymbol().getLine());
            if (ctx.featureDescription() != null) {
                StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.featureDescription().getText());
                this.feature.setName(pair.left);
                this.feature.setDescription(pair.right);
            }
        }
    }

    @Override
    public void enterBackground(KarateParser.BackgroundContext ctx) {
        Background background = new Background();
        this.feature.setBackground(background);
        background.setLine(FeatureParser.getActualLine(ctx.BACKGROUND()));
        List<Step> steps = this.toSteps(null, ctx.step());
        if (!steps.isEmpty()) {
            background.setSteps(steps);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("background steps: {}", steps);
        }
    }

    @Override
    public void enterScenario(KarateParser.ScenarioContext ctx) {
        FeatureSection section = new FeatureSection();
        Scenario scenario = new Scenario(this.feature, section, -1);
        scenario.setLine(FeatureParser.getActualLine(ctx.SCENARIO()));
        section.setScenario(scenario);
        this.feature.addSection(section);
        if (ctx.tags() != null) {
            scenario.setTags(FeatureParser.toTags(-1, ctx.tags().TAGS()));
        }
        if (ctx.scenarioDescription() != null) {
            StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.scenarioDescription().getText());
            scenario.setName(pair.left);
            scenario.setDescription(pair.right);
        }
        List<Step> steps = this.toSteps(scenario, ctx.step());
        scenario.setSteps(steps);
    }

    @Override
    public void enterScenarioOutline(KarateParser.ScenarioOutlineContext ctx) {
        FeatureSection section = new FeatureSection();
        ScenarioOutline outline = new ScenarioOutline(this.feature, section);
        outline.setLine(FeatureParser.getActualLine(ctx.SCENARIO_OUTLINE()));
        section.setScenarioOutline(outline);
        this.feature.addSection(section);
        if (ctx.tags() != null) {
            outline.setTags(FeatureParser.toTags(-1, ctx.tags().TAGS()));
        }
        if (ctx.scenarioDescription() != null) {
            outline.setDescription(ctx.scenarioDescription().getText());
            StringUtils.Pair pair = StringUtils.splitByFirstLineFeed(ctx.scenarioDescription().getText());
            outline.setName(pair.left);
            outline.setDescription(pair.right);
        }
        List<Step> steps = this.toSteps(null, ctx.step());
        outline.setSteps(steps);
        if (logger.isTraceEnabled()) {
            logger.trace("outline steps: {}", steps);
        }
        ArrayList<ExamplesTable> examples = new ArrayList<ExamplesTable>(ctx.examples().size());
        outline.setExamplesTables(examples);
        for (KarateParser.ExamplesContext ec : ctx.examples()) {
            Table table = FeatureParser.toTable(ec.table());
            ExamplesTable example = new ExamplesTable(outline, table);
            examples.add(example);
            if (ec.tags() != null) {
                example.setTags(FeatureParser.toTags(-1, ec.tags().TAGS()));
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("example rows: {}", table.getRows());
        }
    }
}

