/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.Logger;
import com.intuit.karate.Match;
import com.intuit.karate.MatchStep;
import com.intuit.karate.PerfContext;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.MockServer;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Variable;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsFunction;
import com.intuit.karate.graal.JsLambda;
import com.intuit.karate.graal.JsList;
import com.intuit.karate.graal.JsMap;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.WebSocketClient;
import com.intuit.karate.http.WebSocketOptions;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

public class ScenarioBridge
implements PerfContext {
    private final ScenarioEngine ENGINE;
    private LogFacade logFacade;

    protected ScenarioBridge(ScenarioEngine engine) {
        this.ENGINE = engine;
    }

    public void abort() {
        this.getEngine().setAborted(true);
    }

    public Object append(Value ... vals) {
        ArrayList<Object> list = new ArrayList<Object>();
        JsList jsList = new JsList(list);
        if (vals.length == 0) {
            return jsList;
        }
        Value val = vals[0];
        if (val.hasArrayElements()) {
            list.addAll((Collection)val.as(List.class));
        } else {
            list.add(val.as(Object.class));
        }
        if (vals.length == 1) {
            return jsList;
        }
        for (int i = 1; i < vals.length; ++i) {
            Value v = vals[i];
            if (v.hasArrayElements()) {
                list.addAll((Collection)v.as(List.class));
                continue;
            }
            list.add(v.as(Object.class));
        }
        return jsList;
    }

    private Object appendToInternal(String varName, Value ... vals) {
        ScenarioEngine engine = this.getEngine();
        Variable var = engine.vars.get(varName);
        if (!var.isList()) {
            return null;
        }
        List list = (List)var.getValue();
        for (Value v : vals) {
            if (v.hasArrayElements()) {
                list.addAll((Collection)v.as(List.class));
                continue;
            }
            Object temp = v.as(Object.class);
            list.add(temp);
        }
        engine.setVariable(varName, list);
        return new JsList(list);
    }

    public Object appendTo(Value ref, Value ... vals) {
        if (ref.isString()) {
            return this.appendToInternal(ref.asString(), vals);
        }
        List list = ref.hasArrayElements() ? new JsValue(ref).getAsList() : new ArrayList();
        for (Value v : vals) {
            if (v.hasArrayElements()) {
                list.addAll((Collection)v.as(List.class));
                continue;
            }
            Object temp = v.as(Object.class);
            list.add(temp);
        }
        return new JsList(list);
    }

    public Object call(String fileName) {
        return this.call(false, fileName, null);
    }

    public Object call(String fileName, Value arg) {
        return this.call(false, fileName, arg);
    }

    public Object call(boolean sharedScope, String fileName) {
        return this.call(sharedScope, fileName, null);
    }

    public Object call(boolean sharedScope, String fileName, Value arg) {
        ScenarioEngine engine = this.getEngine();
        Variable called = new Variable(engine.fileReader.readFile(fileName));
        Variable result = engine.call(called, arg == null ? null : new Variable(arg), sharedScope);
        if (sharedScope && result.isMap()) {
            engine.setVariables((Map)result.getValue());
        }
        return JsValue.fromJava(result.getValue());
    }

    private static Object callSingleResult(ScenarioEngine engine, Object o) throws Exception {
        if (o instanceof Exception) {
            engine.logger.warn("callSingle() cached result is an exception", new Object[0]);
            throw (Exception)o;
        }
        o = engine.JS.attachAll(o);
        return JsValue.fromJava(o);
    }

    public Object callSingle(String fileName) throws Exception {
        return this.callSingle(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callSingle(String fileName, Value arg) throws Exception {
        ScenarioEngine engine = this.getEngine();
        Map<String, Object> CACHE = engine.runtime.featureRuntime.suite.callSingleCache;
        int minutes = engine.getConfig().getCallSingleCacheMinutes();
        if (minutes == 0 && CACHE.containsKey(fileName)) {
            engine.logger.trace("callSingle cache hit: {}", fileName);
            return ScenarioBridge.callSingleResult(engine, CACHE.get(fileName));
        }
        long startTime = System.currentTimeMillis();
        engine.logger.trace("callSingle waiting for lock: {}", fileName);
        Map<String, Object> map = CACHE;
        synchronized (map) {
            if (minutes == 0 && CACHE.containsKey(fileName)) {
                long endTime = System.currentTimeMillis() - startTime;
                engine.logger.warn("this thread waited {} milliseconds for callSingle lock: {}", endTime, fileName);
                return ScenarioBridge.callSingleResult(engine, CACHE.get(fileName));
            }
            engine.logger.info(">> lock acquired, begin callSingle: {}", fileName);
            Object result = null;
            File cacheFile = null;
            if (minutes > 0) {
                String cleanedName = StringUtils.toIdString(fileName);
                String cacheFileName = engine.getConfig().getCallSingleCacheDir() + File.separator + cleanedName + ".txt";
                cacheFile = new File(cacheFileName);
                long since = System.currentTimeMillis() - (long)(minutes * 60 * 1000);
                if (cacheFile.exists()) {
                    long lastModified = cacheFile.lastModified();
                    if (lastModified > since) {
                        String json = FileUtils.toString(cacheFile);
                        result = JsonUtils.fromJson(json);
                        engine.logger.info("callSingleCache hit: {}", cacheFile);
                    } else {
                        engine.logger.info("callSingleCache stale, last modified {} - is before {} (minutes: {})", lastModified, since, minutes);
                    }
                } else {
                    engine.logger.info("callSingleCache file does not exist, will create: {}", cacheFile);
                }
            }
            if (result == null) {
                Variable resultVar;
                Variable called = new Variable(this.read(fileName));
                Variable argVar = arg == null || arg.isNull() ? null : new Variable(arg);
                try {
                    resultVar = engine.call(called, argVar, false);
                }
                catch (Exception e) {
                    RuntimeException re = new RuntimeException(e.getMessage());
                    resultVar = new Variable(re);
                    engine.logger.warn("callSingle() will cache an exception", new Object[0]);
                }
                if (minutes > 0) {
                    if (resultVar.isMapOrList()) {
                        String json = resultVar.getAsString();
                        FileUtils.writeToFile(cacheFile, json);
                        engine.logger.info("callSingleCache write: {}", cacheFile);
                    } else {
                        engine.logger.warn("callSingleCache write failed, not json-like: {}", resultVar);
                    }
                }
                result = resultVar.getValue();
            }
            CACHE.put(fileName, result);
            engine.logger.info("<< lock released, cached callSingle: {}", fileName);
            return ScenarioBridge.callSingleResult(engine, result);
        }
    }

    public Object callonce(String path) {
        return this.callonce(false, path);
    }

    public Object callonce(boolean sharedScope, String path) {
        String exp = "read('" + path + "')";
        Variable v = this.getEngine().call(true, exp, sharedScope);
        return JsValue.fromJava(v.getValue());
    }

    @Override
    public void capturePerfEvent(String name, long startTime, long endTime) {
        PerfEvent event = new PerfEvent(startTime, endTime, name, 200);
        this.getEngine().capturePerfEvent(event);
    }

    public Object channel(String type) {
        return this.getEngine().channelSession(type);
    }

    public Object compareImage(Object baseline, Object latest, Value ... optionsVal) {
        if (optionsVal.length > 0 && !optionsVal[0].hasMembers()) {
            throw new RuntimeException("invalid image comparison options: expected map");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (optionsVal.length > 0) {
            for (String k : optionsVal[0].getMemberKeys()) {
                options.put(k, optionsVal[0].getMember(k).as(Object.class));
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("baseline", baseline);
        params.put("latest", latest);
        params.put("options", options);
        return JsValue.fromJava(this.getEngine().compareImageInternal(params));
    }

    public void configure(String key, Value value) {
        this.getEngine().configure(key, new Variable(value));
    }

    public Object consume(String type) {
        this.getEngine().logger.warn("karate.consume() is deprecated, use karate.channel() instead", new Object[0]);
        return this.channel(type);
    }

    public Object distinct(Value o) {
        if (!o.hasArrayElements()) {
            return JsList.EMPTY;
        }
        long count = o.getArraySize();
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        int i = 0;
        while ((long)i < count) {
            Object value = JsValue.toJava(o.getArrayElement((long)i));
            set.add(value);
            ++i;
        }
        return JsValue.fromJava(new ArrayList(set));
    }

    public String doc(Value v) {
        Map<String, Object> arg;
        if (v.isString()) {
            arg = Collections.singletonMap("read", v.asString());
        } else if (v.hasMembers()) {
            arg = new JsValue(v).getAsMap();
        } else {
            this.getEngine().logger.warn("doc - unexpected argument: {}", v);
            return null;
        }
        return this.getEngine().docInternal(arg);
    }

    public void embed(Object o, String contentType) {
        ResourceType resourceType = contentType == null ? ResourceType.fromObject(o, ResourceType.BINARY) : ResourceType.fromContentType(contentType);
        this.getEngine().runtime.embed(JsonUtils.toBytes(o), resourceType);
    }

    public Object eval(String exp) {
        Variable result = this.getEngine().evalJs(exp);
        return JsValue.fromJava(result.getValue());
    }

    public String exec(Value value) {
        if (value.isString()) {
            return this.execInternal(Collections.singletonMap("line", value.asString()));
        }
        if (value.hasArrayElements()) {
            List args = new JsValue(value).getAsList();
            return this.execInternal(Collections.singletonMap("args", args));
        }
        return this.execInternal(new JsValue(value).getAsMap());
    }

    private String execInternal(Map<String, Object> options) {
        Command command = this.getEngine().fork(false, options);
        command.waitSync();
        return command.getAppender().collect();
    }

    public String extract(String text, String regex, int group) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (!matcher.find()) {
            this.getEngine().logger.warn("failed to find pattern: {}", regex);
            return null;
        }
        return matcher.group(group);
    }

    public List<String> extractAll(String text, String regex, int group) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(group));
        }
        return list;
    }

    public void fail(String reason) {
        this.getEngine().setFailedReason(new KarateException(reason));
    }

    public Object filter(Value o, Value f) {
        if (!o.hasArrayElements()) {
            return JsList.EMPTY;
        }
        ScenarioBridge.assertIfJsFunction(f);
        long count = o.getArraySize();
        ArrayList list = new ArrayList();
        int i = 0;
        while ((long)i < count) {
            Value v = o.getArrayElement((long)i);
            Value res = JsEngine.execute(f, v, i);
            if (res.isBoolean() && res.asBoolean()) {
                list.add(new JsValue(v).getValue());
            }
            ++i;
        }
        return new JsList(list);
    }

    public Object filterKeys(Value o, Value ... args) {
        Variable v = new Variable(o);
        if (!v.isMap()) {
            return JsMap.EMPTY;
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (args.length == 1) {
            if (args[0].isString()) {
                keys.add(args[0].asString());
            } else if (args[0].hasArrayElements()) {
                long count = args[0].getArraySize();
                int i = 0;
                while ((long)i < count) {
                    keys.add(args[0].getArrayElement((long)i).toString());
                    ++i;
                }
            } else if (args[0].hasMembers()) {
                for (String s : args[0].getMemberKeys()) {
                    keys.add(s);
                }
            }
        } else {
            for (Value value : args) {
                keys.add(value.toString());
            }
        }
        Map map = (Map)v.getValue();
        LinkedHashMap result = new LinkedHashMap(keys.size());
        for (String string : keys) {
            if (string == null || !map.containsKey(string)) continue;
            result.put(string, map.get(string));
        }
        return new JsMap(result);
    }

    public void forEach(Value o, Value f) {
        ScenarioBridge.assertIfJsFunction(f);
        if (o.hasArrayElements()) {
            long count = o.getArraySize();
            int i = 0;
            while ((long)i < count) {
                Value v = o.getArrayElement((long)i);
                f.executeVoid(new Object[]{v, i});
                ++i;
            }
        } else if (o.hasMembers()) {
            int i = 0;
            for (String k : o.getMemberKeys()) {
                Value v = o.getMember(k);
                f.executeVoid(new Object[]{k, v, i++});
            }
        } else {
            throw new RuntimeException("not an array or object: " + o);
        }
    }

    public Command fork(Value value) {
        if (value.isString()) {
            return this.getEngine().fork(true, value.asString());
        }
        if (value.hasArrayElements()) {
            List args = new JsValue(value).getAsList();
            return this.getEngine().fork(true, args);
        }
        return this.getEngine().fork(true, new JsValue(value).getAsMap());
    }

    public Object fromString(String exp) {
        ScenarioEngine engine = this.getEngine();
        try {
            Variable result = engine.evalKarateExpression(exp);
            return JsValue.fromJava(result.getValue());
        }
        catch (Exception e) {
            engine.setFailedReason(null);
            engine.logger.warn("auto evaluation failed: {}", e.getMessage());
            return exp;
        }
    }

    public Object get(String exp) {
        Variable v;
        ScenarioEngine engine = this.getEngine();
        try {
            v = engine.evalKarateExpression(exp);
        }
        catch (Exception e) {
            engine.logger.trace("karate.get failed for expression: '{}': {}", exp, e.getMessage());
            engine.setFailedReason(null);
            return null;
        }
        if (v != null) {
            return JsValue.fromJava(v.getValue());
        }
        return null;
    }

    public Object get(String exp, Object defaultValue) {
        Object result = this.get(exp);
        return result == null ? defaultValue : result;
    }

    public ScenarioEngine getEngine() {
        ScenarioEngine engine = ScenarioEngine.get();
        return engine == null ? this.ENGINE : engine;
    }

    public String getEnv() {
        return this.getEngine().runtime.featureRuntime.suite.env;
    }

    public Object getFeature() {
        return new JsMap(this.getEngine().runtime.featureRuntime.result.toInfoJson());
    }

    public Object getInfo() {
        return new JsMap(this.getEngine().runtime.getScenarioInfo());
    }

    public Object getLogger() {
        if (this.logFacade == null) {
            this.logFacade = new LogFacade();
        }
        return this.logFacade;
    }

    public Object getOs() {
        String name = FileUtils.getOsName();
        String type = FileUtils.getOsType(name).toString().toLowerCase();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("name", name);
        map.put("type", type);
        return new JsMap(map);
    }

    public Object getPrevRequest() {
        HttpRequest hr = this.getEngine().getHttpRequest();
        if (hr == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", hr.getMethod());
        map.put("url", hr.getUrl());
        map.put("headers", hr.getHeaders());
        map.put("body", hr.getBody());
        return JsValue.fromJava(map);
    }

    public Object getProperties() {
        return new JsMap(this.getEngine().runtime.featureRuntime.suite.systemProperties);
    }

    public Object getResponse() {
        return this.getEngine().getResponse();
    }

    public Object getRequest() {
        return this.getEngine().getRequest();
    }

    public Object getScenario() {
        return new JsMap(this.getEngine().runtime.result.toKarateJson());
    }

    public Object getScenarioOutline() {
        return new JsMap(this.getEngine().runtime.outlineResult.toKarateJson());
    }

    public Object getTags() {
        return JsValue.fromJava(this.getEngine().runtime.tags.getTags());
    }

    public Object getTagValues() {
        return JsValue.fromJava(this.getEngine().runtime.tags.getTagValues());
    }

    public HttpRequestBuilder http(String url) {
        ScenarioEngine engine = this.getEngine();
        HttpClient client = engine.runtime.featureRuntime.suite.clientFactory.create(engine);
        return new HttpRequestBuilder(client).url(url);
    }

    public Object jsonPath(Object o, String exp) {
        Json json = Json.of(o);
        return JsValue.fromJava(json.get(exp));
    }

    public Object keysOf(Object o) {
        Variable v = new Variable(o);
        if (v.isMap()) {
            return new JsList(((Map)v.getValue()).keySet());
        }
        return JsList.EMPTY;
    }

    public void log(Value ... values) {
        ScenarioEngine engine = this.getEngine();
        if (engine.getConfig().isPrintEnabled()) {
            engine.logger.info("{}", new LogWrapper(values));
        }
    }

    public Object lowerCase(Object o) {
        Variable var = new Variable(o);
        return JsValue.fromJava(var.toLowerCase().getValue());
    }

    public Object map(Value o, Value f) {
        if (!o.hasArrayElements()) {
            return JsList.EMPTY;
        }
        ScenarioBridge.assertIfJsFunction(f);
        long count = o.getArraySize();
        ArrayList list = new ArrayList();
        int i = 0;
        while ((long)i < count) {
            Value v = o.getArrayElement((long)i);
            Value res = JsEngine.execute(f, v, i);
            list.add(new JsValue(res).getValue());
            ++i;
        }
        return new JsList(list);
    }

    public Object mapWithKey(Value v, String key) {
        if (!v.hasArrayElements()) {
            return JsList.EMPTY;
        }
        long count = v.getArraySize();
        ArrayList list = new ArrayList();
        int i = 0;
        while ((long)i < count) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Value res = v.getArrayElement((long)i);
            map.put(key, res.as(Object.class));
            list.add(map);
            ++i;
        }
        return new JsList(list);
    }

    public Object match(Value actual, Value expected) {
        Match.Result mr = this.getEngine().match(Match.Type.EQUALS, JsValue.toJava(actual), JsValue.toJava(expected));
        return JsValue.fromJava(mr.toMap());
    }

    public Object match(String exp) {
        MatchStep ms = new MatchStep(exp);
        Match.Result mr = this.getEngine().match(ms.type, ms.name, ms.path, ms.expected);
        return JsValue.fromJava(mr.toMap());
    }

    public Object merge(Value ... vals) {
        if (vals.length == 0) {
            return null;
        }
        if (vals.length == 1) {
            return vals[0];
        }
        HashMap map = new HashMap((Map)vals[0].as(Map.class));
        for (int i = 1; i < vals.length; ++i) {
            map.putAll((Map)vals[i].as(Map.class));
        }
        return new JsMap(map);
    }

    public void pause(Value value) {
        ScenarioEngine engine = this.getEngine();
        if (!value.isNumber()) {
            engine.logger.warn("pause argument is not a number:", value);
            return;
        }
        if (engine.runtime.perfMode) {
            engine.runtime.featureRuntime.perfHook.pause(value.asInt());
        } else if (engine.getConfig().isPauseIfNotPerf()) {
            try {
                Thread.sleep(value.asInt());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String pretty(Object o) {
        Variable v = new Variable(o);
        return v.getAsPrettyString();
    }

    public String prettyXml(Object o) {
        Variable v = new Variable(o);
        return v.getAsPrettyXmlString();
    }

    public void proceed() {
        this.proceed(null);
    }

    public void proceed(String requestUrlBase) {
        this.getEngine().mockProceed(requestUrlBase);
    }

    public Object range(int start, int end) {
        return this.range(start, end, 1);
    }

    public Object range(int start, int end, int interval) {
        if (interval <= 0) {
            throw new RuntimeException("interval must be a positive integer");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (start <= end) {
            for (int i = start; i <= end; i += interval) {
                list.add(i);
            }
        } else {
            for (int i = start; i >= end; i -= interval) {
                list.add(i);
            }
        }
        return JsValue.fromJava(list);
    }

    public Object read(String path) {
        Object result = this.getEngine().fileReader.readFile(path);
        return JsValue.fromJava(result);
    }

    public byte[] readAsBytes(String path) {
        return this.getEngine().fileReader.readFileAsBytes(path);
    }

    public String readAsString(String path) {
        return this.getEngine().fileReader.readFileAsString(path);
    }

    public InputStream readAsStream(String path) {
        return this.getEngine().fileReader.readFileAsStream(path);
    }

    public void remove(String name, String path) {
        this.getEngine().remove(name, path);
    }

    public String render(Value v) {
        Map<String, Object> arg;
        if (v.isString()) {
            arg = Collections.singletonMap("read", v.asString());
        } else if (v.hasMembers()) {
            arg = new JsValue(v).getAsMap();
        } else {
            this.getEngine().logger.warn("render - unexpected argument: {}", v);
            return null;
        }
        return this.getEngine().renderHtml(arg);
    }

    public Object repeat(int n, Value f) {
        ScenarioBridge.assertIfJsFunction(f);
        ArrayList list = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Value v = JsEngine.execute(f, i);
            list.add(new JsValue(v).getValue());
        }
        return new JsList(list);
    }

    public void set(Map<String, Object> map) {
        this.getEngine().setVariables(map);
    }

    public void set(String name, Value value) {
        this.getEngine().setVariable(name, new Variable(value));
    }

    public void set(String name, String path, Object value) {
        this.getEngine().set(name, path, new Variable(value));
    }

    public Object setup() {
        return this.setup(null);
    }

    public Object setup(String name) {
        Map<String, Object> result = ScenarioBridge.setupInternal(this.getEngine(), name);
        return JsValue.fromJava(result);
    }

    private static Map<String, Object> setupInternal(ScenarioEngine engine, String name) {
        Feature feature = engine.runtime.featureRuntime.featureCall.feature;
        Scenario scenario = feature.getSetup(name);
        if (scenario == null) {
            Object message = "no scenario found with @setup tag";
            if (name != null) {
                message = (String)message + " and name '" + name + "'";
            }
            engine.logger.error((String)message, new Object[0]);
            throw new RuntimeException((String)message);
        }
        ScenarioRuntime sr = new ScenarioRuntime(engine.runtime.featureRuntime, scenario);
        sr.setSkipBackground(true);
        sr.run();
        ScenarioEngine.set(engine);
        engine.runtime.featureRuntime.setupResult = sr.result;
        return sr.engine.getAllVariablesAsMap();
    }

    public Object setupOnce() {
        return this.setupOnce(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setupOnce(String name) {
        ScenarioEngine engine = this.getEngine();
        Map<String, Map<String, Object>> CACHE = engine.runtime.featureRuntime.SETUPONCE_CACHE;
        Map<String, Object> result = CACHE.get(name);
        if (result != null) {
            return ScenarioBridge.setupOnceResult(result);
        }
        long startTime = System.currentTimeMillis();
        engine.logger.trace("setupOnce waiting for lock: {}", name);
        Map<String, Map<String, Object>> map = CACHE;
        synchronized (map) {
            result = CACHE.get(name);
            if (result != null) {
                long endTime = System.currentTimeMillis() - startTime;
                engine.logger.warn("this thread waited {} milliseconds for setupOnce lock: {}", endTime, name);
                return ScenarioBridge.setupOnceResult(result);
            }
            result = ScenarioBridge.setupInternal(engine, name);
            CACHE.put(name, result);
            return ScenarioBridge.setupOnceResult(result);
        }
    }

    private static Object setupOnceResult(Map<String, Object> result) {
        HashMap clone = new HashMap(result.size());
        result.forEach((k, v) -> {
            Variable variable = new Variable(v);
            clone.put(k, variable.copy(false).getValue());
        });
        return JsValue.fromJava(clone);
    }

    public void setXml(String name, String xml) {
        this.getEngine().setVariable(name, XmlUtils.toXmlDoc(xml));
    }

    public void setXml(String name, String path, String xml) {
        this.getEngine().set(name, path, new Variable(XmlUtils.toXmlDoc(xml)));
    }

    public void signal(Value v) {
        this.getEngine().signal(JsValue.toJava(v));
    }

    public Object sizeOf(Object o) {
        Variable v = new Variable(o);
        if (v.isList()) {
            return ((List)v.getValue()).size();
        }
        if (v.isMap()) {
            return ((Map)v.getValue()).size();
        }
        if (v.isBytes()) {
            return ((byte[])v.getValue()).length;
        }
        return -1;
    }

    public Object sort(Value o) {
        return this.sort(o, this.getEngine().JS.evalForValue("x => x"));
    }

    public Object sort(Value o, Value f) {
        if (!o.hasArrayElements()) {
            return JsList.EMPTY;
        }
        ScenarioBridge.assertIfJsFunction(f);
        long count = o.getArraySize();
        ArrayList<ValueIndex> pointers = new ArrayList<ValueIndex>((int)count);
        ArrayList<Object> items = new ArrayList<Object>(pointers.size());
        int i = 0;
        while ((long)i < count) {
            Object item2 = JsValue.toJava(o.getArrayElement((long)i));
            items.add(item2);
            Value key = JsEngine.execute(f, item2, i);
            if (key.isNumber()) {
                pointers.add(new NumberValueIndex((Number)key.as(Number.class), (long)i));
            } else {
                pointers.add(new StringValueIndex(key.asString(), (long)i));
            }
            ++i;
        }
        Collections.sort(pointers);
        ArrayList result = new ArrayList(pointers.size());
        pointers.forEach(item -> result.add(items.get((int)item.index)));
        return JsValue.fromJava(result);
    }

    public MockServer start(Value value) {
        if (value.isString()) {
            return this.startInternal(Collections.singletonMap("mock", value.asString()));
        }
        return this.startInternal(new JsValue(value).getAsMap());
    }

    private MockServer startInternal(Map<String, Object> config) {
        Integer port;
        Boolean ssl;
        String keyFile;
        String certFile;
        String mock = (String)config.get("mock");
        if (mock == null) {
            throw new RuntimeException("'mock' is missing: " + config);
        }
        File feature = this.toJavaFile(mock);
        MockServer.Builder builder = MockServer.feature(feature);
        String pathPrefix = (String)config.get("pathPrefix");
        if (pathPrefix != null) {
            builder.pathPrefix(pathPrefix);
        }
        if ((certFile = (String)config.get("cert")) != null) {
            builder.certFile(this.toJavaFile(certFile));
        }
        if ((keyFile = (String)config.get("key")) != null) {
            builder.keyFile(this.toJavaFile(keyFile));
        }
        if ((ssl = (Boolean)config.get("ssl")) == null) {
            ssl = false;
        }
        if ((port = (Integer)config.get("port")) == null) {
            port = 0;
        }
        Map arg = (Map)config.get("arg");
        builder.args(arg);
        if (ssl.booleanValue()) {
            builder.https(port);
        } else {
            builder.http(port);
        }
        return builder.build();
    }

    public void stop(int port) {
        Command.waitForSocket(port);
    }

    public String toAbsolutePath(String relativePath) {
        return this.getEngine().fileReader.toAbsolutePath(relativePath);
    }

    public Object toBean(Object o, String className) {
        Json json = Json.of(o);
        Object bean = JsonUtils.fromJson(json.toString(), className);
        return JsValue.fromJava(bean);
    }

    public String toCsv(Object o) {
        Variable v = new Variable(o);
        if (!v.isList()) {
            throw new RuntimeException("not a json array: " + v);
        }
        List list = (List)v.getValue();
        return JsonUtils.toCsv(list);
    }

    public Object toJava(Value value) {
        return new JsValue(value).getValue();
    }

    public File toJavaFile(String path) {
        return this.getEngine().fileReader.toResource(path).getFile();
    }

    public Object toJs(Object value) {
        return JsValue.fromJava(value);
    }

    public Object toJson(Value value) {
        return this.toJson(value, false);
    }

    public Object toJson(Value value, boolean removeNulls) {
        JsValue jv = new JsValue(value);
        String json = JsonUtils.toJson(jv.getValue());
        Object result = Json.of(json).value();
        if (removeNulls) {
            JsonUtils.removeKeysWithNullValues(result);
        }
        return JsValue.fromJava(result);
    }

    public Object toList(Value value) {
        return new JsValue(value).getValue();
    }

    public Object toMap(Value value) {
        return new JsValue(value).getValue();
    }

    public String toString(Object o) {
        Variable v = new Variable(o);
        return v.getAsString();
    }

    public String typeOf(Value value) {
        Variable v = new Variable(value);
        return v.getTypeString();
    }

    public String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            this.getEngine().logger.warn("url encode failed: {}", e.getMessage());
            return s;
        }
    }

    public String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            this.getEngine().logger.warn("url encode failed: {}", e.getMessage());
            return s;
        }
    }

    public Object valuesOf(Object o) {
        Variable v = new Variable(o);
        if (v.isList()) {
            return new JsList((List)v.getValue());
        }
        if (v.isMap()) {
            return new JsList(((Map)v.getValue()).values());
        }
        return null;
    }

    public boolean waitForHttp(String url) {
        return Command.waitForHttp(url);
    }

    public boolean waitForPort(String host, int port) {
        return new Command(new String[0]).waitForPort(host, port);
    }

    public WebSocketClient webSocket(String url) {
        return this.webSocket(url, null, null);
    }

    public WebSocketClient webSocket(String url, Value value) {
        return this.webSocket(url, value, null);
    }

    public WebSocketClient webSocket(String url, Value listener, Value value) {
        ScenarioEngine engine = this.getEngine();
        JsLambda handler = listener == null || !listener.canExecute() ? m -> true : new JsLambda(listener);
        WebSocketOptions options = new WebSocketOptions(url, value == null ? null : (Map)new JsValue(value).getValue());
        options.setTextHandler(handler);
        return engine.webSocket(options);
    }

    public WebSocketClient webSocketBinary(String url) {
        return this.webSocketBinary(url, null, null);
    }

    public WebSocketClient webSocketBinary(String url, Value value) {
        return this.webSocketBinary(url, value, null);
    }

    public WebSocketClient webSocketBinary(String url, Value listener, Value value) {
        ScenarioEngine engine = this.getEngine();
        JsLambda handler = listener == null || !listener.canExecute() ? m -> true : new JsLambda(listener);
        WebSocketOptions options = new WebSocketOptions(url, value == null ? null : (Map)new JsValue(value).getValue());
        options.setBinaryHandler(handler);
        return engine.webSocket(options);
    }

    public Object wrapFunction(Value value) {
        Proxy o;
        if (value.isProxyObject() && (o = value.asProxyObject()) instanceof JsFunction) {
            JsFunction fun = (JsFunction)o;
            return JsFunction.wrap(fun.getValue());
        }
        if (value.canExecute()) {
            return JsFunction.wrap(value);
        }
        throw new RuntimeException("js function expected");
    }

    public File write(Object o, String path) {
        ScenarioEngine engine = this.getEngine();
        path = engine.runtime.featureRuntime.suite.buildDir + File.separator + (String)path;
        File file = new File((String)path);
        FileUtils.writeToFile(file, JsonUtils.toBytes(o));
        engine.logger.debug("write to file: {}", file);
        return file;
    }

    public Object xmlPath(Object o, String path) {
        Variable var = new Variable(o);
        Variable res = ScenarioEngine.evalXmlPath(var, path);
        return JsValue.fromJava(res.getValue());
    }

    private static void assertIfJsFunction(Value f) {
        if (!f.canExecute()) {
            throw new RuntimeException("not a js function: " + f);
        }
    }

    public static class LogFacade {
        private static Logger getLogger() {
            return ScenarioEngine.get().logger;
        }

        private static String wrap(Value ... values) {
            return new LogWrapper(values).toString();
        }

        public void debug(Value ... values) {
            LogFacade.getLogger().debug(LogFacade.wrap(values), new Object[0]);
        }

        public void info(Value ... values) {
            LogFacade.getLogger().info(LogFacade.wrap(values), new Object[0]);
        }

        public void trace(Value ... values) {
            LogFacade.getLogger().trace(LogFacade.wrap(values), new Object[0]);
        }

        public void warn(Value ... values) {
            LogFacade.getLogger().warn(LogFacade.wrap(values), new Object[0]);
        }

        public void error(Value ... values) {
            LogFacade.getLogger().error(LogFacade.wrap(values), new Object[0]);
        }
    }

    static class LogWrapper {
        final Value[] values;

        LogWrapper(Value ... values) {
            this.values = values == null ? new Value[]{} : values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Value v : this.values) {
                Variable var = new Variable(v);
                sb.append(var.getAsPrettyString()).append(' ');
            }
            return sb.toString();
        }
    }

    static class NumberValueIndex
    extends ValueIndex<Number> {
        public NumberValueIndex(Number o, long index) {
            super(o, index);
        }

        @Override
        public int compareTo(ValueIndex<Number> other) {
            double result = ((Number)this.object).doubleValue() - ((Number)other.object).doubleValue();
            return result == 0.0 ? (int)(this.index - other.index) : (int)result;
        }
    }

    static class StringValueIndex
    extends ValueIndex<String> {
        public StringValueIndex(String o, long index) {
            super(o, index);
        }

        @Override
        public int compareTo(ValueIndex<String> other) {
            int result = ((String)this.object).compareTo((String)other.object);
            return result == 0 ? (int)(this.index - other.index) : result;
        }
    }

    static abstract class ValueIndex<T>
    implements Comparable<ValueIndex<T>> {
        final T object;
        final long index;

        ValueIndex(T o, long index) {
            this.object = o;
            this.index = index;
        }
    }
}

