/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Config;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpLogger;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.Response;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.DecoratingHttpClientFunction;
import karate.com.linecorp.armeria.client.WebClient;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.RequestHeadersBuilder;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.server.ServiceRequestContext;

public class ArmeriaHttpClient
implements HttpClient,
DecoratingHttpClientFunction {
    private final Logger logger;
    private final HttpLogger httpLogger;
    private Config config;
    private HttpRequest request;
    private RequestContext requestContext;

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public ArmeriaHttpClient(Config config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.httpLogger = new HttpLogger(logger);
    }

    @Override
    public Response invoke(HttpRequest request) {
        AggregatedHttpResponse ahr;
        this.request = request;
        HttpMethod httpMethod = HttpMethod.valueOf(request.getMethod());
        StringUtils.Pair urlAndPath = HttpUtils.parseUriIntoUrlBaseAndPath(request.getUrl());
        WebClient webClient = WebClient.builder(urlAndPath.left).decorator(this).build();
        RequestHeadersBuilder rhb = RequestHeaders.builder(httpMethod, urlAndPath.right);
        Map<String, List<String>> headers = request.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> rhb.add((CharSequence)k, (Iterable)v));
        }
        byte[] body = request.getBody() == null ? Constants.ZERO_BYTES : request.getBody();
        Callable<AggregatedHttpResponse> callable = () -> webClient.execute(rhb.build(), body).aggregate().join();
        ServiceRequestContext src = this.requestContext == null ? null : this.requestContext.root();
        try {
            if (src == null) {
                ahr = callable.call();
            } else {
                Future<AggregatedHttpResponse> future = src.blockingTaskExecutor().submit(callable);
                ahr = future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ResponseHeaders rh = ahr.headers();
        LinkedHashMap<String, List<String>> responseHeaders = new LinkedHashMap<String, List<String>>(rh.size());
        for (CharSequence charSequence : rh.names()) {
            if (HttpHeaderNames.STATUS.equals(charSequence)) continue;
            responseHeaders.put(charSequence.toString(), rh.getAll(charSequence));
        }
        byte[] responseBody = ahr.content().isEmpty() ? Constants.ZERO_BYTES : ahr.content().array();
        Response response = new Response(ahr.status().code(), responseHeaders, responseBody);
        this.httpLogger.logResponse(this.config, request, response);
        return response;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public HttpResponse execute(karate.com.linecorp.armeria.client.HttpClient delegate, ClientRequestContext ctx, karate.com.linecorp.armeria.common.HttpRequest req) throws Exception {
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_HEADERS).thenAccept(log -> {
            this.request.setStartTime(log.requestStartTimeMillis());
            RequestHeaders rh = log.requestHeaders();
            for (CharSequence charSequence : rh.names()) {
                if (charSequence.charAt(0) == ':') continue;
                this.request.putHeader(charSequence.toString(), rh.getAll(charSequence));
            }
            this.httpLogger.logRequest(this.config, this.request);
        });
        ctx.log().whenAvailable(RequestLogProperty.RESPONSE_START_TIME).thenAccept(log -> this.request.setEndTime(log.responseStartTimeMillis()));
        return delegate.execute(ctx, req);
    }
}

