/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import karate.com.linecorp.armeria.common.AggregatedHttpRequest;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.ResponseHeadersBuilder;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.io.netty.util.AsciiString;

public class HttpServerHandler
implements HttpService {
    private final ServerHandler handler;

    public HttpServerHandler(ServerHandler handler) {
        this.handler = handler;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from((CompletableFuture<? extends HttpResponse>)req.aggregate().thenApply(ahr -> {
            Request request = this.toRequest(ctx, (AggregatedHttpRequest)ahr);
            Response response = this.handler.handle(request);
            return this.toResponse(ctx, response);
        }));
    }

    private Request toRequest(ServiceRequestContext ctx, AggregatedHttpRequest req) {
        Request request = new Request();
        request.setRequestContext(ctx);
        request.setUrl(req.path());
        request.setUrlBase(req.scheme() + "://" + req.authority());
        request.setMethod(req.method().name());
        RequestHeaders rh = req.headers();
        if (rh != null) {
            Set<AsciiString> names = rh.names();
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(names.size());
            request.setHeaders(headers);
            for (AsciiString name : names) {
                if (name.charAt(0) == ':') continue;
                headers.put(name.toString(), rh.getAll(name));
            }
        }
        if (!req.content().isEmpty()) {
            byte[] bytes = req.content().array();
            request.setBody(bytes);
        }
        return request;
    }

    private HttpResponse toResponse(ServiceRequestContext ctx, Response response) {
        byte[] body = response.getBody();
        if (body == null) {
            body = Constants.ZERO_BYTES;
        }
        ResponseHeadersBuilder rhb = ResponseHeaders.builder(response.getStatus());
        Map<String, List<String>> headers = response.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> rhb.add((CharSequence)k, (Iterable)v));
        }
        HttpResponse hr = HttpResponse.of(rhb.build(), HttpData.wrap(body));
        if (response.getDelay() > 0) {
            return HttpResponse.delayed(hr, Duration.ofMillis(response.getDelay()), (ScheduledExecutorService)ctx.eventLoop());
        }
        return hr;
    }
}

