/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.LenientTrustManager;
import com.intuit.karate.http.ProxyContext;
import com.intuit.karate.http.cert.SelfSignedCertGenerator;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelFutureListener;
import karate.io.netty.handler.codec.http.DefaultFullHttpResponse;
import karate.io.netty.handler.codec.http.FullHttpResponse;
import karate.io.netty.handler.codec.http.HttpHeaderNames;
import karate.io.netty.handler.codec.http.HttpMessage;
import karate.io.netty.handler.codec.http.HttpRequest;
import karate.io.netty.handler.codec.http.HttpResponseStatus;
import karate.io.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final String PROXY_ALIAS = "karate-proxy";
    private static final String KEYSTORE_PASSWORD = "karate-secret";
    private static final String KEYSTORE_FILENAME = "karate-proxy.jks";
    private static final HttpResponseStatus CONNECTION_ESTABLISHED = new HttpResponseStatus(200, "Connection established");

    private HttpUtils() {
    }

    public static Charset parseContentTypeCharset(String mimeType) {
        Map<String, String> map = HttpUtils.parseContentTypeParams(mimeType);
        if (map == null) {
            return null;
        }
        String cs = map.get("charset");
        if (cs == null) {
            return null;
        }
        return Charset.forName(cs);
    }

    public static Map<String, String> parseContentTypeParams(String mimeType) {
        List<String> items = StringUtils.split(mimeType, ';', false);
        int count = items.size();
        if (count <= 1) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(count - 1);
        for (int i = 1; i < count; ++i) {
            String item = items.get(i);
            int pos = item.indexOf(61);
            if (pos == -1) continue;
            String key = item.substring(0, pos).trim();
            String val = item.substring(pos + 1).trim();
            map.put(key, val);
        }
        return map;
    }

    public static Map<String, String> parseUriPattern(String pattern, String url) {
        int qpos = url.indexOf(63);
        if (qpos != -1) {
            url = url.substring(0, qpos);
        }
        List<String> leftList = StringUtils.split(pattern, '/', false);
        List<String> rightList = StringUtils.split(url, '/', false);
        int leftSize = leftList.size();
        int rightSize = rightList.size();
        if (rightSize != leftSize) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(leftSize);
        for (int i = 0; i < leftSize; ++i) {
            String right;
            String left = leftList.get(i);
            if (left.equals(right = rightList.get(i))) continue;
            if (left.startsWith("{") && left.endsWith("}")) {
                left = left.substring(1, left.length() - 1);
                map.put(left, right);
                continue;
            }
            return null;
        }
        return map;
    }

    public static String normaliseUriPath(String uri) {
        Object object = uri = ((String)uri).indexOf(63) == -1 ? uri : ((String)uri).substring(0, ((String)uri).indexOf(63));
        if (((String)uri).endsWith("/")) {
            uri = ((String)uri).substring(0, ((String)uri).length() - 1);
        }
        if (!((String)uri).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        return uri;
    }

    public static StringUtils.Pair parseUriIntoUrlBaseAndPath(String rawUri) {
        URI uri;
        int pos = rawUri.indexOf(47);
        if (pos == -1) {
            return StringUtils.pair(null, "");
        }
        try {
            uri = new URI(rawUri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (uri.getHost() == null) {
            return StringUtils.pair(null, rawUri);
        }
        String path = uri.getRawPath();
        pos = rawUri.lastIndexOf(path);
        String urlBase = rawUri.substring(0, pos);
        return StringUtils.pair(urlBase, rawUri.substring(pos));
    }

    public static void flushAndClose(Channel ch) {
        if (ch != null && ch.isActive()) {
            ch.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public static void createSelfSignedCertificate(File cert, File key) {
        try {
            SelfSignedCertGenerator ssc = new SelfSignedCertGenerator();
            FileUtils.copy(ssc.getCertificate(), cert);
            FileUtils.copy(ssc.getPrivateKey(), key);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static SSLContext getSslContext(File keyStoreFile) {
        keyStoreFile = HttpUtils.initKeyStore(keyStoreFile);
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keyStoreFile), KEYSTORE_PASSWORD.toCharArray());
            TrustManager[] trustManagers = new TrustManager[]{LenientTrustManager.INSTANCE};
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, KEYSTORE_PASSWORD.toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(keyManagers, trustManagers, null);
            return ctx;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File initKeyStore(File keyStoreFile) {
        if (keyStoreFile == null) {
            keyStoreFile = new File(KEYSTORE_FILENAME);
        }
        if (keyStoreFile.exists()) {
            if (logger.isTraceEnabled()) {
                logger.trace("keystore file already exists: {}", (Object)keyStoreFile);
            }
            return keyStoreFile;
        }
        File parentFile = keyStoreFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        Command.exec(false, parentFile, "keytool", "-genkey", "-alias", PROXY_ALIAS, "-keysize", "4096", "-validity", "36500", "-keyalg", "RSA", "-dname", "CN=karate-proxy", "-keypass", KEYSTORE_PASSWORD, "-storepass", KEYSTORE_PASSWORD, "-keystore", keyStoreFile.getName());
        Command.exec(false, parentFile, "keytool", "-exportcert", "-alias", PROXY_ALIAS, "-keystore", keyStoreFile.getName(), "-storepass", KEYSTORE_PASSWORD, "-file", keyStoreFile.getName() + ".der");
        return keyStoreFile;
    }

    public static FullHttpResponse createResponse(int status, String body) {
        return HttpUtils.createResponse(HttpResponseStatus.valueOf(status), body);
    }

    public static FullHttpResponse createResponse(HttpResponseStatus status, String body) {
        byte[] bytes = FileUtils.toBytes(body);
        ByteBuf bodyBuf = Unpooled.copiedBuffer(bytes);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, bodyBuf);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        return response;
    }

    public static FullHttpResponse transform(FullHttpResponse original, String body) {
        FullHttpResponse response = HttpUtils.createResponse(original.status(), body);
        response.headers().set(original.headers());
        return response;
    }

    public static FullHttpResponse connectionEstablished() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, CONNECTION_ESTABLISHED);
    }

    public static void fixHeadersForProxy(HttpRequest request) {
        String adjustedUri = ProxyContext.removeHostColonPort(request.uri());
        request.setUri(adjustedUri);
        request.headers().remove(HttpHeaderNames.CONNECTION);
    }

    public static void addViaHeader(HttpMessage msg, String alias) {
        List<String> list;
        StringBuilder sb = new StringBuilder();
        sb.append(msg.protocolVersion().majorVersion()).append('.');
        sb.append(msg.protocolVersion().minorVersion()).append(' ');
        sb.append(alias);
        if (msg.headers().contains(HttpHeaderNames.VIA)) {
            List<String> existing = msg.headers().getAll(HttpHeaderNames.VIA);
            list = new ArrayList<String>(existing);
            list.add(sb.toString());
        } else {
            list = Collections.singletonList(sb.toString());
        }
        msg.headers().set((CharSequence)HttpHeaderNames.VIA, list);
    }
}

