/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.ProxyContext;
import com.intuit.karate.http.ProxyRemoteHandler;
import com.intuit.karate.http.RequestFilter;
import com.intuit.karate.http.ResponseFilter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import karate.io.netty.bootstrap.Bootstrap;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelFuture;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.SimpleChannelInboundHandler;
import karate.io.netty.channel.nio.NioEventLoopGroup;
import karate.io.netty.channel.socket.nio.NioSocketChannel;
import karate.io.netty.handler.codec.http.FullHttpRequest;
import karate.io.netty.handler.codec.http.FullHttpResponse;
import karate.io.netty.handler.codec.http.HttpClientCodec;
import karate.io.netty.handler.codec.http.HttpContentDecompressor;
import karate.io.netty.handler.codec.http.HttpHeaderNames;
import karate.io.netty.handler.codec.http.HttpHeaderValues;
import karate.io.netty.handler.codec.http.HttpMethod;
import karate.io.netty.handler.codec.http.HttpObjectAggregator;
import karate.io.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyClientHandler.class);
    protected final RequestFilter requestFilter;
    protected final ResponseFilter responseFilter;
    private final Map<String, ProxyRemoteHandler> REMOTE_HANDLERS = new ConcurrentHashMap<String, ProxyRemoteHandler>();
    private final Object LOCK = new Object();
    private ProxyRemoteHandler remoteHandler;
    protected Channel clientChannel;

    public ProxyClientHandler(RequestFilter requestFilter, ResponseFilter responseFilter) {
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.clientChannel = ctx.channel();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, final FullHttpRequest request) throws Exception {
        final boolean isConnect = HttpMethod.CONNECT.equals(request.method());
        final ProxyContext pc = new ProxyContext(request, isConnect);
        if (this.remoteHandler == null && !isConnect) {
            this.remoteHandler = this.REMOTE_HANDLERS.get(pc.hostColonPort);
        }
        if (this.remoteHandler != null) {
            this.remoteHandler.send(request);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(">> init: {} - {}", (Object)pc, (Object)request);
        }
        Bootstrap b = new Bootstrap();
        b.group(new NioEventLoopGroup(4));
        b.channel(NioSocketChannel.class);
        b.handler(new ChannelInitializer(){

            protected void initChannel(Channel remoteChannel) throws Exception {
                ChannelPipeline p = remoteChannel.pipeline();
                if (isConnect) {
                    SSLContext sslContext = HttpUtils.getSslContext(null);
                    SSLEngine remoteSslEngine = sslContext.createSSLEngine(pc.host, pc.port);
                    remoteSslEngine.setUseClientMode(true);
                    remoteSslEngine.setNeedClientAuth(false);
                    SslHandler remoteSslHandler = new SslHandler(remoteSslEngine);
                    p.addLast(remoteSslHandler);
                    remoteSslHandler.handshakeFuture().addListener(rhf -> {
                        if (logger.isTraceEnabled()) {
                            logger.trace("** ssl: server handshake done: {}", (Object)remoteChannel);
                        }
                        SSLEngine clientSslEngine = sslContext.createSSLEngine();
                        clientSslEngine.setUseClientMode(false);
                        clientSslEngine.setNeedClientAuth(false);
                        SslHandler clientSslHandler = new SslHandler(clientSslEngine);
                        FullHttpResponse response = HttpUtils.connectionEstablished();
                        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                        ProxyClientHandler.this.clientChannel.eventLoop().execute(() -> {
                            ProxyClientHandler.this.clientChannel.writeAndFlush(response);
                            ProxyClientHandler.this.clientChannel.pipeline().addFirst(clientSslHandler);
                        });
                        clientSslHandler.handshakeFuture().addListener(chf -> {
                            if (logger.isTraceEnabled()) {
                                logger.trace("** ssl: client handshake done: {}", (Object)ProxyClientHandler.this.clientChannel);
                            }
                            ProxyClientHandler.this.unlockAndProceed();
                        });
                        ProxyClientHandler.this.lockAndWait();
                    });
                }
                p.addLast(new HttpClientCodec());
                p.addLast(new HttpContentDecompressor());
                p.addLast(new HttpObjectAggregator(0x100000));
                ProxyClientHandler.this.remoteHandler = new ProxyRemoteHandler(pc, ProxyClientHandler.this, isConnect ? null : request);
                ProxyClientHandler.this.REMOTE_HANDLERS.put(pc.hostColonPort, ProxyClientHandler.this.remoteHandler);
                p.addLast(ProxyClientHandler.this.remoteHandler);
                if (logger.isTraceEnabled()) {
                    logger.trace("updated remote handlers: {}", ProxyClientHandler.this.REMOTE_HANDLERS);
                }
            }
        });
        ChannelFuture cf = b.connect(pc.host, pc.port);
        cf.addListener(future -> {
            if (future.isSuccess()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("** ready: {} - {}", (Object)pc, (Object)cf.channel());
                }
            } else {
                HttpUtils.flushAndClose(this.clientChannel);
            }
        });
        if (!isConnect) {
            this.lockAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndWait() throws Exception {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAndProceed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            logger.error("closing proxy inbound connection: {}", (Object)cause.getMessage());
        }
        ctx.close();
        HttpUtils.flushAndClose(this.remoteHandler.remoteChannel);
    }
}

