/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.StringUtils;
import java.util.List;
import karate.io.netty.handler.codec.http.HttpHeaderNames;
import karate.io.netty.handler.codec.http.HttpRequest;

public class ProxyContext {
    public final String host;
    public final int port;
    public final boolean ssl;
    public final String hostColonPort;
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;

    public ProxyContext(HttpRequest request, boolean ssl) {
        this(ProxyContext.getHostColonPortFromHeader(request), ssl);
    }

    public ProxyContext(String raw, boolean ssl) {
        this.ssl = ssl;
        raw = ProxyContext.extractHostColonPort(raw);
        int pos = raw.indexOf(58);
        if (pos != -1) {
            this.host = raw.substring(0, pos);
            this.port = ProxyContext.parsePort(raw.substring(pos + 1), ssl);
        } else {
            this.host = raw;
            this.port = ssl ? 443 : 80;
        }
        this.hostColonPort = this.host + ":" + this.port;
    }

    public String toString() {
        return (this.ssl ? "https" : "http") + "://" + this.host + ":" + this.port;
    }

    private static int parsePort(String raw, boolean ssl) {
        try {
            return Integer.valueOf(raw);
        }
        catch (Exception e) {
            return ssl ? 443 : 80;
        }
    }

    private static String getHostColonPortFromHeader(HttpRequest request) {
        List<String> hosts;
        String hostColonPort = ProxyContext.extractHostColonPort(request.uri());
        if (StringUtils.isBlank(hostColonPort) && (hosts = request.headers().getAll(HttpHeaderNames.HOST)) != null && !hosts.isEmpty()) {
            hostColonPort = hosts.get(0);
        }
        return hostColonPort;
    }

    private static String extractHostColonPort(String uri) {
        int pos = uri.indexOf(47);
        if (pos == -1) {
            return uri;
        }
        if (uri.startsWith("http") && pos < 7) {
            uri = uri.substring(pos + 2);
        }
        if ((pos = uri.indexOf(47)) == -1) {
            return uri;
        }
        return uri.substring(0, pos);
    }

    public static String removeHostColonPort(String uri) {
        if (!uri.startsWith("http")) {
            return uri;
        }
        int pos = (uri = uri.substring(uri.indexOf(47) + 2)).indexOf("/");
        if (pos == -1) {
            return "/";
        }
        return uri.substring(pos);
    }
}

