/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.ProxyClientHandler;
import com.intuit.karate.http.RequestFilter;
import com.intuit.karate.http.ResponseFilter;
import java.net.InetSocketAddress;
import karate.io.netty.bootstrap.ServerBootstrap;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.channel.nio.NioEventLoopGroup;
import karate.io.netty.channel.socket.nio.NioServerSocketChannel;
import karate.io.netty.handler.codec.http.HttpObjectAggregator;
import karate.io.netty.handler.codec.http.HttpServerCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    private static final Logger logger = LoggerFactory.getLogger(ProxyServer.class);
    private final Channel channel;
    private final int port;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup(8);

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    public ProxyServer(int requestedPort, final RequestFilter requestFilter, final ResponseFilter responseFilter) {
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new HttpServerCodec());
                    p.addLast(new HttpObjectAggregator(0x100000));
                    p.addLast(new ProxyClientHandler(requestFilter, responseFilter));
                }
            });
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            String host = "127.0.0.1";
            this.port = isa.getPort();
            logger.info("proxy server started - http://{}:{}", (Object)host, (Object)this.port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

