/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsArray;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.graal.Methods;
import com.intuit.karate.http.Cookies;
import com.intuit.karate.http.ResourceType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import karate.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import karate.io.netty.handler.codec.http.cookie.Cookie;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
implements ProxyObject {
    private static final Logger logger = LoggerFactory.getLogger(Response.class);
    public static final Response OK = new Response(200);
    private static final String BODY = "body";
    private static final String BODY_BYTES = "bodyBytes";
    private static final String STATUS = "status";
    private static final String HEADER = "header";
    private static final String HEADERS = "headers";
    private static final String HEADER_VALUES = "headerValues";
    private static final String DATA_TYPE = "dataType";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String[] KEYS = new String[]{"status", "header", "headers", "headerValues", "body", "dataType", "bodyBytes", "responseTime"};
    private static final Set<String> KEY_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final JsArray KEY_ARRAY = new JsArray(KEYS);
    private int status;
    private Map<String, List<String>> headers;
    private Object body;
    private ResourceType resourceType;
    private int delay;
    private long responseTime;
    private final Methods.FunVar HEADER_FUNCTION = args -> {
        if (args.length == 1) {
            return this.getHeader(Response.toString(args[0]));
        }
        this.setHeader(Response.toString(args[0]), Response.toString(args[1]));
        return this;
    };

    public Response(int status) {
        this.status = status;
    }

    public Response(int status, Map<String, List<String>> headers, byte[] body) {
        this(status, headers, body, null);
    }

    public Response(int status, Map<String, List<String>> headers, byte[] body, ResourceType resourceType) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.resourceType = resourceType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getHeadersWithLowerCaseNames() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.headers.size());
        this.headers.forEach((k, v) -> map.put(k.toLowerCase(), (List<String>)v));
        return map;
    }

    public Map<String, Map> getCookies() {
        List<String> values = this.getHeaderValues("Set-Cookie");
        if (values == null) {
            return null;
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        for (String value : values) {
            Cookie cookie = ClientCookieDecoder.LAX.decode(value);
            if (cookie == null) continue;
            map.put(cookie.name(), Cookies.toMap(cookie));
        }
        return map;
    }

    public byte[] getBody() {
        if (this.body instanceof byte[]) {
            return (byte[])this.body;
        }
        return JsonUtils.toBytes(this.body);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBody(String value) {
        this.body = FileUtils.toBytes(value);
    }

    public String getBodyAsString() {
        return this.body == null ? null : FileUtils.toString(this.getBody());
    }

    public Object getBodyConverted() {
        if (this.body instanceof byte[]) {
            ResourceType rt = this.getResourceType();
            if (rt != null && rt.isBinary()) {
                return this.body;
            }
            return JsonUtils.fromBytes((byte[])this.body, false, rt);
        }
        return this.body;
    }

    public Json json() {
        return this.body == null ? null : Json.of(this.getBodyConverted());
    }

    public boolean isBinary() {
        ResourceType rt = this.getResourceType();
        return rt == null ? false : rt.isBinary();
    }

    public ResourceType getResourceType() {
        String contentType;
        if (this.resourceType == null && (contentType = this.getContentType()) != null) {
            this.resourceType = ResourceType.fromContentType(contentType);
        }
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public List<String> getHeaderValues(String name) {
        return StringUtils.getIgnoreKeyCase(this.headers, name);
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaderValues(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void setHeader(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers.put(name, values);
    }

    public void setHeader(String name, String ... values) {
        this.setHeader(name, Arrays.asList(values));
    }

    public void setHeaders(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        map.forEach((k, v) -> {
            if (v instanceof List) {
                this.setHeader((String)k, (List)v);
            } else if (v != null) {
                this.setHeader((String)k, v.toString());
            }
        });
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public Object getMember(String key) {
        switch (key) {
            case "status": {
                return this.status;
            }
            case "header": {
                return this.HEADER_FUNCTION;
            }
            case "headers": {
                return JsValue.fromJava(JsonUtils.simplify(this.headers));
            }
            case "body": {
                if (this.body instanceof byte[]) {
                    return JsValue.fromJava(this.getBodyConverted());
                }
                return JsValue.fromJava(this.body);
            }
            case "dataType": {
                ResourceType rt = this.getResourceType();
                if (rt == null || rt == ResourceType.BINARY) {
                    return null;
                }
                return rt.name().toLowerCase();
            }
            case "headerValues": {
                return this::getHeaderValues;
            }
            case "bodyBytes": {
                return this.getBody();
            }
            case "responseTime": {
                return this.responseTime;
            }
        }
        logger.warn("no such property on response object: {}", (Object)key);
        return null;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATUS, this.status);
        map.put(HEADERS, JsonUtils.simplify(this.headers));
        map.put(BODY, this.getBodyConverted());
        map.put(RESPONSE_TIME, this.responseTime);
        return map;
    }

    public Object getMemberKeys() {
        return KEY_ARRAY;
    }

    public boolean hasMember(String key) {
        return KEY_SET.contains(key);
    }

    public void putMember(String key, Value value) {
        switch (key) {
            case "body": {
                this.body = JsValue.toJava(value);
                break;
            }
            case "status": {
                this.status = value.asInt();
                break;
            }
            case "headers": {
                this.setHeaders((Map)JsValue.toJava(value));
                break;
            }
            default: {
                logger.warn("put not supported on response object: {} - {}", (Object)key, (Object)value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[status: ").append(this.status);
        sb.append(", responseTime: ").append(this.responseTime);
        if (this.resourceType != null && this.resourceType != ResourceType.BINARY) {
            sb.append(", type: ").append((Object)this.resourceType);
        }
        if (this.body instanceof byte[]) {
            sb.append(", length: ").append(((byte[])this.body).length);
        }
        if (this.headers != null) {
            sb.append(", headers: ").append(this.headers);
        }
        sb.append(']');
        return sb.toString();
    }
}

