/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.core.Variable;
import com.intuit.karate.graal.JsArray;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.graal.Methods;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.RedirectException;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.RequestCycle;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.Session;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.TemplateUtils;
import java.io.File;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import karate.io.netty.handler.codec.http.cookie.Cookie;
import karate.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
implements ProxyObject {
    private static final Logger logger = LoggerFactory.getLogger(ServerContext.class);
    private static final String READ = "read";
    private static final String RESOLVER = "resolver";
    private static final String READ_AS_STRING = "readAsString";
    private static final String EVAL = "eval";
    private static final String EVAL_WITH = "evalWith";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String LOG = "log";
    private static final String UUID = "uuid";
    private static final String REMOVE = "remove";
    private static final String REDIRECT = "redirect";
    private static final String SWITCH = "switch";
    private static final String SWITCHED = "switched";
    private static final String AJAX = "ajax";
    private static final String HTTP = "http";
    private static final String NEXT_ID = "nextId";
    private static final String SESSION_ID = "sessionId";
    private static final String INIT = "init";
    private static final String CLOSE = "close";
    private static final String CLOSED = "closed";
    private static final String RENDER = "render";
    private static final String BODY_APPEND = "bodyAppend";
    private static final String COPY = "copy";
    private static final String DELAY = "delay";
    private static final String TO_STRING = "toString";
    private static final String TO_JSON = "toJson";
    private static final String TO_JS = "toJs";
    private static final String TO_JSON_PRETTY = "toJsonPretty";
    private static final String FROM_JSON = "fromJson";
    private static final String CALLER = "caller";
    private static final String TEMPLATE = "template";
    private static final String TYPE_OF = "typeOf";
    private static final String IS_PRIMITIVE = "isPrimitive";
    private static final String IS_JSON = "isJson";
    private static final String MATCH = "match";
    private static final String JOIN_PATHS = "joinPaths";
    private static final String FLASH = "flash";
    private static final String[] KEYS = new String[]{"read", "resolver", "readAsString", "eval", "evalWith", "get", "set", "log", "uuid", "remove", "redirect", "switch", "switched", "ajax", "http", "nextId", "sessionId", "init", "close", "closed", "render", "bodyAppend", "copy", "delay", "toString", "toJson", "toJs", "toJsonPretty", "fromJson", "caller", "template", "typeOf", "isPrimitive", "isJson", "match", "joinPaths", "flash"};
    private static final Set<String> KEY_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final JsArray KEY_ARRAY = new JsArray(KEYS);
    private final ServerConfig config;
    private final Request request;
    private boolean stateless;
    private boolean api;
    private boolean httpGetAllowed;
    private boolean lockNeeded;
    private boolean newSession;
    private Session session;
    private boolean switched;
    private boolean closed;
    private int nextId;
    private final Map<String, Object> variables;
    private Object flash;
    private String redirectPath;
    private List<String> bodyAppends;
    private Function<ServerContext, Boolean> requestValidator;
    private final Methods.FunVar GET_FUNCTION = args -> {
        Object value;
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        String name = args[0].toString();
        KarateEngineContext kec = KarateEngineContext.get();
        if (kec != null && kec.containsVariable(name)) {
            value = kec.getVariable(name);
        } else {
            JsEngine je = this.getEngine();
            value = je.bindings.hasMember(name) ? je.get(name).getValue() : (args.length > 1 ? args[1] : null);
        }
        return value;
    };
    private static final Supplier<String> UUID_FUNCTION = () -> java.util.UUID.randomUUID().toString();
    private static final Function<String, Object> FROM_JSON_FUNCTION = s -> JsonUtils.fromString(s, false, null);
    private final Methods.FunVar HTTP_FUNCTION;
    private final Function<Object, String> RENDER_FUNCTION;
    private final Methods.FunVar LOG_FUNCTION = args -> {
        this.log(args);
        return null;
    };
    private final Function<Object, Object> COPY_FUNCTION = o -> JsValue.fromJava(JsonUtils.deepCopy(o));
    private final Consumer<Number> DELAY_FUNCTION = v -> {
        try {
            Thread.sleep(v.longValue());
        }
        catch (Exception e) {
            logger.error("delay failed: {}", (Object)e.getMessage());
        }
    };
    private final Function<Object, Object> TO_STRING_FUNCTION = o -> {
        Variable v = new Variable(o);
        return v.getAsString();
    };
    private final Methods.FunVar SWITCH_FUNCTION = args -> {
        if (!this.switched) {
            String template;
            Value value;
            this.switched = true;
            KarateEngineContext.get().setRedirect(true);
            RequestCycle rc = RequestCycle.get();
            if (args.length > 1 && (value = Value.asValue((Object)args[1])).hasMembers()) {
                JsValue jv = new JsValue(value);
                rc.setSwitchParams(jv.getAsMap());
            }
            if (args.length > 0) {
                template = args[0].toString();
                rc.setSwitchTemplate(template);
            } else {
                template = null;
            }
            throw new RedirectException(template);
        }
        logger.warn("context.switch() can be called only once during a request, ignoring: {}", args[0]);
        return null;
    };
    private final Supplier<String> CLOSE_FUNCTION = () -> {
        this.closed = true;
        return null;
    };
    private final Supplier<Object> INIT_FUNCTION = () -> {
        this.init();
        this.getEngine().put("session", this.session.getData());
        logger.debug("init session: {}", (Object)this.session);
        return null;
    };
    private final Function<String, Object> REDIRECT_FUNCTION = path -> {
        this.redirectPath = path;
        logger.debug("redirect requested to: {}", (Object)this.redirectPath);
        return null;
    };
    private static final BiFunction<Object, Object, Object> REMOVE_FUNCTION = (o, k) -> {
        if (o instanceof Map && k != null) {
            Map in = (Map)o;
            HashMap out = new HashMap(in);
            Object removed = out.remove(k.toString());
            if (removed == null) {
                logger.warn("nothing removed, key not present: {}", k);
                return o;
            }
            return JsValue.fromJava(out);
        }
        if (o != null) {
            logger.warn("unable to cast to map: {} - {}", o.getClass(), o);
        }
        return o;
    };
    private final Supplier<String> NEXT_ID_FUNCTION = () -> ++this.nextId + "-" + System.currentTimeMillis();
    private final Function<String, Object> TYPE_OF_FUNCTION = o -> new Variable(o).getTypeString();
    private final Function<Object, Object> IS_PRIMITIVE_FUNCTION = o -> !new Variable(o).isMapOrList();
    private final Function<Object, Object> IS_JSON_FUNCTION = o -> new Variable(o).isMapOrList();
    private final Methods.FunVar MATCH_FUNCTION = args -> {
        if (args.length > 2 && args[0] != null) {
            String type = args[0].toString();
            Match.Type matchType = Match.Type.valueOf(type.toUpperCase());
            return JsValue.fromJava(Match.execute(this.getEngine(), matchType, args[1], args[2], false));
        }
        if (args.length == 2) {
            return JsValue.fromJava(Match.execute(this.getEngine(), Match.Type.EQUALS, args[0], args[1], false));
        }
        logger.warn("at least two arguments needed for match");
        return null;
    };
    private final Methods.FunVar JOIN_PATHS_FUNCTION = args -> {
        List temp = Arrays.asList(args).stream().filter(x -> x != null).map(Object::toString).collect(Collectors.toList());
        return String.join((CharSequence)File.separator, temp);
    };

    public ServerContext(ServerConfig config, Request request) {
        this(config, request, null);
    }

    public ServerContext(ServerConfig config, Request request, Map<String, Object> variables) {
        this.config = config;
        this.request = request;
        this.variables = variables;
        this.HTTP_FUNCTION = args -> {
            HttpClient client = config.getHttpClientFactory().apply(request);
            HttpRequestBuilder http = new HttpRequestBuilder(client);
            if (args.length > 0) {
                http.url((String)args[0]);
            }
            return http;
        };
        this.RENDER_FUNCTION = o -> {
            if (o instanceof String) {
                return TemplateUtils.renderHtmlResource((String)o, this.getEngine(), config.getResourceResolver(), config.isDevMode());
            }
            if (!(o instanceof Map)) {
                logger.warn("invalid argument to render: {}", o);
                return null;
            }
            Map map = (Map)o;
            Map vars = (Map)map.get("vars");
            String path = (String)map.get("path");
            String html = (String)map.get("html");
            Boolean fork = (Boolean)map.get("fork");
            Boolean append = (Boolean)map.get("append");
            if (path == null && html == null) {
                logger.warn("invalid argument to render, 'path' or 'html' needed: {}", (Object)map);
                return null;
            }
            JsEngine je = fork != null && fork != false ? JsEngine.local() : this.getEngine().copy();
            if (vars != null) {
                je.putAll(vars);
            }
            String body = path != null ? TemplateUtils.renderHtmlResource(path, je, config.getResourceResolver(), config.isDevMode()) : TemplateUtils.renderHtmlString(html, je, config.getResourceResolver());
            if (append != null && append.booleanValue()) {
                this.bodyAppend(body);
            }
            return body;
        };
    }

    public boolean setApiIfPathStartsWith(String prefix) {
        String path = this.request.getPath();
        if (path.startsWith(prefix)) {
            this.api = true;
            int length = prefix.length();
            int pos = path.indexOf(47, length);
            if (pos != -1) {
                this.request.setResourcePath(path.substring(0, pos) + ".js");
            } else {
                this.request.setResourcePath(path + ".js");
            }
            this.request.setPath(path.substring(length - 1));
            return true;
        }
        return false;
    }

    public String getSessionCookieValue() {
        List<String> values = this.request.getHeaderValues("Cookie");
        if (values == null) {
            return null;
        }
        for (String value : values) {
            Set<Cookie> cookies = ServerCookieDecoder.STRICT.decode(value);
            for (Cookie c : cookies) {
                if (!this.config.getSessionCookieName().equals(c.name())) continue;
                return c.value();
            }
        }
        return null;
    }

    public String readAsString(String resource) {
        if (((String)resource).startsWith("this:")) {
            String path;
            int pos;
            if (((String)(resource = ((String)resource).substring("this:".length()))).charAt(0) != '/') {
                resource = "/" + (String)resource;
            }
            if ((pos = (path = this.request.getResourcePath()).lastIndexOf(47)) != -1) {
                resource = path.substring(0, pos) + (String)resource;
            }
        }
        InputStream is = this.config.getResourceResolver().resolve((String)resource).getStream();
        return FileUtils.toString(is);
    }

    public Object read(String resource) {
        String raw = this.readAsString(resource);
        ResourceType resourceType = ResourceType.fromFileExtension(resource);
        if (resourceType == ResourceType.JS) {
            return this.eval(raw);
        }
        return JsValue.fromJava(JsonUtils.fromString(raw, false, resourceType));
    }

    private JsEngine getEngine() {
        KarateEngineContext kec = KarateEngineContext.get();
        return kec == null ? RequestCycle.get().getEngine() : kec.getJsEngine();
    }

    public Object eval(String source) {
        return this.getEngine().evalForValue(source);
    }

    public Object evalWith(Object o, String source) {
        Value value = Value.asValue((Object)o);
        return this.getEngine().evalWith(value, source, true);
    }

    public String toJson(Object o) {
        Value value = Value.asValue((Object)o);
        return new JsValue(value).toJsonOrXmlString(false);
    }

    public Object toJs(Object o) {
        return JsValue.fromJava(o);
    }

    public String toJsonPretty(Object o) {
        Value value = Value.asValue((Object)o);
        String pretty = new JsValue(value).toJsonOrXmlString(true);
        return pretty == null ? null : pretty.trim();
    }

    public ServerConfig getConfig() {
        return this.config;
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void init() {
        long now = Instant.now().getEpochSecond();
        long expires = now + (long)this.config.getSessionExpirySeconds();
        this.session = this.config.getSessionStore().create(now, expires);
        this.newSession = true;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isLockNeeded() {
        return this.lockNeeded;
    }

    public void setLockNeeded(boolean lockNeeded) {
        this.lockNeeded = lockNeeded;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public boolean isAjax() {
        return this.request.isAjax();
    }

    public boolean isApi() {
        return this.api;
    }

    public void setApi(boolean api) {
        this.api = api;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isHttpGetAllowed() {
        return this.httpGetAllowed;
    }

    public void setHttpGetAllowed(boolean httpGetAllowed) {
        this.httpGetAllowed = httpGetAllowed;
    }

    public void setRequestValidator(Function<ServerContext, Boolean> requestValidator) {
        this.requestValidator = requestValidator;
    }

    public Function<ServerContext, Boolean> getRequestValidator() {
        return this.requestValidator;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    public List<String> getBodyAppends() {
        return this.bodyAppends;
    }

    public void bodyAppend(String body) {
        if (this.bodyAppends == null) {
            this.bodyAppends = new ArrayList<String>();
        }
        this.bodyAppends.add(body);
    }

    public void log(Object ... args) {
        String log = new LogWrapper(args).toString();
        logger.info(log);
    }

    private Void setVariable(String name, Object value) {
        this.getEngine().put(name, value);
        return null;
    }

    public Object getMember(String key) {
        switch (key) {
            case "read": {
                return this::read;
            }
            case "readAsString": {
                return this::readAsString;
            }
            case "eval": {
                return this::eval;
            }
            case "evalWith": {
                return this::evalWith;
            }
            case "get": {
                return this.GET_FUNCTION;
            }
            case "set": {
                return this::setVariable;
            }
            case "log": {
                return this.LOG_FUNCTION;
            }
            case "uuid": {
                return UUID_FUNCTION;
            }
            case "copy": {
                return this.COPY_FUNCTION;
            }
            case "delay": {
                return this.DELAY_FUNCTION;
            }
            case "toString": {
                return this.TO_STRING_FUNCTION;
            }
            case "toJson": {
                return this::toJson;
            }
            case "toJs": {
                return this::toJs;
            }
            case "toJsonPretty": {
                return this::toJsonPretty;
            }
            case "fromJson": {
                return FROM_JSON_FUNCTION;
            }
            case "remove": {
                return REMOVE_FUNCTION;
            }
            case "redirect": {
                return this.REDIRECT_FUNCTION;
            }
            case "switch": {
                return this.SWITCH_FUNCTION;
            }
            case "switched": {
                return this.switched;
            }
            case "ajax": {
                return this.isAjax();
            }
            case "http": {
                return this.HTTP_FUNCTION;
            }
            case "nextId": {
                return this.NEXT_ID_FUNCTION;
            }
            case "sessionId": {
                return this.session == null ? null : this.session.getId();
            }
            case "init": {
                return this.INIT_FUNCTION;
            }
            case "close": {
                return this.CLOSE_FUNCTION;
            }
            case "closed": {
                return this.closed || this.session == null || this.session.isTemporary();
            }
            case "render": {
                return this.RENDER_FUNCTION;
            }
            case "bodyAppend": {
                return this::bodyAppend;
            }
            case "resolver": {
                return this.config.getResourceResolver();
            }
            case "caller": {
                return KarateEngineContext.get().getCallerTemplateName();
            }
            case "template": {
                return KarateEngineContext.get().getTemplateName();
            }
            case "typeOf": {
                return this.TYPE_OF_FUNCTION;
            }
            case "isPrimitive": {
                return this.IS_PRIMITIVE_FUNCTION;
            }
            case "isJson": {
                return this.IS_JSON_FUNCTION;
            }
            case "match": {
                return this.MATCH_FUNCTION;
            }
            case "joinPaths": {
                return this.JOIN_PATHS_FUNCTION;
            }
            case "flash": {
                return this.flash;
            }
        }
        logger.warn("no such property on context object: {}", (Object)key);
        return null;
    }

    public Object getMemberKeys() {
        return KEY_ARRAY;
    }

    public boolean hasMember(String key) {
        return KEY_SET.contains(key);
    }

    public void putMember(String key, Value value) {
        switch (key) {
            case "flash": {
                this.flash = JsValue.toJava(value);
                break;
            }
            default: {
                logger.warn("put not supported on context object: {} - {}", (Object)key, (Object)value);
            }
        }
    }

    static class LogWrapper {
        final Object[] values;

        LogWrapper(Object ... values) {
            this.values = values == null ? new Value[]{} : values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Object v : this.values) {
                Variable var = new Variable(v);
                sb.append(var.getAsPrettyString()).append(' ');
            }
            return sb.toString();
        }
    }
}

