/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.http.WebSocketClientHandler;
import com.intuit.karate.http.WebSocketListener;
import com.intuit.karate.http.WebSocketOptions;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import karate.io.netty.bootstrap.Bootstrap;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.channel.nio.NioEventLoopGroup;
import karate.io.netty.channel.socket.nio.NioSocketChannel;
import karate.io.netty.handler.codec.http.DefaultHttpHeaders;
import karate.io.netty.handler.codec.http.FullHttpRequest;
import karate.io.netty.handler.codec.http.HttpClientCodec;
import karate.io.netty.handler.codec.http.HttpObjectAggregator;
import karate.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import karate.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import karate.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import karate.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import karate.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import karate.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import karate.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import karate.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import karate.io.netty.handler.ssl.SslContext;
import karate.io.netty.handler.ssl.SslContextBuilder;
import karate.io.netty.handler.ssl.util.InsecureTrustManagerFactory;

public class WebSocketClient
implements WebSocketListener {
    private Logger logger;
    private final Channel channel;
    private final EventLoopGroup group;
    private final URI uri;
    private final int port;
    private final SslContext sslContext;
    private final WebSocketClientHandshaker handShaker;
    private final WebSocketClientHandler handler;
    private Function<String, Boolean> textHandler;
    private Function<byte[], Boolean> binaryHandler;
    private ScenarioEngine engine;
    private boolean waiting;

    public void setEngine(ScenarioEngine engine) {
        this.engine = engine;
    }

    @Override
    public void onMessage(String text) {
        if (this.textHandler != null && this.textHandler.apply(text).booleanValue() && this.engine != null) {
            this.engine.signal(text);
        }
    }

    @Override
    public void onMessage(byte[] bytes) {
        if (this.binaryHandler != null && this.binaryHandler.apply(bytes).booleanValue() && this.engine != null) {
            this.engine.signal(bytes);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public WebSocketClient(WebSocketOptions options, Logger logger) {
        this.logger = logger;
        this.textHandler = options.getTextHandler();
        this.binaryHandler = options.getBinaryHandler();
        this.uri = options.getUri();
        this.port = options.getPort();
        this.group = new NioEventLoopGroup();
        if (options.isSsl()) {
            try {
                this.sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.sslContext = null;
        }
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        Map<String, Object> headers = options.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> nettyHeaders.add((String)k, v));
        }
        this.handShaker = WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, options.getSubProtocol(), true, nettyHeaders, options.getMaxPayloadSize());
        this.handler = new WebSocketClientHandler(this.handShaker, this);
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    if (WebSocketClient.this.sslContext != null) {
                        p.addLast(WebSocketClient.this.sslContext.newHandler(c.alloc(), WebSocketClient.this.uri.getHost(), WebSocketClient.this.port));
                    }
                    p.addLast(new HttpClientCodec());
                    p.addLast(new HttpObjectAggregator(8192));
                    p.addLast(WebSocketClientCompressionHandler.INSTANCE);
                    p.addLast(WebSocketClient.this.handler);
                }
            });
            this.channel = b.connect(options.getUri().getHost(), options.getPort()).sync().channel();
            this.handler.handshakeFuture().sync();
        }
        catch (Exception e) {
            logger.error("websocket client init failed: {}", e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void setBinaryHandler(Function<byte[], Boolean> binaryHandler) {
        this.binaryHandler = binaryHandler;
    }

    public void setTextHandler(Function<String, Boolean> textHandler) {
        this.textHandler = textHandler;
    }

    public void waitSync() {
        if (this.waiting) {
            return;
        }
        try {
            this.waiting = true;
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.channel.writeAndFlush(new CloseWebSocketFrame());
        this.waitSync();
        this.group.shutdownGracefully();
    }

    public void ping() {
        PingWebSocketFrame frame = new PingWebSocketFrame(Unpooled.wrappedBuffer(new byte[]{8, 1, 8, 1}));
        this.channel.writeAndFlush(frame);
    }

    public void send(String msg) {
        TextWebSocketFrame frame = new TextWebSocketFrame(msg);
        this.channel.writeAndFlush(frame);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("sent: {}", msg);
        }
    }

    public void sendHttpRequest(FullHttpRequest request) {
        this.channel.writeAndFlush(request);
    }

    public void sendBytes(byte[] msg) {
        ByteBuf byteBuf = Unpooled.copiedBuffer(msg);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(byteBuf);
        this.channel.writeAndFlush(frame);
    }
}

