/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Logger;
import com.intuit.karate.http.WebSocketClient;
import com.intuit.karate.http.WebSocketOptions;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.SimpleChannelInboundHandler;
import karate.io.netty.handler.codec.http.FullHttpRequest;
import karate.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.LoggerFactory;

public class WebSocketProxyHandler
extends SimpleChannelInboundHandler<Object> {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(WebSocketProxyHandler.class);
    private final Logger logger = new Logger();
    private WebSocketClient client;
    private final WebSocketOptions options;
    private Channel channel;

    public WebSocketProxyHandler(WebSocketOptions options) {
        this.options = options;
    }

    private void initClient() {
        this.client = new WebSocketClient(this.options, this.logger){

            @Override
            public void onMessage(String text) {
                LOGGER.debug("<< {}", (Object)text);
                WebSocketProxyHandler.this.channel.eventLoop().submit(() -> WebSocketProxyHandler.this.channel.writeAndFlush(new TextWebSocketFrame(text)));
            }
        };
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.initClient();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            String request = ((TextWebSocketFrame)msg).text();
            LOGGER.debug(">> {}", (Object)request);
            this.client.send(request);
        } else if (msg instanceof FullHttpRequest) {
            this.client.ping();
        } else {
            String message = "unsupported frame type: " + msg.getClass().getName();
            LOGGER.warn(message);
        }
    }
}

