/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import java.net.InetSocketAddress;
import karate.io.netty.bootstrap.ServerBootstrap;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.channel.SimpleChannelInboundHandler;
import karate.io.netty.channel.nio.NioEventLoopGroup;
import karate.io.netty.channel.socket.nio.NioServerSocketChannel;
import karate.io.netty.handler.codec.http.HttpObjectAggregator;
import karate.io.netty.handler.codec.http.HttpServerCodec;
import karate.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import karate.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import karate.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerBase {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServerBase.class);
    private final Channel channel;
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    public WebSocketServerBase(int port, String path, final SimpleChannelInboundHandler handler) {
        this.port = port;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(8);
        final WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath(path).allowExtensions(true).checkStartsWith(true).build();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new HttpServerCodec());
                    p.addLast(new HttpObjectAggregator(65536));
                    p.addLast(new WebSocketServerCompressionHandler());
                    p.addLast(new WebSocketServerProtocolHandler(config));
                    p.addLast(handler);
                }
            });
            this.channel = b.bind(port).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            String host = "127.0.0.1";
            port = isa.getPort();
            logger.info("proxy server started - ws://{}:{}", (Object)host, (Object)port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

