/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.cert;

import com.intuit.karate.Logger;
import com.intuit.karate.http.cert.ThreadLocalInsecureRandom;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert.X509CertificateHolder;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.ContentSigner;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.handler.codec.base64.Base64;
import karate.io.netty.util.CharsetUtil;
import karate.io.netty.util.internal.PlatformDependent;
import karate.io.netty.util.internal.SystemPropertyUtil;
import karate.io.netty.util.internal.ThrowableUtil;

public final class SelfSignedCertGenerator {
    private static final Logger logger = new Logger();
    private static final Provider PROVIDER = Security.getProvider("SUN");
    private static final String DEFAULT_FQDN = "localhost";
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong("karate.io.netty.selfSignedCertificate.defaultNotBefore", System.currentTimeMillis() - 31536000000L));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong("karate.io.netty.selfSignedCertificate.defaultNotAfter", 253402300799000L));
    private static final String ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_LENGTH_BITS = SystemPropertyUtil.getInt("karate.io.netty.handler.ssl.util.selfSignedKeyStrength", 2048);
    private File certificate;
    private File privateKey;
    private X509Certificate cert;
    private PrivateKey key;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelfSignedCertGenerator() throws CertificateException {
        String[] paths;
        KeyPair keypair;
        SecureRandom random = ThreadLocalInsecureRandom.current();
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyGen.initialize(DEFAULT_KEY_LENGTH_BITS, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException var24) {
            throw new Error(var24);
        }
        try {
            paths = this.generate(DEFAULT_FQDN, keypair, random, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
        }
        catch (Throwable var23) {
            logger.debug("Failed to generate a self-signed X.509 certificate:", var23);
            CertificateException certificateException = new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.", var23);
            ThrowableUtil.addSuppressed((Throwable)certificateException, var23);
            throw certificateException;
        }
        this.certificate = new File(paths[0]);
        this.privateKey = new File(paths[1]);
        this.key = keypair.getPrivate();
        FileInputStream certificateInput = null;
        try {
            certificateInput = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(certificateInput);
            if (certificateInput == null) return;
        }
        catch (Exception var21) {
            try {
                throw new CertificateEncodingException(var21);
            }
            catch (Throwable throwable) {
                if (certificateInput == null) throw throwable;
                try {
                    certificateInput.close();
                    throw throwable;
                }
                catch (IOException var25) {
                    logger.warn("Failed to close a file: " + this.certificate, var25);
                }
                throw throwable;
            }
        }
        try {
            certificateInput.close();
            return;
        }
        catch (IOException var25) {
            logger.warn("Failed to close a file: " + this.certificate, var25);
            return;
        }
    }

    public File getCertificate() {
        return this.certificate;
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    private String[] generate(String fqdn, KeyPair keypair, SecureRandom random, Date notBefore, Date notAfter) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), notBefore, notAfter, owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        return this.newSelfSignedCertificate(fqdn, key, cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] newSelfSignedCertificate(String fqdn, PrivateKey key, X509Certificate cert) throws IOException, CertificateEncodingException {
        String certText;
        String keyText;
        ByteBuf encodedBuf;
        ByteBuf wrappedBuf = Unpooled.wrappedBuffer(key.getEncoded());
        try {
            encodedBuf = Base64.encode(wrappedBuf, true);
            try {
                keyText = "-----BEGIN PRIVATE KEY-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        fqdn = fqdn.replaceAll("[^\\w.-]", "x");
        File keyFile = PlatformDependent.createTempFile("keyutil_" + fqdn + "_", ".key", null);
        keyFile.deleteOnExit();
        FileOutputStream keyOut = new FileOutputStream(keyFile);
        try {
            ((OutputStream)keyOut).write(keyText.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)keyOut).close();
            keyOut = null;
        }
        finally {
            if (keyOut != null) {
                SelfSignedCertGenerator.safeClose(keyFile, keyOut);
                SelfSignedCertGenerator.safeDelete(keyFile);
            }
        }
        wrappedBuf = Unpooled.wrappedBuffer(cert.getEncoded());
        try {
            encodedBuf = Base64.encode(wrappedBuf, true);
            try {
                certText = "-----BEGIN CERTIFICATE-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        File certFile = PlatformDependent.createTempFile("keyutil_" + fqdn + "_", ".crt", null);
        certFile.deleteOnExit();
        FileOutputStream certOut = new FileOutputStream(certFile);
        try {
            ((OutputStream)certOut).write(certText.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)certOut).close();
            certOut = null;
        }
        finally {
            if (certOut != null) {
                SelfSignedCertGenerator.safeClose(certFile, certOut);
                SelfSignedCertGenerator.safeDelete(certFile);
                SelfSignedCertGenerator.safeDelete(keyFile);
            }
        }
        return new String[]{certFile.getPath(), keyFile.getPath()};
    }

    private static void safeDelete(File certFile) {
        if (!certFile.delete()) {
            logger.warn("Failed to delete a file: " + certFile, new Object[0]);
        }
    }

    private static void safeClose(File keyFile, OutputStream keyOut) {
        try {
            keyOut.close();
        }
        catch (IOException var3) {
            logger.warn("Failed to close a file: " + keyFile, var3);
        }
    }
}

