/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.resource.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;

public class FileResource
implements Resource {
    private final File file;
    private final boolean classPath;
    private final String relativePath;

    public FileResource(File file) {
        this(file, false);
    }

    private FileResource(File file, boolean classpath) {
        this(file, classpath, file.getPath());
    }

    public FileResource(File file, boolean classPath, String relativePath) {
        this.file = file;
        this.classPath = classPath;
        this.relativePath = relativePath.replace('\\', '/');
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getUri() {
        return this.file.toPath().toUri();
    }

    @Override
    public boolean isClassPath() {
        return this.classPath;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public Resource resolve(String path) {
        int pos = this.relativePath.lastIndexOf(47);
        Object childPath = pos == -1 ? path : this.relativePath.substring(0, pos) + File.separator + path;
        File child = new File(this.file.getAbsoluteFile().getParent() + File.separator + path);
        return new FileResource(child, this.classPath, (String)childPath);
    }

    @Override
    public InputStream getStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        return this.file.equals(obj);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.getPrefixedPath();
    }
}

